package zio.aws.apigateway.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class GetStagesResponse(
    item: Option[Iterable[zio.aws.apigateway.model.Stage]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.apigateway.model.GetStagesResponse = {
    import GetStagesResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.apigateway.model.GetStagesResponse
      .builder()
      .optionallyWith(
        item.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.item)
      .build()
  }
  def asReadOnly: zio.aws.apigateway.model.GetStagesResponse.ReadOnly =
    zio.aws.apigateway.model.GetStagesResponse.wrap(buildAwsValue())
}
object GetStagesResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.apigateway.model.GetStagesResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.apigateway.model.GetStagesResponse =
      zio.aws.apigateway.model.GetStagesResponse(
        item.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def item: Option[List[zio.aws.apigateway.model.Stage.ReadOnly]]
    def getItem
        : ZIO[Any, AwsError, List[zio.aws.apigateway.model.Stage.ReadOnly]] =
      AwsError.unwrapOptionField("item", item)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.apigateway.model.GetStagesResponse
  ) extends zio.aws.apigateway.model.GetStagesResponse.ReadOnly {
    override val item: Option[List[zio.aws.apigateway.model.Stage.ReadOnly]] =
      scala
        .Option(impl.item())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.apigateway.model.Stage.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.apigateway.model.GetStagesResponse
  ): zio.aws.apigateway.model.GetStagesResponse.ReadOnly = new Wrapper(impl)
}
