package zio.aws.apigateway.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class GetUsagePlanKeysResponse(
    position: Option[String] = None,
    items: Option[Iterable[zio.aws.apigateway.model.UsagePlanKey]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.apigateway.model.GetUsagePlanKeysResponse = {
    import GetUsagePlanKeysResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.apigateway.model.GetUsagePlanKeysResponse
      .builder()
      .optionallyWith(position.map(value => value: java.lang.String))(
        _.position
      )
      .optionallyWith(
        items.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.items)
      .build()
  }
  def asReadOnly: zio.aws.apigateway.model.GetUsagePlanKeysResponse.ReadOnly =
    zio.aws.apigateway.model.GetUsagePlanKeysResponse.wrap(buildAwsValue())
}
object GetUsagePlanKeysResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.apigateway.model.GetUsagePlanKeysResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.apigateway.model.GetUsagePlanKeysResponse =
      zio.aws.apigateway.model.GetUsagePlanKeysResponse(
        position.map(value => value),
        items.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def position: Option[String]
    def items: Option[List[zio.aws.apigateway.model.UsagePlanKey.ReadOnly]]
    def getPosition: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("position", position)
    def getItems: ZIO[Any, AwsError, List[
      zio.aws.apigateway.model.UsagePlanKey.ReadOnly
    ]] = AwsError.unwrapOptionField("items", items)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.apigateway.model.GetUsagePlanKeysResponse
  ) extends zio.aws.apigateway.model.GetUsagePlanKeysResponse.ReadOnly {
    override val position: Option[String] =
      scala.Option(impl.position()).map(value => value: String)
    override val items
        : Option[List[zio.aws.apigateway.model.UsagePlanKey.ReadOnly]] = scala
      .Option(impl.items())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.apigateway.model.UsagePlanKey.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.apigateway.model.GetUsagePlanKeysResponse
  ): zio.aws.apigateway.model.GetUsagePlanKeysResponse.ReadOnly = new Wrapper(
    impl
  )
}
