package zio.aws.apigateway.model
import java.lang.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.apigateway.model.primitives.NullableInteger
import scala.jdk.CollectionConverters.*
final case class GetVpcLinksRequest(
    position: Option[String] = None,
    limit: Option[NullableInteger] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.apigateway.model.GetVpcLinksRequest = {
    import GetVpcLinksRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.apigateway.model.GetVpcLinksRequest
      .builder()
      .optionallyWith(position.map(value => value: java.lang.String))(
        _.position
      )
      .optionallyWith(
        limit.map(value => NullableInteger.unwrap(value): Integer)
      )(_.limit)
      .build()
  }
  def asReadOnly: zio.aws.apigateway.model.GetVpcLinksRequest.ReadOnly =
    zio.aws.apigateway.model.GetVpcLinksRequest.wrap(buildAwsValue())
}
object GetVpcLinksRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.apigateway.model.GetVpcLinksRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.apigateway.model.GetVpcLinksRequest =
      zio.aws.apigateway.model.GetVpcLinksRequest(
        position.map(value => value),
        limit.map(value => value)
      )
    def position: Option[String]
    def limit: Option[NullableInteger]
    def getPosition: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("position", position)
    def getLimit: ZIO[Any, AwsError, NullableInteger] =
      AwsError.unwrapOptionField("limit", limit)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.apigateway.model.GetVpcLinksRequest
  ) extends zio.aws.apigateway.model.GetVpcLinksRequest.ReadOnly {
    override val position: Option[String] =
      scala.Option(impl.position()).map(value => value: String)
    override val limit: Option[NullableInteger] = scala
      .Option(impl.limit())
      .map(value => zio.aws.apigateway.model.primitives.NullableInteger(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.apigateway.model.GetVpcLinksRequest
  ): zio.aws.apigateway.model.GetVpcLinksRequest.ReadOnly = new Wrapper(impl)
}
