package zio.aws.apigateway.model
import zio.aws.apigateway.model.primitives.{NullableInteger, Timestamp}
import java.time.Instant
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters.*
final case class ImportRestApiResponse(
    id: Option[String] = None,
    name: Option[String] = None,
    description: Option[String] = None,
    createdDate: Option[Timestamp] = None,
    version: Option[String] = None,
    warnings: Option[Iterable[String]] = None,
    binaryMediaTypes: Option[Iterable[String]] = None,
    minimumCompressionSize: Option[NullableInteger] = None,
    apiKeySource: Option[zio.aws.apigateway.model.ApiKeySourceType] = None,
    endpointConfiguration: Option[
      zio.aws.apigateway.model.EndpointConfiguration
    ] = None,
    policy: Option[String] = None,
    tags: Option[Map[String, String]] = None,
    disableExecuteApiEndpoint: Option[Boolean] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.apigateway.model.ImportRestApiResponse = {
    import ImportRestApiResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.apigateway.model.ImportRestApiResponse
      .builder()
      .optionallyWith(id.map(value => value: java.lang.String))(_.id)
      .optionallyWith(name.map(value => value: java.lang.String))(_.name)
      .optionallyWith(description.map(value => value: java.lang.String))(
        _.description
      )
      .optionallyWith(
        createdDate.map(value => Timestamp.unwrap(value): Instant)
      )(_.createdDate)
      .optionallyWith(version.map(value => value: java.lang.String))(_.version)
      .optionallyWith(
        warnings.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.warnings)
      .optionallyWith(
        binaryMediaTypes.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.binaryMediaTypes)
      .optionallyWith(
        minimumCompressionSize.map(value =>
          NullableInteger.unwrap(value): Integer
        )
      )(_.minimumCompressionSize)
      .optionallyWith(apiKeySource.map(value => value.unwrap))(_.apiKeySource)
      .optionallyWith(
        endpointConfiguration.map(value => value.buildAwsValue())
      )(_.endpointConfiguration)
      .optionallyWith(policy.map(value => value: java.lang.String))(_.policy)
      .optionallyWith(
        tags.map(value =>
          value
            .map({ case (key, value) =>
              (key: java.lang.String) -> (value: java.lang.String)
            })
            .asJava
        )
      )(_.tags)
      .optionallyWith(
        disableExecuteApiEndpoint.map(value => value: java.lang.Boolean)
      )(_.disableExecuteApiEndpoint)
      .build()
  }
  def asReadOnly: zio.aws.apigateway.model.ImportRestApiResponse.ReadOnly =
    zio.aws.apigateway.model.ImportRestApiResponse.wrap(buildAwsValue())
}
object ImportRestApiResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.apigateway.model.ImportRestApiResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.apigateway.model.ImportRestApiResponse =
      zio.aws.apigateway.model.ImportRestApiResponse(
        id.map(value => value),
        name.map(value => value),
        description.map(value => value),
        createdDate.map(value => value),
        version.map(value => value),
        warnings.map(value => value),
        binaryMediaTypes.map(value => value),
        minimumCompressionSize.map(value => value),
        apiKeySource.map(value => value),
        endpointConfiguration.map(value => value.asEditable),
        policy.map(value => value),
        tags.map(value => value),
        disableExecuteApiEndpoint.map(value => value)
      )
    def id: Option[String]
    def name: Option[String]
    def description: Option[String]
    def createdDate: Option[Timestamp]
    def version: Option[String]
    def warnings: Option[List[String]]
    def binaryMediaTypes: Option[List[String]]
    def minimumCompressionSize: Option[NullableInteger]
    def apiKeySource: Option[zio.aws.apigateway.model.ApiKeySourceType]
    def endpointConfiguration
        : Option[zio.aws.apigateway.model.EndpointConfiguration.ReadOnly]
    def policy: Option[String]
    def tags: Option[Map[String, String]]
    def disableExecuteApiEndpoint: Option[Boolean]
    def getId: ZIO[Any, AwsError, String] = AwsError.unwrapOptionField("id", id)
    def getName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("name", name)
    def getDescription: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("description", description)
    def getCreatedDate: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("createdDate", createdDate)
    def getVersion: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("version", version)
    def getWarnings: ZIO[Any, AwsError, List[String]] =
      AwsError.unwrapOptionField("warnings", warnings)
    def getBinaryMediaTypes: ZIO[Any, AwsError, List[String]] =
      AwsError.unwrapOptionField("binaryMediaTypes", binaryMediaTypes)
    def getMinimumCompressionSize: ZIO[Any, AwsError, NullableInteger] =
      AwsError.unwrapOptionField(
        "minimumCompressionSize",
        minimumCompressionSize
      )
    def getApiKeySource
        : ZIO[Any, AwsError, zio.aws.apigateway.model.ApiKeySourceType] =
      AwsError.unwrapOptionField("apiKeySource", apiKeySource)
    def getEndpointConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.apigateway.model.EndpointConfiguration.ReadOnly
    ] =
      AwsError.unwrapOptionField("endpointConfiguration", endpointConfiguration)
    def getPolicy: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("policy", policy)
    def getTags: ZIO[Any, AwsError, Map[String, String]] =
      AwsError.unwrapOptionField("tags", tags)
    def getDisableExecuteApiEndpoint: ZIO[Any, AwsError, Boolean] = AwsError
      .unwrapOptionField("disableExecuteApiEndpoint", disableExecuteApiEndpoint)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.apigateway.model.ImportRestApiResponse
  ) extends zio.aws.apigateway.model.ImportRestApiResponse.ReadOnly {
    override val id: Option[String] =
      scala.Option(impl.id()).map(value => value: String)
    override val name: Option[String] =
      scala.Option(impl.name()).map(value => value: String)
    override val description: Option[String] =
      scala.Option(impl.description()).map(value => value: String)
    override val createdDate: Option[Timestamp] = scala
      .Option(impl.createdDate())
      .map(value => zio.aws.apigateway.model.primitives.Timestamp(value))
    override val version: Option[String] =
      scala.Option(impl.version()).map(value => value: String)
    override val warnings: Option[List[String]] = scala
      .Option(impl.warnings())
      .map(value =>
        value.asScala.map { item =>
          item: String
        }.toList
      )
    override val binaryMediaTypes: Option[List[String]] = scala
      .Option(impl.binaryMediaTypes())
      .map(value =>
        value.asScala.map { item =>
          item: String
        }.toList
      )
    override val minimumCompressionSize: Option[NullableInteger] = scala
      .Option(impl.minimumCompressionSize())
      .map(value => zio.aws.apigateway.model.primitives.NullableInteger(value))
    override val apiKeySource
        : Option[zio.aws.apigateway.model.ApiKeySourceType] = scala
      .Option(impl.apiKeySource())
      .map(value => zio.aws.apigateway.model.ApiKeySourceType.wrap(value))
    override val endpointConfiguration
        : Option[zio.aws.apigateway.model.EndpointConfiguration.ReadOnly] =
      scala
        .Option(impl.endpointConfiguration())
        .map(value =>
          zio.aws.apigateway.model.EndpointConfiguration.wrap(value)
        )
    override val policy: Option[String] =
      scala.Option(impl.policy()).map(value => value: String)
    override val tags: Option[Map[String, String]] = scala
      .Option(impl.tags())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            (key: String) -> (value: String)
          })
          .toMap
      )
    override val disableExecuteApiEndpoint: Option[Boolean] = scala
      .Option(impl.disableExecuteApiEndpoint())
      .map(value => value: Boolean)
  }
  def wrap(
      impl: software.amazon.awssdk.services.apigateway.model.ImportRestApiResponse
  ): zio.aws.apigateway.model.ImportRestApiResponse.ReadOnly = new Wrapper(impl)
}
