package zio.aws.apigateway.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.apigateway.model.primitives.Integer
import scala.jdk.CollectionConverters.*
final case class Integration(
    `type`: Option[zio.aws.apigateway.model.IntegrationType] = None,
    httpMethod: Option[String] = None,
    uri: Option[String] = None,
    connectionType: Option[zio.aws.apigateway.model.ConnectionType] = None,
    connectionId: Option[String] = None,
    credentials: Option[String] = None,
    requestParameters: Option[Map[String, String]] = None,
    requestTemplates: Option[Map[String, String]] = None,
    passthroughBehavior: Option[String] = None,
    contentHandling: Option[zio.aws.apigateway.model.ContentHandlingStrategy] =
      None,
    timeoutInMillis: Option[Integer] = None,
    cacheNamespace: Option[String] = None,
    cacheKeyParameters: Option[Iterable[String]] = None,
    integrationResponses: Option[
      Map[String, zio.aws.apigateway.model.IntegrationResponse]
    ] = None,
    tlsConfig: Option[zio.aws.apigateway.model.TlsConfig] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.apigateway.model.Integration = {
    import Integration.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.apigateway.model.Integration
      .builder()
      .optionallyWith(`type`.map(value => value.unwrap))(_.`type`)
      .optionallyWith(httpMethod.map(value => value: java.lang.String))(
        _.httpMethod
      )
      .optionallyWith(uri.map(value => value: java.lang.String))(_.uri)
      .optionallyWith(connectionType.map(value => value.unwrap))(
        _.connectionType
      )
      .optionallyWith(connectionId.map(value => value: java.lang.String))(
        _.connectionId
      )
      .optionallyWith(credentials.map(value => value: java.lang.String))(
        _.credentials
      )
      .optionallyWith(
        requestParameters.map(value =>
          value
            .map({ case (key, value) =>
              (key: java.lang.String) -> (value: java.lang.String)
            })
            .asJava
        )
      )(_.requestParameters)
      .optionallyWith(
        requestTemplates.map(value =>
          value
            .map({ case (key, value) =>
              (key: java.lang.String) -> (value: java.lang.String)
            })
            .asJava
        )
      )(_.requestTemplates)
      .optionallyWith(
        passthroughBehavior.map(value => value: java.lang.String)
      )(_.passthroughBehavior)
      .optionallyWith(contentHandling.map(value => value.unwrap))(
        _.contentHandling
      )
      .optionallyWith(
        timeoutInMillis.map(value => Integer.unwrap(value): java.lang.Integer)
      )(_.timeoutInMillis)
      .optionallyWith(cacheNamespace.map(value => value: java.lang.String))(
        _.cacheNamespace
      )
      .optionallyWith(
        cacheKeyParameters.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.cacheKeyParameters)
      .optionallyWith(
        integrationResponses.map(value =>
          value
            .map({ case (key, value) =>
              (key: java.lang.String) -> value.buildAwsValue()
            })
            .asJava
        )
      )(_.integrationResponses)
      .optionallyWith(tlsConfig.map(value => value.buildAwsValue()))(
        _.tlsConfig
      )
      .build()
  }
  def asReadOnly: zio.aws.apigateway.model.Integration.ReadOnly =
    zio.aws.apigateway.model.Integration.wrap(buildAwsValue())
}
object Integration {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.apigateway.model.Integration
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.apigateway.model.Integration =
      zio.aws.apigateway.model.Integration(
        `type`.map(value => value),
        httpMethod.map(value => value),
        uri.map(value => value),
        connectionType.map(value => value),
        connectionId.map(value => value),
        credentials.map(value => value),
        requestParameters.map(value => value),
        requestTemplates.map(value => value),
        passthroughBehavior.map(value => value),
        contentHandling.map(value => value),
        timeoutInMillis.map(value => value),
        cacheNamespace.map(value => value),
        cacheKeyParameters.map(value => value),
        integrationResponses.map(value =>
          value.map({ case (key, value) =>
            key -> value.asEditable
          })
        ),
        tlsConfig.map(value => value.asEditable)
      )
    def `type`: Option[zio.aws.apigateway.model.IntegrationType]
    def httpMethod: Option[String]
    def uri: Option[String]
    def connectionType: Option[zio.aws.apigateway.model.ConnectionType]
    def connectionId: Option[String]
    def credentials: Option[String]
    def requestParameters: Option[Map[String, String]]
    def requestTemplates: Option[Map[String, String]]
    def passthroughBehavior: Option[String]
    def contentHandling
        : Option[zio.aws.apigateway.model.ContentHandlingStrategy]
    def timeoutInMillis: Option[Integer]
    def cacheNamespace: Option[String]
    def cacheKeyParameters: Option[List[String]]
    def integrationResponses: Option[
      Map[String, zio.aws.apigateway.model.IntegrationResponse.ReadOnly]
    ]
    def tlsConfig: Option[zio.aws.apigateway.model.TlsConfig.ReadOnly]
    def getType: ZIO[Any, AwsError, zio.aws.apigateway.model.IntegrationType] =
      AwsError.unwrapOptionField("type", `type`)
    def getHttpMethod: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("httpMethod", httpMethod)
    def getUri: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("uri", uri)
    def getConnectionType
        : ZIO[Any, AwsError, zio.aws.apigateway.model.ConnectionType] =
      AwsError.unwrapOptionField("connectionType", connectionType)
    def getConnectionId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("connectionId", connectionId)
    def getCredentials: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("credentials", credentials)
    def getRequestParameters: ZIO[Any, AwsError, Map[String, String]] =
      AwsError.unwrapOptionField("requestParameters", requestParameters)
    def getRequestTemplates: ZIO[Any, AwsError, Map[String, String]] =
      AwsError.unwrapOptionField("requestTemplates", requestTemplates)
    def getPassthroughBehavior: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("passthroughBehavior", passthroughBehavior)
    def getContentHandling
        : ZIO[Any, AwsError, zio.aws.apigateway.model.ContentHandlingStrategy] =
      AwsError.unwrapOptionField("contentHandling", contentHandling)
    def getTimeoutInMillis: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("timeoutInMillis", timeoutInMillis)
    def getCacheNamespace: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("cacheNamespace", cacheNamespace)
    def getCacheKeyParameters: ZIO[Any, AwsError, List[String]] =
      AwsError.unwrapOptionField("cacheKeyParameters", cacheKeyParameters)
    def getIntegrationResponses: ZIO[Any, AwsError, Map[
      String,
      zio.aws.apigateway.model.IntegrationResponse.ReadOnly
    ]] =
      AwsError.unwrapOptionField("integrationResponses", integrationResponses)
    def getTlsConfig
        : ZIO[Any, AwsError, zio.aws.apigateway.model.TlsConfig.ReadOnly] =
      AwsError.unwrapOptionField("tlsConfig", tlsConfig)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.apigateway.model.Integration
  ) extends zio.aws.apigateway.model.Integration.ReadOnly {
    override val `type`: Option[zio.aws.apigateway.model.IntegrationType] =
      scala
        .Option(impl.`type`())
        .map(value => zio.aws.apigateway.model.IntegrationType.wrap(value))
    override val httpMethod: Option[String] =
      scala.Option(impl.httpMethod()).map(value => value: String)
    override val uri: Option[String] =
      scala.Option(impl.uri()).map(value => value: String)
    override val connectionType
        : Option[zio.aws.apigateway.model.ConnectionType] = scala
      .Option(impl.connectionType())
      .map(value => zio.aws.apigateway.model.ConnectionType.wrap(value))
    override val connectionId: Option[String] =
      scala.Option(impl.connectionId()).map(value => value: String)
    override val credentials: Option[String] =
      scala.Option(impl.credentials()).map(value => value: String)
    override val requestParameters: Option[Map[String, String]] = scala
      .Option(impl.requestParameters())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            (key: String) -> (value: String)
          })
          .toMap
      )
    override val requestTemplates: Option[Map[String, String]] = scala
      .Option(impl.requestTemplates())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            (key: String) -> (value: String)
          })
          .toMap
      )
    override val passthroughBehavior: Option[String] =
      scala.Option(impl.passthroughBehavior()).map(value => value: String)
    override val contentHandling
        : Option[zio.aws.apigateway.model.ContentHandlingStrategy] = scala
      .Option(impl.contentHandling())
      .map(value =>
        zio.aws.apigateway.model.ContentHandlingStrategy.wrap(value)
      )
    override val timeoutInMillis: Option[Integer] = scala
      .Option(impl.timeoutInMillis())
      .map(value => zio.aws.apigateway.model.primitives.Integer(value))
    override val cacheNamespace: Option[String] =
      scala.Option(impl.cacheNamespace()).map(value => value: String)
    override val cacheKeyParameters: Option[List[String]] = scala
      .Option(impl.cacheKeyParameters())
      .map(value =>
        value.asScala.map { item =>
          item: String
        }.toList
      )
    override val integrationResponses: Option[
      Map[String, zio.aws.apigateway.model.IntegrationResponse.ReadOnly]
    ] = scala
      .Option(impl.integrationResponses())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            (key: String) -> zio.aws.apigateway.model.IntegrationResponse
              .wrap(value)
          })
          .toMap
      )
    override val tlsConfig
        : Option[zio.aws.apigateway.model.TlsConfig.ReadOnly] = scala
      .Option(impl.tlsConfig())
      .map(value => zio.aws.apigateway.model.TlsConfig.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.apigateway.model.Integration
  ): zio.aws.apigateway.model.Integration.ReadOnly = new Wrapper(impl)
}
