package zio.aws.apigateway.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.apigateway.model.primitives.Integer
import scala.jdk.CollectionConverters.*
final case class MethodSetting(
    metricsEnabled: Option[Boolean] = None,
    loggingLevel: Option[String] = None,
    dataTraceEnabled: Option[Boolean] = None,
    throttlingBurstLimit: Option[Integer] = None,
    throttlingRateLimit: Option[Double] = None,
    cachingEnabled: Option[Boolean] = None,
    cacheTtlInSeconds: Option[Integer] = None,
    cacheDataEncrypted: Option[Boolean] = None,
    requireAuthorizationForCacheControl: Option[Boolean] = None,
    unauthorizedCacheControlHeaderStrategy: Option[
      zio.aws.apigateway.model.UnauthorizedCacheControlHeaderStrategy
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.apigateway.model.MethodSetting = {
    import MethodSetting.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.apigateway.model.MethodSetting
      .builder()
      .optionallyWith(metricsEnabled.map(value => value: java.lang.Boolean))(
        _.metricsEnabled
      )
      .optionallyWith(loggingLevel.map(value => value: java.lang.String))(
        _.loggingLevel
      )
      .optionallyWith(dataTraceEnabled.map(value => value: java.lang.Boolean))(
        _.dataTraceEnabled
      )
      .optionallyWith(
        throttlingBurstLimit.map(value =>
          Integer.unwrap(value): java.lang.Integer
        )
      )(_.throttlingBurstLimit)
      .optionallyWith(
        throttlingRateLimit.map(value => value: java.lang.Double)
      )(_.throttlingRateLimit)
      .optionallyWith(cachingEnabled.map(value => value: java.lang.Boolean))(
        _.cachingEnabled
      )
      .optionallyWith(
        cacheTtlInSeconds.map(value => Integer.unwrap(value): java.lang.Integer)
      )(_.cacheTtlInSeconds)
      .optionallyWith(
        cacheDataEncrypted.map(value => value: java.lang.Boolean)
      )(_.cacheDataEncrypted)
      .optionallyWith(
        requireAuthorizationForCacheControl.map(value =>
          value: java.lang.Boolean
        )
      )(_.requireAuthorizationForCacheControl)
      .optionallyWith(
        unauthorizedCacheControlHeaderStrategy.map(value => value.unwrap)
      )(_.unauthorizedCacheControlHeaderStrategy)
      .build()
  }
  def asReadOnly: zio.aws.apigateway.model.MethodSetting.ReadOnly =
    zio.aws.apigateway.model.MethodSetting.wrap(buildAwsValue())
}
object MethodSetting {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.apigateway.model.MethodSetting
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.apigateway.model.MethodSetting =
      zio.aws.apigateway.model.MethodSetting(
        metricsEnabled.map(value => value),
        loggingLevel.map(value => value),
        dataTraceEnabled.map(value => value),
        throttlingBurstLimit.map(value => value),
        throttlingRateLimit.map(value => value),
        cachingEnabled.map(value => value),
        cacheTtlInSeconds.map(value => value),
        cacheDataEncrypted.map(value => value),
        requireAuthorizationForCacheControl.map(value => value),
        unauthorizedCacheControlHeaderStrategy.map(value => value)
      )
    def metricsEnabled: Option[Boolean]
    def loggingLevel: Option[String]
    def dataTraceEnabled: Option[Boolean]
    def throttlingBurstLimit: Option[Integer]
    def throttlingRateLimit: Option[Double]
    def cachingEnabled: Option[Boolean]
    def cacheTtlInSeconds: Option[Integer]
    def cacheDataEncrypted: Option[Boolean]
    def requireAuthorizationForCacheControl: Option[Boolean]
    def unauthorizedCacheControlHeaderStrategy: Option[
      zio.aws.apigateway.model.UnauthorizedCacheControlHeaderStrategy
    ]
    def getMetricsEnabled: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("metricsEnabled", metricsEnabled)
    def getLoggingLevel: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("loggingLevel", loggingLevel)
    def getDataTraceEnabled: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("dataTraceEnabled", dataTraceEnabled)
    def getThrottlingBurstLimit: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("throttlingBurstLimit", throttlingBurstLimit)
    def getThrottlingRateLimit: ZIO[Any, AwsError, Double] =
      AwsError.unwrapOptionField("throttlingRateLimit", throttlingRateLimit)
    def getCachingEnabled: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("cachingEnabled", cachingEnabled)
    def getCacheTtlInSeconds: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("cacheTtlInSeconds", cacheTtlInSeconds)
    def getCacheDataEncrypted: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("cacheDataEncrypted", cacheDataEncrypted)
    def getRequireAuthorizationForCacheControl: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField(
        "requireAuthorizationForCacheControl",
        requireAuthorizationForCacheControl
      )
    def getUnauthorizedCacheControlHeaderStrategy: ZIO[
      Any,
      AwsError,
      zio.aws.apigateway.model.UnauthorizedCacheControlHeaderStrategy
    ] = AwsError.unwrapOptionField(
      "unauthorizedCacheControlHeaderStrategy",
      unauthorizedCacheControlHeaderStrategy
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.apigateway.model.MethodSetting
  ) extends zio.aws.apigateway.model.MethodSetting.ReadOnly {
    override val metricsEnabled: Option[Boolean] =
      scala.Option(impl.metricsEnabled()).map(value => value: Boolean)
    override val loggingLevel: Option[String] =
      scala.Option(impl.loggingLevel()).map(value => value: String)
    override val dataTraceEnabled: Option[Boolean] =
      scala.Option(impl.dataTraceEnabled()).map(value => value: Boolean)
    override val throttlingBurstLimit: Option[Integer] = scala
      .Option(impl.throttlingBurstLimit())
      .map(value => zio.aws.apigateway.model.primitives.Integer(value))
    override val throttlingRateLimit: Option[Double] =
      scala.Option(impl.throttlingRateLimit()).map(value => value: Double)
    override val cachingEnabled: Option[Boolean] =
      scala.Option(impl.cachingEnabled()).map(value => value: Boolean)
    override val cacheTtlInSeconds: Option[Integer] = scala
      .Option(impl.cacheTtlInSeconds())
      .map(value => zio.aws.apigateway.model.primitives.Integer(value))
    override val cacheDataEncrypted: Option[Boolean] =
      scala.Option(impl.cacheDataEncrypted()).map(value => value: Boolean)
    override val requireAuthorizationForCacheControl: Option[Boolean] = scala
      .Option(impl.requireAuthorizationForCacheControl())
      .map(value => value: Boolean)
    override val unauthorizedCacheControlHeaderStrategy: Option[
      zio.aws.apigateway.model.UnauthorizedCacheControlHeaderStrategy
    ] = scala
      .Option(impl.unauthorizedCacheControlHeaderStrategy())
      .map(value =>
        zio.aws.apigateway.model.UnauthorizedCacheControlHeaderStrategy
          .wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.apigateway.model.MethodSetting
  ): zio.aws.apigateway.model.MethodSetting.ReadOnly = new Wrapper(impl)
}
