package zio.aws.apigateway.model
import java.lang.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.apigateway.model.primitives.NullableInteger
import scala.jdk.CollectionConverters.*
final case class PutIntegrationRequest(
    restApiId: String,
    resourceId: String,
    httpMethod: String,
    `type`: zio.aws.apigateway.model.IntegrationType,
    integrationHttpMethod: Option[String] = None,
    uri: Option[String] = None,
    connectionType: Option[zio.aws.apigateway.model.ConnectionType] = None,
    connectionId: Option[String] = None,
    credentials: Option[String] = None,
    requestParameters: Option[Map[String, String]] = None,
    requestTemplates: Option[Map[String, String]] = None,
    passthroughBehavior: Option[String] = None,
    cacheNamespace: Option[String] = None,
    cacheKeyParameters: Option[Iterable[String]] = None,
    contentHandling: Option[zio.aws.apigateway.model.ContentHandlingStrategy] =
      None,
    timeoutInMillis: Option[NullableInteger] = None,
    tlsConfig: Option[zio.aws.apigateway.model.TlsConfig] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.apigateway.model.PutIntegrationRequest = {
    import PutIntegrationRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.apigateway.model.PutIntegrationRequest
      .builder()
      .restApiId(restApiId: java.lang.String)
      .resourceId(resourceId: java.lang.String)
      .httpMethod(httpMethod: java.lang.String)
      .`type`(`type`.unwrap)
      .optionallyWith(
        integrationHttpMethod.map(value => value: java.lang.String)
      )(_.integrationHttpMethod)
      .optionallyWith(uri.map(value => value: java.lang.String))(_.uri)
      .optionallyWith(connectionType.map(value => value.unwrap))(
        _.connectionType
      )
      .optionallyWith(connectionId.map(value => value: java.lang.String))(
        _.connectionId
      )
      .optionallyWith(credentials.map(value => value: java.lang.String))(
        _.credentials
      )
      .optionallyWith(
        requestParameters.map(value =>
          value
            .map({ case (key, value) =>
              (key: java.lang.String) -> (value: java.lang.String)
            })
            .asJava
        )
      )(_.requestParameters)
      .optionallyWith(
        requestTemplates.map(value =>
          value
            .map({ case (key, value) =>
              (key: java.lang.String) -> (value: java.lang.String)
            })
            .asJava
        )
      )(_.requestTemplates)
      .optionallyWith(
        passthroughBehavior.map(value => value: java.lang.String)
      )(_.passthroughBehavior)
      .optionallyWith(cacheNamespace.map(value => value: java.lang.String))(
        _.cacheNamespace
      )
      .optionallyWith(
        cacheKeyParameters.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.cacheKeyParameters)
      .optionallyWith(contentHandling.map(value => value.unwrap))(
        _.contentHandling
      )
      .optionallyWith(
        timeoutInMillis.map(value => NullableInteger.unwrap(value): Integer)
      )(_.timeoutInMillis)
      .optionallyWith(tlsConfig.map(value => value.buildAwsValue()))(
        _.tlsConfig
      )
      .build()
  }
  def asReadOnly: zio.aws.apigateway.model.PutIntegrationRequest.ReadOnly =
    zio.aws.apigateway.model.PutIntegrationRequest.wrap(buildAwsValue())
}
object PutIntegrationRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.apigateway.model.PutIntegrationRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.apigateway.model.PutIntegrationRequest =
      zio.aws.apigateway.model.PutIntegrationRequest(
        restApiId,
        resourceId,
        httpMethod,
        `type`,
        integrationHttpMethod.map(value => value),
        uri.map(value => value),
        connectionType.map(value => value),
        connectionId.map(value => value),
        credentials.map(value => value),
        requestParameters.map(value => value),
        requestTemplates.map(value => value),
        passthroughBehavior.map(value => value),
        cacheNamespace.map(value => value),
        cacheKeyParameters.map(value => value),
        contentHandling.map(value => value),
        timeoutInMillis.map(value => value),
        tlsConfig.map(value => value.asEditable)
      )
    def restApiId: String
    def resourceId: String
    def httpMethod: String
    def `type`: zio.aws.apigateway.model.IntegrationType
    def integrationHttpMethod: Option[String]
    def uri: Option[String]
    def connectionType: Option[zio.aws.apigateway.model.ConnectionType]
    def connectionId: Option[String]
    def credentials: Option[String]
    def requestParameters: Option[Map[String, String]]
    def requestTemplates: Option[Map[String, String]]
    def passthroughBehavior: Option[String]
    def cacheNamespace: Option[String]
    def cacheKeyParameters: Option[List[String]]
    def contentHandling
        : Option[zio.aws.apigateway.model.ContentHandlingStrategy]
    def timeoutInMillis: Option[NullableInteger]
    def tlsConfig: Option[zio.aws.apigateway.model.TlsConfig.ReadOnly]
    def getRestApiId: ZIO[Any, Nothing, String] = ZIO.succeed(restApiId)
    def getResourceId: ZIO[Any, Nothing, String] = ZIO.succeed(resourceId)
    def getHttpMethod: ZIO[Any, Nothing, String] = ZIO.succeed(httpMethod)
    def getType: ZIO[Any, Nothing, zio.aws.apigateway.model.IntegrationType] =
      ZIO.succeed(`type`)
    def getIntegrationHttpMethod: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("integrationHttpMethod", integrationHttpMethod)
    def getUri: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("uri", uri)
    def getConnectionType
        : ZIO[Any, AwsError, zio.aws.apigateway.model.ConnectionType] =
      AwsError.unwrapOptionField("connectionType", connectionType)
    def getConnectionId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("connectionId", connectionId)
    def getCredentials: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("credentials", credentials)
    def getRequestParameters: ZIO[Any, AwsError, Map[String, String]] =
      AwsError.unwrapOptionField("requestParameters", requestParameters)
    def getRequestTemplates: ZIO[Any, AwsError, Map[String, String]] =
      AwsError.unwrapOptionField("requestTemplates", requestTemplates)
    def getPassthroughBehavior: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("passthroughBehavior", passthroughBehavior)
    def getCacheNamespace: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("cacheNamespace", cacheNamespace)
    def getCacheKeyParameters: ZIO[Any, AwsError, List[String]] =
      AwsError.unwrapOptionField("cacheKeyParameters", cacheKeyParameters)
    def getContentHandling
        : ZIO[Any, AwsError, zio.aws.apigateway.model.ContentHandlingStrategy] =
      AwsError.unwrapOptionField("contentHandling", contentHandling)
    def getTimeoutInMillis: ZIO[Any, AwsError, NullableInteger] =
      AwsError.unwrapOptionField("timeoutInMillis", timeoutInMillis)
    def getTlsConfig
        : ZIO[Any, AwsError, zio.aws.apigateway.model.TlsConfig.ReadOnly] =
      AwsError.unwrapOptionField("tlsConfig", tlsConfig)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.apigateway.model.PutIntegrationRequest
  ) extends zio.aws.apigateway.model.PutIntegrationRequest.ReadOnly {
    override val restApiId: String = impl.restApiId(): String
    override val resourceId: String = impl.resourceId(): String
    override val httpMethod: String = impl.httpMethod(): String
    override val `type`: zio.aws.apigateway.model.IntegrationType =
      zio.aws.apigateway.model.IntegrationType.wrap(impl.`type`())
    override val integrationHttpMethod: Option[String] =
      scala.Option(impl.integrationHttpMethod()).map(value => value: String)
    override val uri: Option[String] =
      scala.Option(impl.uri()).map(value => value: String)
    override val connectionType
        : Option[zio.aws.apigateway.model.ConnectionType] = scala
      .Option(impl.connectionType())
      .map(value => zio.aws.apigateway.model.ConnectionType.wrap(value))
    override val connectionId: Option[String] =
      scala.Option(impl.connectionId()).map(value => value: String)
    override val credentials: Option[String] =
      scala.Option(impl.credentials()).map(value => value: String)
    override val requestParameters: Option[Map[String, String]] = scala
      .Option(impl.requestParameters())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            (key: String) -> (value: String)
          })
          .toMap
      )
    override val requestTemplates: Option[Map[String, String]] = scala
      .Option(impl.requestTemplates())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            (key: String) -> (value: String)
          })
          .toMap
      )
    override val passthroughBehavior: Option[String] =
      scala.Option(impl.passthroughBehavior()).map(value => value: String)
    override val cacheNamespace: Option[String] =
      scala.Option(impl.cacheNamespace()).map(value => value: String)
    override val cacheKeyParameters: Option[List[String]] = scala
      .Option(impl.cacheKeyParameters())
      .map(value =>
        value.asScala.map { item =>
          item: String
        }.toList
      )
    override val contentHandling
        : Option[zio.aws.apigateway.model.ContentHandlingStrategy] = scala
      .Option(impl.contentHandling())
      .map(value =>
        zio.aws.apigateway.model.ContentHandlingStrategy.wrap(value)
      )
    override val timeoutInMillis: Option[NullableInteger] = scala
      .Option(impl.timeoutInMillis())
      .map(value => zio.aws.apigateway.model.primitives.NullableInteger(value))
    override val tlsConfig
        : Option[zio.aws.apigateway.model.TlsConfig.ReadOnly] = scala
      .Option(impl.tlsConfig())
      .map(value => zio.aws.apigateway.model.TlsConfig.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.apigateway.model.PutIntegrationRequest
  ): zio.aws.apigateway.model.PutIntegrationRequest.ReadOnly = new Wrapper(impl)
}
