package zio.aws.apigateway.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.apigateway.model.primitives.StatusCode
import scala.jdk.CollectionConverters.*
final case class PutIntegrationResponseResponse(
    statusCode: Option[StatusCode] = None,
    selectionPattern: Option[String] = None,
    responseParameters: Option[Map[String, String]] = None,
    responseTemplates: Option[Map[String, String]] = None,
    contentHandling: Option[zio.aws.apigateway.model.ContentHandlingStrategy] =
      None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.apigateway.model.PutIntegrationResponseResponse = {
    import PutIntegrationResponseResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.apigateway.model.PutIntegrationResponseResponse
      .builder()
      .optionallyWith(
        statusCode.map(value => StatusCode.unwrap(value): java.lang.String)
      )(_.statusCode)
      .optionallyWith(selectionPattern.map(value => value: java.lang.String))(
        _.selectionPattern
      )
      .optionallyWith(
        responseParameters.map(value =>
          value
            .map({ case (key, value) =>
              (key: java.lang.String) -> (value: java.lang.String)
            })
            .asJava
        )
      )(_.responseParameters)
      .optionallyWith(
        responseTemplates.map(value =>
          value
            .map({ case (key, value) =>
              (key: java.lang.String) -> (value: java.lang.String)
            })
            .asJava
        )
      )(_.responseTemplates)
      .optionallyWith(contentHandling.map(value => value.unwrap))(
        _.contentHandling
      )
      .build()
  }
  def asReadOnly
      : zio.aws.apigateway.model.PutIntegrationResponseResponse.ReadOnly =
    zio.aws.apigateway.model.PutIntegrationResponseResponse
      .wrap(buildAwsValue())
}
object PutIntegrationResponseResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.apigateway.model.PutIntegrationResponseResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.apigateway.model.PutIntegrationResponseResponse =
      zio.aws.apigateway.model.PutIntegrationResponseResponse(
        statusCode.map(value => value),
        selectionPattern.map(value => value),
        responseParameters.map(value => value),
        responseTemplates.map(value => value),
        contentHandling.map(value => value)
      )
    def statusCode: Option[StatusCode]
    def selectionPattern: Option[String]
    def responseParameters: Option[Map[String, String]]
    def responseTemplates: Option[Map[String, String]]
    def contentHandling
        : Option[zio.aws.apigateway.model.ContentHandlingStrategy]
    def getStatusCode: ZIO[Any, AwsError, StatusCode] =
      AwsError.unwrapOptionField("statusCode", statusCode)
    def getSelectionPattern: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("selectionPattern", selectionPattern)
    def getResponseParameters: ZIO[Any, AwsError, Map[String, String]] =
      AwsError.unwrapOptionField("responseParameters", responseParameters)
    def getResponseTemplates: ZIO[Any, AwsError, Map[String, String]] =
      AwsError.unwrapOptionField("responseTemplates", responseTemplates)
    def getContentHandling
        : ZIO[Any, AwsError, zio.aws.apigateway.model.ContentHandlingStrategy] =
      AwsError.unwrapOptionField("contentHandling", contentHandling)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.apigateway.model.PutIntegrationResponseResponse
  ) extends zio.aws.apigateway.model.PutIntegrationResponseResponse.ReadOnly {
    override val statusCode: Option[StatusCode] = scala
      .Option(impl.statusCode())
      .map(value => zio.aws.apigateway.model.primitives.StatusCode(value))
    override val selectionPattern: Option[String] =
      scala.Option(impl.selectionPattern()).map(value => value: String)
    override val responseParameters: Option[Map[String, String]] = scala
      .Option(impl.responseParameters())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            (key: String) -> (value: String)
          })
          .toMap
      )
    override val responseTemplates: Option[Map[String, String]] = scala
      .Option(impl.responseTemplates())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            (key: String) -> (value: String)
          })
          .toMap
      )
    override val contentHandling
        : Option[zio.aws.apigateway.model.ContentHandlingStrategy] = scala
      .Option(impl.contentHandling())
      .map(value =>
        zio.aws.apigateway.model.ContentHandlingStrategy.wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.apigateway.model.PutIntegrationResponseResponse
  ): zio.aws.apigateway.model.PutIntegrationResponseResponse.ReadOnly =
    new Wrapper(impl)
}
