package zio.aws.apigateway.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.apigateway.model.primitives.{NullableBoolean, StatusCode}
import scala.jdk.CollectionConverters.*
final case class PutMethodResponseRequest(
    restApiId: String,
    resourceId: String,
    httpMethod: String,
    statusCode: StatusCode,
    responseParameters: Option[Map[String, NullableBoolean]] = None,
    responseModels: Option[Map[String, String]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.apigateway.model.PutMethodResponseRequest = {
    import PutMethodResponseRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.apigateway.model.PutMethodResponseRequest
      .builder()
      .restApiId(restApiId: java.lang.String)
      .resourceId(resourceId: java.lang.String)
      .httpMethod(httpMethod: java.lang.String)
      .statusCode(StatusCode.unwrap(statusCode): java.lang.String)
      .optionallyWith(
        responseParameters.map(value =>
          value
            .map({ case (key, value) =>
              (key: java.lang.String) -> (NullableBoolean
                .unwrap(value): java.lang.Boolean)
            })
            .asJava
        )
      )(_.responseParameters)
      .optionallyWith(
        responseModels.map(value =>
          value
            .map({ case (key, value) =>
              (key: java.lang.String) -> (value: java.lang.String)
            })
            .asJava
        )
      )(_.responseModels)
      .build()
  }
  def asReadOnly: zio.aws.apigateway.model.PutMethodResponseRequest.ReadOnly =
    zio.aws.apigateway.model.PutMethodResponseRequest.wrap(buildAwsValue())
}
object PutMethodResponseRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.apigateway.model.PutMethodResponseRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.apigateway.model.PutMethodResponseRequest =
      zio.aws.apigateway.model.PutMethodResponseRequest(
        restApiId,
        resourceId,
        httpMethod,
        statusCode,
        responseParameters.map(value => value),
        responseModels.map(value => value)
      )
    def restApiId: String
    def resourceId: String
    def httpMethod: String
    def statusCode: StatusCode
    def responseParameters: Option[Map[String, NullableBoolean]]
    def responseModels: Option[Map[String, String]]
    def getRestApiId: ZIO[Any, Nothing, String] = ZIO.succeed(restApiId)
    def getResourceId: ZIO[Any, Nothing, String] = ZIO.succeed(resourceId)
    def getHttpMethod: ZIO[Any, Nothing, String] = ZIO.succeed(httpMethod)
    def getStatusCode: ZIO[Any, Nothing, StatusCode] = ZIO.succeed(statusCode)
    def getResponseParameters
        : ZIO[Any, AwsError, Map[String, NullableBoolean]] =
      AwsError.unwrapOptionField("responseParameters", responseParameters)
    def getResponseModels: ZIO[Any, AwsError, Map[String, String]] =
      AwsError.unwrapOptionField("responseModels", responseModels)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.apigateway.model.PutMethodResponseRequest
  ) extends zio.aws.apigateway.model.PutMethodResponseRequest.ReadOnly {
    override val restApiId: String = impl.restApiId(): String
    override val resourceId: String = impl.resourceId(): String
    override val httpMethod: String = impl.httpMethod(): String
    override val statusCode: StatusCode =
      zio.aws.apigateway.model.primitives.StatusCode(impl.statusCode())
    override val responseParameters: Option[Map[String, NullableBoolean]] =
      scala
        .Option(impl.responseParameters())
        .map(value =>
          value.asScala
            .map({ case (key, value) =>
              (key: String) -> zio.aws.apigateway.model.primitives
                .NullableBoolean(value)
            })
            .toMap
        )
    override val responseModels: Option[Map[String, String]] = scala
      .Option(impl.responseModels())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            (key: String) -> (value: String)
          })
          .toMap
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.apigateway.model.PutMethodResponseRequest
  ): zio.aws.apigateway.model.PutMethodResponseRequest.ReadOnly = new Wrapper(
    impl
  )
}
