package zio.aws.apigateway.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class RequestValidator(
    id: Option[String] = None,
    name: Option[String] = None,
    validateRequestBody: Option[Boolean] = None,
    validateRequestParameters: Option[Boolean] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.apigateway.model.RequestValidator = {
    import RequestValidator.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.apigateway.model.RequestValidator
      .builder()
      .optionallyWith(id.map(value => value: java.lang.String))(_.id)
      .optionallyWith(name.map(value => value: java.lang.String))(_.name)
      .optionallyWith(
        validateRequestBody.map(value => value: java.lang.Boolean)
      )(_.validateRequestBody)
      .optionallyWith(
        validateRequestParameters.map(value => value: java.lang.Boolean)
      )(_.validateRequestParameters)
      .build()
  }
  def asReadOnly: zio.aws.apigateway.model.RequestValidator.ReadOnly =
    zio.aws.apigateway.model.RequestValidator.wrap(buildAwsValue())
}
object RequestValidator {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.apigateway.model.RequestValidator
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.apigateway.model.RequestValidator =
      zio.aws.apigateway.model.RequestValidator(
        id.map(value => value),
        name.map(value => value),
        validateRequestBody.map(value => value),
        validateRequestParameters.map(value => value)
      )
    def id: Option[String]
    def name: Option[String]
    def validateRequestBody: Option[Boolean]
    def validateRequestParameters: Option[Boolean]
    def getId: ZIO[Any, AwsError, String] = AwsError.unwrapOptionField("id", id)
    def getName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("name", name)
    def getValidateRequestBody: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("validateRequestBody", validateRequestBody)
    def getValidateRequestParameters: ZIO[Any, AwsError, Boolean] = AwsError
      .unwrapOptionField("validateRequestParameters", validateRequestParameters)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.apigateway.model.RequestValidator
  ) extends zio.aws.apigateway.model.RequestValidator.ReadOnly {
    override val id: Option[String] =
      scala.Option(impl.id()).map(value => value: String)
    override val name: Option[String] =
      scala.Option(impl.name()).map(value => value: String)
    override val validateRequestBody: Option[Boolean] =
      scala.Option(impl.validateRequestBody()).map(value => value: Boolean)
    override val validateRequestParameters: Option[Boolean] = scala
      .Option(impl.validateRequestParameters())
      .map(value => value: Boolean)
  }
  def wrap(
      impl: software.amazon.awssdk.services.apigateway.model.RequestValidator
  ): zio.aws.apigateway.model.RequestValidator.ReadOnly = new Wrapper(impl)
}
