package zio.aws.apigateway.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class TestInvokeMethodRequest(
    restApiId: String,
    resourceId: String,
    httpMethod: String,
    pathWithQueryString: Option[String] = None,
    body: Option[String] = None,
    headers: Option[Map[String, String]] = None,
    multiValueHeaders: Option[Map[String, Iterable[String]]] = None,
    clientCertificateId: Option[String] = None,
    stageVariables: Option[Map[String, String]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.apigateway.model.TestInvokeMethodRequest = {
    import TestInvokeMethodRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.apigateway.model.TestInvokeMethodRequest
      .builder()
      .restApiId(restApiId: java.lang.String)
      .resourceId(resourceId: java.lang.String)
      .httpMethod(httpMethod: java.lang.String)
      .optionallyWith(
        pathWithQueryString.map(value => value: java.lang.String)
      )(_.pathWithQueryString)
      .optionallyWith(body.map(value => value: java.lang.String))(_.body)
      .optionallyWith(
        headers.map(value =>
          value
            .map({ case (key, value) =>
              (key: java.lang.String) -> (value: java.lang.String)
            })
            .asJava
        )
      )(_.headers)
      .optionallyWith(
        multiValueHeaders.map(value =>
          value
            .map({ case (key, value) =>
              (key: java.lang.String) -> value.map { item =>
                item: java.lang.String
              }.asJavaCollection
            })
            .asJava
        )
      )(_.multiValueHeaders)
      .optionallyWith(
        clientCertificateId.map(value => value: java.lang.String)
      )(_.clientCertificateId)
      .optionallyWith(
        stageVariables.map(value =>
          value
            .map({ case (key, value) =>
              (key: java.lang.String) -> (value: java.lang.String)
            })
            .asJava
        )
      )(_.stageVariables)
      .build()
  }
  def asReadOnly: zio.aws.apigateway.model.TestInvokeMethodRequest.ReadOnly =
    zio.aws.apigateway.model.TestInvokeMethodRequest.wrap(buildAwsValue())
}
object TestInvokeMethodRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.apigateway.model.TestInvokeMethodRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.apigateway.model.TestInvokeMethodRequest =
      zio.aws.apigateway.model.TestInvokeMethodRequest(
        restApiId,
        resourceId,
        httpMethod,
        pathWithQueryString.map(value => value),
        body.map(value => value),
        headers.map(value => value),
        multiValueHeaders.map(value => value),
        clientCertificateId.map(value => value),
        stageVariables.map(value => value)
      )
    def restApiId: String
    def resourceId: String
    def httpMethod: String
    def pathWithQueryString: Option[String]
    def body: Option[String]
    def headers: Option[Map[String, String]]
    def multiValueHeaders: Option[Map[String, List[String]]]
    def clientCertificateId: Option[String]
    def stageVariables: Option[Map[String, String]]
    def getRestApiId: ZIO[Any, Nothing, String] = ZIO.succeed(restApiId)
    def getResourceId: ZIO[Any, Nothing, String] = ZIO.succeed(resourceId)
    def getHttpMethod: ZIO[Any, Nothing, String] = ZIO.succeed(httpMethod)
    def getPathWithQueryString: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("pathWithQueryString", pathWithQueryString)
    def getBody: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("body", body)
    def getHeaders: ZIO[Any, AwsError, Map[String, String]] =
      AwsError.unwrapOptionField("headers", headers)
    def getMultiValueHeaders: ZIO[Any, AwsError, Map[String, List[String]]] =
      AwsError.unwrapOptionField("multiValueHeaders", multiValueHeaders)
    def getClientCertificateId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("clientCertificateId", clientCertificateId)
    def getStageVariables: ZIO[Any, AwsError, Map[String, String]] =
      AwsError.unwrapOptionField("stageVariables", stageVariables)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.apigateway.model.TestInvokeMethodRequest
  ) extends zio.aws.apigateway.model.TestInvokeMethodRequest.ReadOnly {
    override val restApiId: String = impl.restApiId(): String
    override val resourceId: String = impl.resourceId(): String
    override val httpMethod: String = impl.httpMethod(): String
    override val pathWithQueryString: Option[String] =
      scala.Option(impl.pathWithQueryString()).map(value => value: String)
    override val body: Option[String] =
      scala.Option(impl.body()).map(value => value: String)
    override val headers: Option[Map[String, String]] = scala
      .Option(impl.headers())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            (key: String) -> (value: String)
          })
          .toMap
      )
    override val multiValueHeaders: Option[Map[String, List[String]]] = scala
      .Option(impl.multiValueHeaders())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            (key: String) -> value.asScala.map { item =>
              item: String
            }.toList
          })
          .toMap
      )
    override val clientCertificateId: Option[String] =
      scala.Option(impl.clientCertificateId()).map(value => value: String)
    override val stageVariables: Option[Map[String, String]] = scala
      .Option(impl.stageVariables())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            (key: String) -> (value: String)
          })
          .toMap
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.apigateway.model.TestInvokeMethodRequest
  ): zio.aws.apigateway.model.TestInvokeMethodRequest.ReadOnly = new Wrapper(
    impl
  )
}
