package zio.aws.apigateway.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class TlsConfig(insecureSkipVerification: Option[Boolean] = None) {
  def buildAwsValue()
      : software.amazon.awssdk.services.apigateway.model.TlsConfig = {
    import TlsConfig.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.apigateway.model.TlsConfig
      .builder()
      .optionallyWith(
        insecureSkipVerification.map(value => value: java.lang.Boolean)
      )(_.insecureSkipVerification)
      .build()
  }
  def asReadOnly: zio.aws.apigateway.model.TlsConfig.ReadOnly =
    zio.aws.apigateway.model.TlsConfig.wrap(buildAwsValue())
}
object TlsConfig {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.apigateway.model.TlsConfig
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.apigateway.model.TlsConfig =
      zio.aws.apigateway.model
        .TlsConfig(insecureSkipVerification.map(value => value))
    def insecureSkipVerification: Option[Boolean]
    def getInsecureSkipVerification: ZIO[Any, AwsError, Boolean] = AwsError
      .unwrapOptionField("insecureSkipVerification", insecureSkipVerification)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.apigateway.model.TlsConfig
  ) extends zio.aws.apigateway.model.TlsConfig.ReadOnly {
    override val insecureSkipVerification: Option[Boolean] =
      scala.Option(impl.insecureSkipVerification()).map(value => value: Boolean)
  }
  def wrap(
      impl: software.amazon.awssdk.services.apigateway.model.TlsConfig
  ): zio.aws.apigateway.model.TlsConfig.ReadOnly = new Wrapper(impl)
}
