package zio.aws.apigateway.model
import scala.jdk.CollectionConverters.*
sealed trait UnauthorizedCacheControlHeaderStrategy {
  def unwrap: software.amazon.awssdk.services.apigateway.model.UnauthorizedCacheControlHeaderStrategy
}
object UnauthorizedCacheControlHeaderStrategy {
  def wrap(
      value: software.amazon.awssdk.services.apigateway.model.UnauthorizedCacheControlHeaderStrategy
  ): zio.aws.apigateway.model.UnauthorizedCacheControlHeaderStrategy =
    value match {
      case software.amazon.awssdk.services.apigateway.model.UnauthorizedCacheControlHeaderStrategy.UNKNOWN_TO_SDK_VERSION =>
        val r = unknownToSdkVersion
        r
      case software.amazon.awssdk.services.apigateway.model.UnauthorizedCacheControlHeaderStrategy.FAIL_WITH_403 =>
        val r = FAIL_WITH_403
        r
      case software.amazon.awssdk.services.apigateway.model.UnauthorizedCacheControlHeaderStrategy.SUCCEED_WITH_RESPONSE_HEADER =>
        val r = SUCCEED_WITH_RESPONSE_HEADER
        r
      case software.amazon.awssdk.services.apigateway.model.UnauthorizedCacheControlHeaderStrategy.SUCCEED_WITHOUT_RESPONSE_HEADER =>
        val r = SUCCEED_WITHOUT_RESPONSE_HEADER
        r
    }
  case object unknownToSdkVersion
      extends zio.aws.apigateway.model.UnauthorizedCacheControlHeaderStrategy {
    override def unwrap
        : software.amazon.awssdk.services.apigateway.model.UnauthorizedCacheControlHeaderStrategy =
      software.amazon.awssdk.services.apigateway.model.UnauthorizedCacheControlHeaderStrategy.UNKNOWN_TO_SDK_VERSION
  }
  case object FAIL_WITH_403
      extends zio.aws.apigateway.model.UnauthorizedCacheControlHeaderStrategy {
    override def unwrap
        : software.amazon.awssdk.services.apigateway.model.UnauthorizedCacheControlHeaderStrategy =
      software.amazon.awssdk.services.apigateway.model.UnauthorizedCacheControlHeaderStrategy.FAIL_WITH_403
  }
  case object SUCCEED_WITH_RESPONSE_HEADER
      extends zio.aws.apigateway.model.UnauthorizedCacheControlHeaderStrategy {
    override def unwrap
        : software.amazon.awssdk.services.apigateway.model.UnauthorizedCacheControlHeaderStrategy =
      software.amazon.awssdk.services.apigateway.model.UnauthorizedCacheControlHeaderStrategy.SUCCEED_WITH_RESPONSE_HEADER
  }
  case object SUCCEED_WITHOUT_RESPONSE_HEADER
      extends zio.aws.apigateway.model.UnauthorizedCacheControlHeaderStrategy {
    override def unwrap
        : software.amazon.awssdk.services.apigateway.model.UnauthorizedCacheControlHeaderStrategy =
      software.amazon.awssdk.services.apigateway.model.UnauthorizedCacheControlHeaderStrategy.SUCCEED_WITHOUT_RESPONSE_HEADER
  }
}
