package zio.aws.apigateway.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class UpdateAccountRequest(
    patchOperations: Option[Iterable[zio.aws.apigateway.model.PatchOperation]] =
      None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.apigateway.model.UpdateAccountRequest = {
    import UpdateAccountRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.apigateway.model.UpdateAccountRequest
      .builder()
      .optionallyWith(
        patchOperations.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.patchOperations)
      .build()
  }
  def asReadOnly: zio.aws.apigateway.model.UpdateAccountRequest.ReadOnly =
    zio.aws.apigateway.model.UpdateAccountRequest.wrap(buildAwsValue())
}
object UpdateAccountRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.apigateway.model.UpdateAccountRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.apigateway.model.UpdateAccountRequest =
      zio.aws.apigateway.model.UpdateAccountRequest(
        patchOperations.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def patchOperations
        : Option[List[zio.aws.apigateway.model.PatchOperation.ReadOnly]]
    def getPatchOperations: ZIO[Any, AwsError, List[
      zio.aws.apigateway.model.PatchOperation.ReadOnly
    ]] = AwsError.unwrapOptionField("patchOperations", patchOperations)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.apigateway.model.UpdateAccountRequest
  ) extends zio.aws.apigateway.model.UpdateAccountRequest.ReadOnly {
    override val patchOperations
        : Option[List[zio.aws.apigateway.model.PatchOperation.ReadOnly]] = scala
      .Option(impl.patchOperations())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.apigateway.model.PatchOperation.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.apigateway.model.UpdateAccountRequest
  ): zio.aws.apigateway.model.UpdateAccountRequest.ReadOnly = new Wrapper(impl)
}
