package zio.aws.apigateway.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class UpdateDeploymentRequest(
    restApiId: String,
    deploymentId: String,
    patchOperations: Option[Iterable[zio.aws.apigateway.model.PatchOperation]] =
      None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.apigateway.model.UpdateDeploymentRequest = {
    import UpdateDeploymentRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.apigateway.model.UpdateDeploymentRequest
      .builder()
      .restApiId(restApiId: java.lang.String)
      .deploymentId(deploymentId: java.lang.String)
      .optionallyWith(
        patchOperations.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.patchOperations)
      .build()
  }
  def asReadOnly: zio.aws.apigateway.model.UpdateDeploymentRequest.ReadOnly =
    zio.aws.apigateway.model.UpdateDeploymentRequest.wrap(buildAwsValue())
}
object UpdateDeploymentRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.apigateway.model.UpdateDeploymentRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.apigateway.model.UpdateDeploymentRequest =
      zio.aws.apigateway.model.UpdateDeploymentRequest(
        restApiId,
        deploymentId,
        patchOperations.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def restApiId: String
    def deploymentId: String
    def patchOperations
        : Option[List[zio.aws.apigateway.model.PatchOperation.ReadOnly]]
    def getRestApiId: ZIO[Any, Nothing, String] = ZIO.succeed(restApiId)
    def getDeploymentId: ZIO[Any, Nothing, String] = ZIO.succeed(deploymentId)
    def getPatchOperations: ZIO[Any, AwsError, List[
      zio.aws.apigateway.model.PatchOperation.ReadOnly
    ]] = AwsError.unwrapOptionField("patchOperations", patchOperations)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.apigateway.model.UpdateDeploymentRequest
  ) extends zio.aws.apigateway.model.UpdateDeploymentRequest.ReadOnly {
    override val restApiId: String = impl.restApiId(): String
    override val deploymentId: String = impl.deploymentId(): String
    override val patchOperations
        : Option[List[zio.aws.apigateway.model.PatchOperation.ReadOnly]] = scala
      .Option(impl.patchOperations())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.apigateway.model.PatchOperation.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.apigateway.model.UpdateDeploymentRequest
  ): zio.aws.apigateway.model.UpdateDeploymentRequest.ReadOnly = new Wrapper(
    impl
  )
}
