package zio.aws.apigateway.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class UpdateGatewayResponseRequest(
    restApiId: String,
    responseType: zio.aws.apigateway.model.GatewayResponseType,
    patchOperations: Option[Iterable[zio.aws.apigateway.model.PatchOperation]] =
      None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.apigateway.model.UpdateGatewayResponseRequest = {
    import UpdateGatewayResponseRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.apigateway.model.UpdateGatewayResponseRequest
      .builder()
      .restApiId(restApiId: java.lang.String)
      .responseType(responseType.unwrap)
      .optionallyWith(
        patchOperations.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.patchOperations)
      .build()
  }
  def asReadOnly
      : zio.aws.apigateway.model.UpdateGatewayResponseRequest.ReadOnly =
    zio.aws.apigateway.model.UpdateGatewayResponseRequest.wrap(buildAwsValue())
}
object UpdateGatewayResponseRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.apigateway.model.UpdateGatewayResponseRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.apigateway.model.UpdateGatewayResponseRequest =
      zio.aws.apigateway.model.UpdateGatewayResponseRequest(
        restApiId,
        responseType,
        patchOperations.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def restApiId: String
    def responseType: zio.aws.apigateway.model.GatewayResponseType
    def patchOperations
        : Option[List[zio.aws.apigateway.model.PatchOperation.ReadOnly]]
    def getRestApiId: ZIO[Any, Nothing, String] = ZIO.succeed(restApiId)
    def getResponseType
        : ZIO[Any, Nothing, zio.aws.apigateway.model.GatewayResponseType] =
      ZIO.succeed(responseType)
    def getPatchOperations: ZIO[Any, AwsError, List[
      zio.aws.apigateway.model.PatchOperation.ReadOnly
    ]] = AwsError.unwrapOptionField("patchOperations", patchOperations)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.apigateway.model.UpdateGatewayResponseRequest
  ) extends zio.aws.apigateway.model.UpdateGatewayResponseRequest.ReadOnly {
    override val restApiId: String = impl.restApiId(): String
    override val responseType: zio.aws.apigateway.model.GatewayResponseType =
      zio.aws.apigateway.model.GatewayResponseType.wrap(impl.responseType())
    override val patchOperations
        : Option[List[zio.aws.apigateway.model.PatchOperation.ReadOnly]] = scala
      .Option(impl.patchOperations())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.apigateway.model.PatchOperation.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.apigateway.model.UpdateGatewayResponseRequest
  ): zio.aws.apigateway.model.UpdateGatewayResponseRequest.ReadOnly =
    new Wrapper(impl)
}
