package zio.aws.apigateway.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.apigateway.model.primitives.StatusCode
import scala.jdk.CollectionConverters.*
final case class UpdateGatewayResponseResponse(
    responseType: Option[zio.aws.apigateway.model.GatewayResponseType] = None,
    statusCode: Option[StatusCode] = None,
    responseParameters: Option[Map[String, String]] = None,
    responseTemplates: Option[Map[String, String]] = None,
    defaultResponse: Option[Boolean] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.apigateway.model.UpdateGatewayResponseResponse = {
    import UpdateGatewayResponseResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.apigateway.model.UpdateGatewayResponseResponse
      .builder()
      .optionallyWith(responseType.map(value => value.unwrap))(_.responseType)
      .optionallyWith(
        statusCode.map(value => StatusCode.unwrap(value): java.lang.String)
      )(_.statusCode)
      .optionallyWith(
        responseParameters.map(value =>
          value
            .map({ case (key, value) =>
              (key: java.lang.String) -> (value: java.lang.String)
            })
            .asJava
        )
      )(_.responseParameters)
      .optionallyWith(
        responseTemplates.map(value =>
          value
            .map({ case (key, value) =>
              (key: java.lang.String) -> (value: java.lang.String)
            })
            .asJava
        )
      )(_.responseTemplates)
      .optionallyWith(defaultResponse.map(value => value: java.lang.Boolean))(
        _.defaultResponse
      )
      .build()
  }
  def asReadOnly
      : zio.aws.apigateway.model.UpdateGatewayResponseResponse.ReadOnly =
    zio.aws.apigateway.model.UpdateGatewayResponseResponse.wrap(buildAwsValue())
}
object UpdateGatewayResponseResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.apigateway.model.UpdateGatewayResponseResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.apigateway.model.UpdateGatewayResponseResponse =
      zio.aws.apigateway.model.UpdateGatewayResponseResponse(
        responseType.map(value => value),
        statusCode.map(value => value),
        responseParameters.map(value => value),
        responseTemplates.map(value => value),
        defaultResponse.map(value => value)
      )
    def responseType: Option[zio.aws.apigateway.model.GatewayResponseType]
    def statusCode: Option[StatusCode]
    def responseParameters: Option[Map[String, String]]
    def responseTemplates: Option[Map[String, String]]
    def defaultResponse: Option[Boolean]
    def getResponseType
        : ZIO[Any, AwsError, zio.aws.apigateway.model.GatewayResponseType] =
      AwsError.unwrapOptionField("responseType", responseType)
    def getStatusCode: ZIO[Any, AwsError, StatusCode] =
      AwsError.unwrapOptionField("statusCode", statusCode)
    def getResponseParameters: ZIO[Any, AwsError, Map[String, String]] =
      AwsError.unwrapOptionField("responseParameters", responseParameters)
    def getResponseTemplates: ZIO[Any, AwsError, Map[String, String]] =
      AwsError.unwrapOptionField("responseTemplates", responseTemplates)
    def getDefaultResponse: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("defaultResponse", defaultResponse)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.apigateway.model.UpdateGatewayResponseResponse
  ) extends zio.aws.apigateway.model.UpdateGatewayResponseResponse.ReadOnly {
    override val responseType
        : Option[zio.aws.apigateway.model.GatewayResponseType] = scala
      .Option(impl.responseType())
      .map(value => zio.aws.apigateway.model.GatewayResponseType.wrap(value))
    override val statusCode: Option[StatusCode] = scala
      .Option(impl.statusCode())
      .map(value => zio.aws.apigateway.model.primitives.StatusCode(value))
    override val responseParameters: Option[Map[String, String]] = scala
      .Option(impl.responseParameters())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            (key: String) -> (value: String)
          })
          .toMap
      )
    override val responseTemplates: Option[Map[String, String]] = scala
      .Option(impl.responseTemplates())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            (key: String) -> (value: String)
          })
          .toMap
      )
    override val defaultResponse: Option[Boolean] =
      scala.Option(impl.defaultResponse()).map(value => value: Boolean)
  }
  def wrap(
      impl: software.amazon.awssdk.services.apigateway.model.UpdateGatewayResponseResponse
  ): zio.aws.apigateway.model.UpdateGatewayResponseResponse.ReadOnly =
    new Wrapper(impl)
}
