package zio.aws.apigateway.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.apigateway.model.primitives.StatusCode
import scala.jdk.CollectionConverters.*
final case class UpdateIntegrationResponseRequest(
    restApiId: String,
    resourceId: String,
    httpMethod: String,
    statusCode: StatusCode,
    patchOperations: Option[Iterable[zio.aws.apigateway.model.PatchOperation]] =
      None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.apigateway.model.UpdateIntegrationResponseRequest = {
    import UpdateIntegrationResponseRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.apigateway.model.UpdateIntegrationResponseRequest
      .builder()
      .restApiId(restApiId: java.lang.String)
      .resourceId(resourceId: java.lang.String)
      .httpMethod(httpMethod: java.lang.String)
      .statusCode(StatusCode.unwrap(statusCode): java.lang.String)
      .optionallyWith(
        patchOperations.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.patchOperations)
      .build()
  }
  def asReadOnly
      : zio.aws.apigateway.model.UpdateIntegrationResponseRequest.ReadOnly =
    zio.aws.apigateway.model.UpdateIntegrationResponseRequest
      .wrap(buildAwsValue())
}
object UpdateIntegrationResponseRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.apigateway.model.UpdateIntegrationResponseRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.apigateway.model.UpdateIntegrationResponseRequest =
      zio.aws.apigateway.model.UpdateIntegrationResponseRequest(
        restApiId,
        resourceId,
        httpMethod,
        statusCode,
        patchOperations.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def restApiId: String
    def resourceId: String
    def httpMethod: String
    def statusCode: StatusCode
    def patchOperations
        : Option[List[zio.aws.apigateway.model.PatchOperation.ReadOnly]]
    def getRestApiId: ZIO[Any, Nothing, String] = ZIO.succeed(restApiId)
    def getResourceId: ZIO[Any, Nothing, String] = ZIO.succeed(resourceId)
    def getHttpMethod: ZIO[Any, Nothing, String] = ZIO.succeed(httpMethod)
    def getStatusCode: ZIO[Any, Nothing, StatusCode] = ZIO.succeed(statusCode)
    def getPatchOperations: ZIO[Any, AwsError, List[
      zio.aws.apigateway.model.PatchOperation.ReadOnly
    ]] = AwsError.unwrapOptionField("patchOperations", patchOperations)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.apigateway.model.UpdateIntegrationResponseRequest
  ) extends zio.aws.apigateway.model.UpdateIntegrationResponseRequest.ReadOnly {
    override val restApiId: String = impl.restApiId(): String
    override val resourceId: String = impl.resourceId(): String
    override val httpMethod: String = impl.httpMethod(): String
    override val statusCode: StatusCode =
      zio.aws.apigateway.model.primitives.StatusCode(impl.statusCode())
    override val patchOperations
        : Option[List[zio.aws.apigateway.model.PatchOperation.ReadOnly]] = scala
      .Option(impl.patchOperations())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.apigateway.model.PatchOperation.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.apigateway.model.UpdateIntegrationResponseRequest
  ): zio.aws.apigateway.model.UpdateIntegrationResponseRequest.ReadOnly =
    new Wrapper(impl)
}
