package zio.aws.apigateway.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class UpdateUsagePlanRequest(
    usagePlanId: String,
    patchOperations: Option[Iterable[zio.aws.apigateway.model.PatchOperation]] =
      None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.apigateway.model.UpdateUsagePlanRequest = {
    import UpdateUsagePlanRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.apigateway.model.UpdateUsagePlanRequest
      .builder()
      .usagePlanId(usagePlanId: java.lang.String)
      .optionallyWith(
        patchOperations.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.patchOperations)
      .build()
  }
  def asReadOnly: zio.aws.apigateway.model.UpdateUsagePlanRequest.ReadOnly =
    zio.aws.apigateway.model.UpdateUsagePlanRequest.wrap(buildAwsValue())
}
object UpdateUsagePlanRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.apigateway.model.UpdateUsagePlanRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.apigateway.model.UpdateUsagePlanRequest =
      zio.aws.apigateway.model.UpdateUsagePlanRequest(
        usagePlanId,
        patchOperations.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def usagePlanId: String
    def patchOperations
        : Option[List[zio.aws.apigateway.model.PatchOperation.ReadOnly]]
    def getUsagePlanId: ZIO[Any, Nothing, String] = ZIO.succeed(usagePlanId)
    def getPatchOperations: ZIO[Any, AwsError, List[
      zio.aws.apigateway.model.PatchOperation.ReadOnly
    ]] = AwsError.unwrapOptionField("patchOperations", patchOperations)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.apigateway.model.UpdateUsagePlanRequest
  ) extends zio.aws.apigateway.model.UpdateUsagePlanRequest.ReadOnly {
    override val usagePlanId: String = impl.usagePlanId(): String
    override val patchOperations
        : Option[List[zio.aws.apigateway.model.PatchOperation.ReadOnly]] = scala
      .Option(impl.patchOperations())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.apigateway.model.PatchOperation.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.apigateway.model.UpdateUsagePlanRequest
  ): zio.aws.apigateway.model.UpdateUsagePlanRequest.ReadOnly = new Wrapper(
    impl
  )
}
