package zio.aws.apigateway.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class UpdateUsageRequest(
    usagePlanId: String,
    keyId: String,
    patchOperations: Option[Iterable[zio.aws.apigateway.model.PatchOperation]] =
      None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.apigateway.model.UpdateUsageRequest = {
    import UpdateUsageRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.apigateway.model.UpdateUsageRequest
      .builder()
      .usagePlanId(usagePlanId: java.lang.String)
      .keyId(keyId: java.lang.String)
      .optionallyWith(
        patchOperations.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.patchOperations)
      .build()
  }
  def asReadOnly: zio.aws.apigateway.model.UpdateUsageRequest.ReadOnly =
    zio.aws.apigateway.model.UpdateUsageRequest.wrap(buildAwsValue())
}
object UpdateUsageRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.apigateway.model.UpdateUsageRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.apigateway.model.UpdateUsageRequest =
      zio.aws.apigateway.model.UpdateUsageRequest(
        usagePlanId,
        keyId,
        patchOperations.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def usagePlanId: String
    def keyId: String
    def patchOperations
        : Option[List[zio.aws.apigateway.model.PatchOperation.ReadOnly]]
    def getUsagePlanId: ZIO[Any, Nothing, String] = ZIO.succeed(usagePlanId)
    def getKeyId: ZIO[Any, Nothing, String] = ZIO.succeed(keyId)
    def getPatchOperations: ZIO[Any, AwsError, List[
      zio.aws.apigateway.model.PatchOperation.ReadOnly
    ]] = AwsError.unwrapOptionField("patchOperations", patchOperations)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.apigateway.model.UpdateUsageRequest
  ) extends zio.aws.apigateway.model.UpdateUsageRequest.ReadOnly {
    override val usagePlanId: String = impl.usagePlanId(): String
    override val keyId: String = impl.keyId(): String
    override val patchOperations
        : Option[List[zio.aws.apigateway.model.PatchOperation.ReadOnly]] = scala
      .Option(impl.patchOperations())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.apigateway.model.PatchOperation.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.apigateway.model.UpdateUsageRequest
  ): zio.aws.apigateway.model.UpdateUsageRequest.ReadOnly = new Wrapper(impl)
}
