package zio.aws.apigateway.model
import scala.jdk.CollectionConverters.*
sealed trait ConnectionType {
  def unwrap: software.amazon.awssdk.services.apigateway.model.ConnectionType
}
object ConnectionType {
  def wrap(
      value: software.amazon.awssdk.services.apigateway.model.ConnectionType
  ): zio.aws.apigateway.model.ConnectionType = value match {
    case software.amazon.awssdk.services.apigateway.model.ConnectionType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.apigateway.model.ConnectionType.INTERNET =>
      val r = INTERNET
      r
    case software.amazon.awssdk.services.apigateway.model.ConnectionType.VPC_LINK =>
      val r = VPC_LINK
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.apigateway.model.ConnectionType {
    override def unwrap
        : software.amazon.awssdk.services.apigateway.model.ConnectionType =
      software.amazon.awssdk.services.apigateway.model.ConnectionType.UNKNOWN_TO_SDK_VERSION
  }
  case object INTERNET extends zio.aws.apigateway.model.ConnectionType {
    override def unwrap
        : software.amazon.awssdk.services.apigateway.model.ConnectionType =
      software.amazon.awssdk.services.apigateway.model.ConnectionType.INTERNET
  }
  case object VPC_LINK extends zio.aws.apigateway.model.ConnectionType {
    override def unwrap
        : software.amazon.awssdk.services.apigateway.model.ConnectionType =
      software.amazon.awssdk.services.apigateway.model.ConnectionType.VPC_LINK
  }
}
