package zio.aws.apigateway.model
import zio.aws.apigateway.model.primitives.{NullableInteger, ProviderARN}
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters.*
final case class CreateAuthorizerResponse(
    id: Optional[String] = Optional.Absent,
    name: Optional[String] = Optional.Absent,
    `type`: Optional[zio.aws.apigateway.model.AuthorizerType] = Optional.Absent,
    providerARNs: Optional[Iterable[ProviderARN]] = Optional.Absent,
    authType: Optional[String] = Optional.Absent,
    authorizerUri: Optional[String] = Optional.Absent,
    authorizerCredentials: Optional[String] = Optional.Absent,
    identitySource: Optional[String] = Optional.Absent,
    identityValidationExpression: Optional[String] = Optional.Absent,
    authorizerResultTtlInSeconds: Optional[NullableInteger] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.apigateway.model.CreateAuthorizerResponse = {
    import CreateAuthorizerResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.apigateway.model.CreateAuthorizerResponse
      .builder()
      .optionallyWith(id.map(value => value: java.lang.String))(_.id)
      .optionallyWith(name.map(value => value: java.lang.String))(_.name)
      .optionallyWith(`type`.map(value => value.unwrap))(_.`type`)
      .optionallyWith(
        providerARNs.map(value =>
          value.map { item =>
            ProviderARN.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.providerARNs)
      .optionallyWith(authType.map(value => value: java.lang.String))(
        _.authType
      )
      .optionallyWith(authorizerUri.map(value => value: java.lang.String))(
        _.authorizerUri
      )
      .optionallyWith(
        authorizerCredentials.map(value => value: java.lang.String)
      )(_.authorizerCredentials)
      .optionallyWith(identitySource.map(value => value: java.lang.String))(
        _.identitySource
      )
      .optionallyWith(
        identityValidationExpression.map(value => value: java.lang.String)
      )(_.identityValidationExpression)
      .optionallyWith(
        authorizerResultTtlInSeconds.map(value => value: Integer)
      )(_.authorizerResultTtlInSeconds)
      .build()
  }
  def asReadOnly: zio.aws.apigateway.model.CreateAuthorizerResponse.ReadOnly =
    zio.aws.apigateway.model.CreateAuthorizerResponse.wrap(buildAwsValue())
}
object CreateAuthorizerResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.apigateway.model.CreateAuthorizerResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.apigateway.model.CreateAuthorizerResponse =
      zio.aws.apigateway.model.CreateAuthorizerResponse(
        id.map(value => value),
        name.map(value => value),
        `type`.map(value => value),
        providerARNs.map(value => value),
        authType.map(value => value),
        authorizerUri.map(value => value),
        authorizerCredentials.map(value => value),
        identitySource.map(value => value),
        identityValidationExpression.map(value => value),
        authorizerResultTtlInSeconds.map(value => value)
      )
    def id: Optional[String]
    def name: Optional[String]
    def `type`: Optional[zio.aws.apigateway.model.AuthorizerType]
    def providerARNs: Optional[List[ProviderARN]]
    def authType: Optional[String]
    def authorizerUri: Optional[String]
    def authorizerCredentials: Optional[String]
    def identitySource: Optional[String]
    def identityValidationExpression: Optional[String]
    def authorizerResultTtlInSeconds: Optional[NullableInteger]
    def getId: ZIO[Any, AwsError, String] = AwsError.unwrapOptionField("id", id)
    def getName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("name", name)
    def getType: ZIO[Any, AwsError, zio.aws.apigateway.model.AuthorizerType] =
      AwsError.unwrapOptionField("type", `type`)
    def getProviderARNs: ZIO[Any, AwsError, List[ProviderARN]] =
      AwsError.unwrapOptionField("providerARNs", providerARNs)
    def getAuthType: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("authType", authType)
    def getAuthorizerUri: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("authorizerUri", authorizerUri)
    def getAuthorizerCredentials: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("authorizerCredentials", authorizerCredentials)
    def getIdentitySource: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("identitySource", identitySource)
    def getIdentityValidationExpression: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField(
        "identityValidationExpression",
        identityValidationExpression
      )
    def getAuthorizerResultTtlInSeconds: ZIO[Any, AwsError, NullableInteger] =
      AwsError.unwrapOptionField(
        "authorizerResultTtlInSeconds",
        authorizerResultTtlInSeconds
      )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.apigateway.model.CreateAuthorizerResponse
  ) extends zio.aws.apigateway.model.CreateAuthorizerResponse.ReadOnly {
    override val id: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.id())
      .map(value => value: String)
    override val name: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.name())
      .map(value => value: String)
    override val `type`: Optional[zio.aws.apigateway.model.AuthorizerType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.`type`())
        .map(value => zio.aws.apigateway.model.AuthorizerType.wrap(value))
    override val providerARNs: Optional[List[ProviderARN]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.providerARNs())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.apigateway.model.primitives.ProviderARN(item)
          }.toList
        )
    override val authType: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.authType())
      .map(value => value: String)
    override val authorizerUri: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.authorizerUri())
      .map(value => value: String)
    override val authorizerCredentials: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.authorizerCredentials())
      .map(value => value: String)
    override val identitySource: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.identitySource())
      .map(value => value: String)
    override val identityValidationExpression: Optional[String] =
      zio.aws.core.internal
        .optionalFromNullable(impl.identityValidationExpression())
        .map(value => value: String)
    override val authorizerResultTtlInSeconds: Optional[NullableInteger] =
      zio.aws.core.internal
        .optionalFromNullable(impl.authorizerResultTtlInSeconds())
        .map(value => value: NullableInteger)
  }
  def wrap(
      impl: software.amazon.awssdk.services.apigateway.model.CreateAuthorizerResponse
  ): zio.aws.apigateway.model.CreateAuthorizerResponse.ReadOnly = new Wrapper(
    impl
  )
}
