package zio.aws.apigateway.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class DeleteDeploymentRequest(
    restApiId: String,
    deploymentId: String
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.apigateway.model.DeleteDeploymentRequest = {
    import DeleteDeploymentRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.apigateway.model.DeleteDeploymentRequest
      .builder()
      .restApiId(restApiId: java.lang.String)
      .deploymentId(deploymentId: java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.apigateway.model.DeleteDeploymentRequest.ReadOnly =
    zio.aws.apigateway.model.DeleteDeploymentRequest.wrap(buildAwsValue())
}
object DeleteDeploymentRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.apigateway.model.DeleteDeploymentRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.apigateway.model.DeleteDeploymentRequest =
      zio.aws.apigateway.model.DeleteDeploymentRequest(restApiId, deploymentId)
    def restApiId: String
    def deploymentId: String
    def getRestApiId: ZIO[Any, Nothing, String] = ZIO.succeed(restApiId)
    def getDeploymentId: ZIO[Any, Nothing, String] = ZIO.succeed(deploymentId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.apigateway.model.DeleteDeploymentRequest
  ) extends zio.aws.apigateway.model.DeleteDeploymentRequest.ReadOnly {
    override val restApiId: String = impl.restApiId(): String
    override val deploymentId: String = impl.deploymentId(): String
  }
  def wrap(
      impl: software.amazon.awssdk.services.apigateway.model.DeleteDeploymentRequest
  ): zio.aws.apigateway.model.DeleteDeploymentRequest.ReadOnly = new Wrapper(
    impl
  )
}
