package zio.aws.apigateway.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class DeleteDocumentationPartRequest(
    restApiId: String,
    documentationPartId: String
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.apigateway.model.DeleteDocumentationPartRequest = {
    import DeleteDocumentationPartRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.apigateway.model.DeleteDocumentationPartRequest
      .builder()
      .restApiId(restApiId: java.lang.String)
      .documentationPartId(documentationPartId: java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.apigateway.model.DeleteDocumentationPartRequest.ReadOnly =
    zio.aws.apigateway.model.DeleteDocumentationPartRequest
      .wrap(buildAwsValue())
}
object DeleteDocumentationPartRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.apigateway.model.DeleteDocumentationPartRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.apigateway.model.DeleteDocumentationPartRequest =
      zio.aws.apigateway.model
        .DeleteDocumentationPartRequest(restApiId, documentationPartId)
    def restApiId: String
    def documentationPartId: String
    def getRestApiId: ZIO[Any, Nothing, String] = ZIO.succeed(restApiId)
    def getDocumentationPartId: ZIO[Any, Nothing, String] =
      ZIO.succeed(documentationPartId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.apigateway.model.DeleteDocumentationPartRequest
  ) extends zio.aws.apigateway.model.DeleteDocumentationPartRequest.ReadOnly {
    override val restApiId: String = impl.restApiId(): String
    override val documentationPartId: String =
      impl.documentationPartId(): String
  }
  def wrap(
      impl: software.amazon.awssdk.services.apigateway.model.DeleteDocumentationPartRequest
  ): zio.aws.apigateway.model.DeleteDocumentationPartRequest.ReadOnly =
    new Wrapper(impl)
}
