package zio.aws.apigateway.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class DeleteModelRequest(restApiId: String, modelName: String) {
  def buildAwsValue()
      : software.amazon.awssdk.services.apigateway.model.DeleteModelRequest = {
    import DeleteModelRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.apigateway.model.DeleteModelRequest
      .builder()
      .restApiId(restApiId: java.lang.String)
      .modelName(modelName: java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.apigateway.model.DeleteModelRequest.ReadOnly =
    zio.aws.apigateway.model.DeleteModelRequest.wrap(buildAwsValue())
}
object DeleteModelRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.apigateway.model.DeleteModelRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.apigateway.model.DeleteModelRequest =
      zio.aws.apigateway.model.DeleteModelRequest(restApiId, modelName)
    def restApiId: String
    def modelName: String
    def getRestApiId: ZIO[Any, Nothing, String] = ZIO.succeed(restApiId)
    def getModelName: ZIO[Any, Nothing, String] = ZIO.succeed(modelName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.apigateway.model.DeleteModelRequest
  ) extends zio.aws.apigateway.model.DeleteModelRequest.ReadOnly {
    override val restApiId: String = impl.restApiId(): String
    override val modelName: String = impl.modelName(): String
  }
  def wrap(
      impl: software.amazon.awssdk.services.apigateway.model.DeleteModelRequest
  ): zio.aws.apigateway.model.DeleteModelRequest.ReadOnly = new Wrapper(impl)
}
