package zio.aws.apigateway.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class DeleteRequestValidatorRequest(
    restApiId: String,
    requestValidatorId: String
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.apigateway.model.DeleteRequestValidatorRequest = {
    import DeleteRequestValidatorRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.apigateway.model.DeleteRequestValidatorRequest
      .builder()
      .restApiId(restApiId: java.lang.String)
      .requestValidatorId(requestValidatorId: java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.apigateway.model.DeleteRequestValidatorRequest.ReadOnly =
    zio.aws.apigateway.model.DeleteRequestValidatorRequest.wrap(buildAwsValue())
}
object DeleteRequestValidatorRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.apigateway.model.DeleteRequestValidatorRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.apigateway.model.DeleteRequestValidatorRequest =
      zio.aws.apigateway.model
        .DeleteRequestValidatorRequest(restApiId, requestValidatorId)
    def restApiId: String
    def requestValidatorId: String
    def getRestApiId: ZIO[Any, Nothing, String] = ZIO.succeed(restApiId)
    def getRequestValidatorId: ZIO[Any, Nothing, String] =
      ZIO.succeed(requestValidatorId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.apigateway.model.DeleteRequestValidatorRequest
  ) extends zio.aws.apigateway.model.DeleteRequestValidatorRequest.ReadOnly {
    override val restApiId: String = impl.restApiId(): String
    override val requestValidatorId: String = impl.requestValidatorId(): String
  }
  def wrap(
      impl: software.amazon.awssdk.services.apigateway.model.DeleteRequestValidatorRequest
  ): zio.aws.apigateway.model.DeleteRequestValidatorRequest.ReadOnly =
    new Wrapper(impl)
}
