package zio.aws.apigateway.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class DeleteUsagePlanRequest(usagePlanId: String) {
  def buildAwsValue()
      : software.amazon.awssdk.services.apigateway.model.DeleteUsagePlanRequest = {
    import DeleteUsagePlanRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.apigateway.model.DeleteUsagePlanRequest
      .builder()
      .usagePlanId(usagePlanId: java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.apigateway.model.DeleteUsagePlanRequest.ReadOnly =
    zio.aws.apigateway.model.DeleteUsagePlanRequest.wrap(buildAwsValue())
}
object DeleteUsagePlanRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.apigateway.model.DeleteUsagePlanRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.apigateway.model.DeleteUsagePlanRequest =
      zio.aws.apigateway.model.DeleteUsagePlanRequest(usagePlanId)
    def usagePlanId: String
    def getUsagePlanId: ZIO[Any, Nothing, String] = ZIO.succeed(usagePlanId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.apigateway.model.DeleteUsagePlanRequest
  ) extends zio.aws.apigateway.model.DeleteUsagePlanRequest.ReadOnly {
    override val usagePlanId: String = impl.usagePlanId(): String
  }
  def wrap(
      impl: software.amazon.awssdk.services.apigateway.model.DeleteUsagePlanRequest
  ): zio.aws.apigateway.model.DeleteUsagePlanRequest.ReadOnly = new Wrapper(
    impl
  )
}
