package zio.aws.apigateway.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class EndpointConfiguration(
    types: Optional[Iterable[zio.aws.apigateway.model.EndpointType]] =
      Optional.Absent,
    vpcEndpointIds: Optional[Iterable[String]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.apigateway.model.EndpointConfiguration = {
    import EndpointConfiguration.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.apigateway.model.EndpointConfiguration
      .builder()
      .optionallyWith(
        types.map(value =>
          value.map { item =>
            item.unwrap.toString
          }.asJavaCollection
        )
      )(_.typesWithStrings)
      .optionallyWith(
        vpcEndpointIds.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.vpcEndpointIds)
      .build()
  }
  def asReadOnly: zio.aws.apigateway.model.EndpointConfiguration.ReadOnly =
    zio.aws.apigateway.model.EndpointConfiguration.wrap(buildAwsValue())
}
object EndpointConfiguration {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.apigateway.model.EndpointConfiguration
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.apigateway.model.EndpointConfiguration =
      zio.aws.apigateway.model.EndpointConfiguration(
        types.map(value => value),
        vpcEndpointIds.map(value => value)
      )
    def types: Optional[List[zio.aws.apigateway.model.EndpointType]]
    def vpcEndpointIds: Optional[List[String]]
    def getTypes
        : ZIO[Any, AwsError, List[zio.aws.apigateway.model.EndpointType]] =
      AwsError.unwrapOptionField("types", types)
    def getVpcEndpointIds: ZIO[Any, AwsError, List[String]] =
      AwsError.unwrapOptionField("vpcEndpointIds", vpcEndpointIds)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.apigateway.model.EndpointConfiguration
  ) extends zio.aws.apigateway.model.EndpointConfiguration.ReadOnly {
    override val types: Optional[List[zio.aws.apigateway.model.EndpointType]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.types())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.apigateway.model.EndpointType.wrap(item)
          }.toList
        )
    override val vpcEndpointIds: Optional[List[String]] = zio.aws.core.internal
      .optionalFromNullable(impl.vpcEndpointIds())
      .map(value =>
        value.asScala.map { item =>
          item: String
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.apigateway.model.EndpointConfiguration
  ): zio.aws.apigateway.model.EndpointConfiguration.ReadOnly = new Wrapper(impl)
}
