package zio.aws.apigateway.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class GetBasePathMappingRequest(
    domainName: String,
    basePath: String
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.apigateway.model.GetBasePathMappingRequest = {
    import GetBasePathMappingRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.apigateway.model.GetBasePathMappingRequest
      .builder()
      .domainName(domainName: java.lang.String)
      .basePath(basePath: java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.apigateway.model.GetBasePathMappingRequest.ReadOnly =
    zio.aws.apigateway.model.GetBasePathMappingRequest.wrap(buildAwsValue())
}
object GetBasePathMappingRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.apigateway.model.GetBasePathMappingRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.apigateway.model.GetBasePathMappingRequest =
      zio.aws.apigateway.model.GetBasePathMappingRequest(domainName, basePath)
    def domainName: String
    def basePath: String
    def getDomainName: ZIO[Any, Nothing, String] = ZIO.succeed(domainName)
    def getBasePath: ZIO[Any, Nothing, String] = ZIO.succeed(basePath)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.apigateway.model.GetBasePathMappingRequest
  ) extends zio.aws.apigateway.model.GetBasePathMappingRequest.ReadOnly {
    override val domainName: String = impl.domainName(): String
    override val basePath: String = impl.basePath(): String
  }
  def wrap(
      impl: software.amazon.awssdk.services.apigateway.model.GetBasePathMappingRequest
  ): zio.aws.apigateway.model.GetBasePathMappingRequest.ReadOnly = new Wrapper(
    impl
  )
}
