package zio.aws.apigateway.model
import zio.aws.apigateway.model.primitives.NullableInteger
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters.*
final case class GetDocumentationPartsRequest(
    restApiId: String,
    `type`: Optional[zio.aws.apigateway.model.DocumentationPartType] =
      Optional.Absent,
    nameQuery: Optional[String] = Optional.Absent,
    path: Optional[String] = Optional.Absent,
    position: Optional[String] = Optional.Absent,
    limit: Optional[NullableInteger] = Optional.Absent,
    locationStatus: Optional[zio.aws.apigateway.model.LocationStatusType] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.apigateway.model.GetDocumentationPartsRequest = {
    import GetDocumentationPartsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.apigateway.model.GetDocumentationPartsRequest
      .builder()
      .restApiId(restApiId: java.lang.String)
      .optionallyWith(`type`.map(value => value.unwrap))(_.`type`)
      .optionallyWith(nameQuery.map(value => value: java.lang.String))(
        _.nameQuery
      )
      .optionallyWith(path.map(value => value: java.lang.String))(_.path)
      .optionallyWith(position.map(value => value: java.lang.String))(
        _.position
      )
      .optionallyWith(limit.map(value => value: Integer))(_.limit)
      .optionallyWith(locationStatus.map(value => value.unwrap))(
        _.locationStatus
      )
      .build()
  }
  def asReadOnly
      : zio.aws.apigateway.model.GetDocumentationPartsRequest.ReadOnly =
    zio.aws.apigateway.model.GetDocumentationPartsRequest.wrap(buildAwsValue())
}
object GetDocumentationPartsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.apigateway.model.GetDocumentationPartsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.apigateway.model.GetDocumentationPartsRequest =
      zio.aws.apigateway.model.GetDocumentationPartsRequest(
        restApiId,
        `type`.map(value => value),
        nameQuery.map(value => value),
        path.map(value => value),
        position.map(value => value),
        limit.map(value => value),
        locationStatus.map(value => value)
      )
    def restApiId: String
    def `type`: Optional[zio.aws.apigateway.model.DocumentationPartType]
    def nameQuery: Optional[String]
    def path: Optional[String]
    def position: Optional[String]
    def limit: Optional[NullableInteger]
    def locationStatus: Optional[zio.aws.apigateway.model.LocationStatusType]
    def getRestApiId: ZIO[Any, Nothing, String] = ZIO.succeed(restApiId)
    def getType
        : ZIO[Any, AwsError, zio.aws.apigateway.model.DocumentationPartType] =
      AwsError.unwrapOptionField("type", `type`)
    def getNameQuery: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nameQuery", nameQuery)
    def getPath: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("path", path)
    def getPosition: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("position", position)
    def getLimit: ZIO[Any, AwsError, NullableInteger] =
      AwsError.unwrapOptionField("limit", limit)
    def getLocationStatus
        : ZIO[Any, AwsError, zio.aws.apigateway.model.LocationStatusType] =
      AwsError.unwrapOptionField("locationStatus", locationStatus)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.apigateway.model.GetDocumentationPartsRequest
  ) extends zio.aws.apigateway.model.GetDocumentationPartsRequest.ReadOnly {
    override val restApiId: String = impl.restApiId(): String
    override val `type`
        : Optional[zio.aws.apigateway.model.DocumentationPartType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.`type`())
        .map(value =>
          zio.aws.apigateway.model.DocumentationPartType.wrap(value)
        )
    override val nameQuery: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.nameQuery())
      .map(value => value: String)
    override val path: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.path())
      .map(value => value: String)
    override val position: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.position())
      .map(value => value: String)
    override val limit: Optional[NullableInteger] = zio.aws.core.internal
      .optionalFromNullable(impl.limit())
      .map(value => value: NullableInteger)
    override val locationStatus
        : Optional[zio.aws.apigateway.model.LocationStatusType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.locationStatus())
        .map(value => zio.aws.apigateway.model.LocationStatusType.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.apigateway.model.GetDocumentationPartsRequest
  ): zio.aws.apigateway.model.GetDocumentationPartsRequest.ReadOnly =
    new Wrapper(impl)
}
