package zio.aws.apigateway.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class GetModelTemplateRequest(restApiId: String, modelName: String) {
  def buildAwsValue()
      : software.amazon.awssdk.services.apigateway.model.GetModelTemplateRequest = {
    import GetModelTemplateRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.apigateway.model.GetModelTemplateRequest
      .builder()
      .restApiId(restApiId: java.lang.String)
      .modelName(modelName: java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.apigateway.model.GetModelTemplateRequest.ReadOnly =
    zio.aws.apigateway.model.GetModelTemplateRequest.wrap(buildAwsValue())
}
object GetModelTemplateRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.apigateway.model.GetModelTemplateRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.apigateway.model.GetModelTemplateRequest =
      zio.aws.apigateway.model.GetModelTemplateRequest(restApiId, modelName)
    def restApiId: String
    def modelName: String
    def getRestApiId: ZIO[Any, Nothing, String] = ZIO.succeed(restApiId)
    def getModelName: ZIO[Any, Nothing, String] = ZIO.succeed(modelName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.apigateway.model.GetModelTemplateRequest
  ) extends zio.aws.apigateway.model.GetModelTemplateRequest.ReadOnly {
    override val restApiId: String = impl.restApiId(): String
    override val modelName: String = impl.modelName(): String
  }
  def wrap(
      impl: software.amazon.awssdk.services.apigateway.model.GetModelTemplateRequest
  ): zio.aws.apigateway.model.GetModelTemplateRequest.ReadOnly = new Wrapper(
    impl
  )
}
