package zio.aws.apigateway.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class UpdateApiKeyRequest(
    apiKey: String,
    patchOperations: Optional[
      Iterable[zio.aws.apigateway.model.PatchOperation]
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.apigateway.model.UpdateApiKeyRequest = {
    import UpdateApiKeyRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.apigateway.model.UpdateApiKeyRequest
      .builder()
      .apiKey(apiKey: java.lang.String)
      .optionallyWith(
        patchOperations.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.patchOperations)
      .build()
  }
  def asReadOnly: zio.aws.apigateway.model.UpdateApiKeyRequest.ReadOnly =
    zio.aws.apigateway.model.UpdateApiKeyRequest.wrap(buildAwsValue())
}
object UpdateApiKeyRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.apigateway.model.UpdateApiKeyRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.apigateway.model.UpdateApiKeyRequest =
      zio.aws.apigateway.model.UpdateApiKeyRequest(
        apiKey,
        patchOperations.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def apiKey: String
    def patchOperations
        : Optional[List[zio.aws.apigateway.model.PatchOperation.ReadOnly]]
    def getApiKey: ZIO[Any, Nothing, String] = ZIO.succeed(apiKey)
    def getPatchOperations: ZIO[Any, AwsError, List[
      zio.aws.apigateway.model.PatchOperation.ReadOnly
    ]] = AwsError.unwrapOptionField("patchOperations", patchOperations)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.apigateway.model.UpdateApiKeyRequest
  ) extends zio.aws.apigateway.model.UpdateApiKeyRequest.ReadOnly {
    override val apiKey: String = impl.apiKey(): String
    override val patchOperations
        : Optional[List[zio.aws.apigateway.model.PatchOperation.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.patchOperations())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.apigateway.model.PatchOperation.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.apigateway.model.UpdateApiKeyRequest
  ): zio.aws.apigateway.model.UpdateApiKeyRequest.ReadOnly = new Wrapper(impl)
}
