package zio.aws.apigateway.model
import zio.aws.apigateway.model.primitives.Timestamp
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import scala.jdk.CollectionConverters.*
final case class UpdateDocumentationVersionResponse(
    version: Optional[String] = Optional.Absent,
    createdDate: Optional[Timestamp] = Optional.Absent,
    description: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.apigateway.model.UpdateDocumentationVersionResponse = {
    import UpdateDocumentationVersionResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.apigateway.model.UpdateDocumentationVersionResponse
      .builder()
      .optionallyWith(version.map(value => value: java.lang.String))(_.version)
      .optionallyWith(
        createdDate.map(value => Timestamp.unwrap(value): Instant)
      )(_.createdDate)
      .optionallyWith(description.map(value => value: java.lang.String))(
        _.description
      )
      .build()
  }
  def asReadOnly
      : zio.aws.apigateway.model.UpdateDocumentationVersionResponse.ReadOnly =
    zio.aws.apigateway.model.UpdateDocumentationVersionResponse
      .wrap(buildAwsValue())
}
object UpdateDocumentationVersionResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.apigateway.model.UpdateDocumentationVersionResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.apigateway.model.UpdateDocumentationVersionResponse =
      zio.aws.apigateway.model.UpdateDocumentationVersionResponse(
        version.map(value => value),
        createdDate.map(value => value),
        description.map(value => value)
      )
    def version: Optional[String]
    def createdDate: Optional[Timestamp]
    def description: Optional[String]
    def getVersion: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("version", version)
    def getCreatedDate: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("createdDate", createdDate)
    def getDescription: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("description", description)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.apigateway.model.UpdateDocumentationVersionResponse
  ) extends zio.aws.apigateway.model.UpdateDocumentationVersionResponse.ReadOnly {
    override val version: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.version())
      .map(value => value: String)
    override val createdDate: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.createdDate())
      .map(value => zio.aws.apigateway.model.primitives.Timestamp(value))
    override val description: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.description())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.apigateway.model.UpdateDocumentationVersionResponse
  ): zio.aws.apigateway.model.UpdateDocumentationVersionResponse.ReadOnly =
    new Wrapper(impl)
}
