package zio.aws.apigateway.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.apigateway.model.primitives.StatusCode
import scala.jdk.CollectionConverters.*
final case class UpdateIntegrationResponseResponse(
    statusCode: Optional[StatusCode] = Optional.Absent,
    selectionPattern: Optional[String] = Optional.Absent,
    responseParameters: Optional[Map[String, String]] = Optional.Absent,
    responseTemplates: Optional[Map[String, String]] = Optional.Absent,
    contentHandling: Optional[
      zio.aws.apigateway.model.ContentHandlingStrategy
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.apigateway.model.UpdateIntegrationResponseResponse = {
    import UpdateIntegrationResponseResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.apigateway.model.UpdateIntegrationResponseResponse
      .builder()
      .optionallyWith(
        statusCode.map(value => StatusCode.unwrap(value): java.lang.String)
      )(_.statusCode)
      .optionallyWith(selectionPattern.map(value => value: java.lang.String))(
        _.selectionPattern
      )
      .optionallyWith(
        responseParameters.map(value =>
          value
            .map({ case (key, value) =>
              (key: java.lang.String) -> (value: java.lang.String)
            })
            .asJava
        )
      )(_.responseParameters)
      .optionallyWith(
        responseTemplates.map(value =>
          value
            .map({ case (key, value) =>
              (key: java.lang.String) -> (value: java.lang.String)
            })
            .asJava
        )
      )(_.responseTemplates)
      .optionallyWith(contentHandling.map(value => value.unwrap))(
        _.contentHandling
      )
      .build()
  }
  def asReadOnly
      : zio.aws.apigateway.model.UpdateIntegrationResponseResponse.ReadOnly =
    zio.aws.apigateway.model.UpdateIntegrationResponseResponse
      .wrap(buildAwsValue())
}
object UpdateIntegrationResponseResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.apigateway.model.UpdateIntegrationResponseResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.apigateway.model.UpdateIntegrationResponseResponse =
      zio.aws.apigateway.model.UpdateIntegrationResponseResponse(
        statusCode.map(value => value),
        selectionPattern.map(value => value),
        responseParameters.map(value => value),
        responseTemplates.map(value => value),
        contentHandling.map(value => value)
      )
    def statusCode: Optional[StatusCode]
    def selectionPattern: Optional[String]
    def responseParameters: Optional[Map[String, String]]
    def responseTemplates: Optional[Map[String, String]]
    def contentHandling
        : Optional[zio.aws.apigateway.model.ContentHandlingStrategy]
    def getStatusCode: ZIO[Any, AwsError, StatusCode] =
      AwsError.unwrapOptionField("statusCode", statusCode)
    def getSelectionPattern: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("selectionPattern", selectionPattern)
    def getResponseParameters: ZIO[Any, AwsError, Map[String, String]] =
      AwsError.unwrapOptionField("responseParameters", responseParameters)
    def getResponseTemplates: ZIO[Any, AwsError, Map[String, String]] =
      AwsError.unwrapOptionField("responseTemplates", responseTemplates)
    def getContentHandling
        : ZIO[Any, AwsError, zio.aws.apigateway.model.ContentHandlingStrategy] =
      AwsError.unwrapOptionField("contentHandling", contentHandling)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.apigateway.model.UpdateIntegrationResponseResponse
  ) extends zio.aws.apigateway.model.UpdateIntegrationResponseResponse.ReadOnly {
    override val statusCode: Optional[StatusCode] = zio.aws.core.internal
      .optionalFromNullable(impl.statusCode())
      .map(value => zio.aws.apigateway.model.primitives.StatusCode(value))
    override val selectionPattern: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.selectionPattern())
      .map(value => value: String)
    override val responseParameters: Optional[Map[String, String]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.responseParameters())
        .map(value =>
          value.asScala
            .map({ case (key, value) =>
              (key: String) -> (value: String)
            })
            .toMap
        )
    override val responseTemplates: Optional[Map[String, String]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.responseTemplates())
        .map(value =>
          value.asScala
            .map({ case (key, value) =>
              (key: String) -> (value: String)
            })
            .toMap
        )
    override val contentHandling
        : Optional[zio.aws.apigateway.model.ContentHandlingStrategy] =
      zio.aws.core.internal
        .optionalFromNullable(impl.contentHandling())
        .map(value =>
          zio.aws.apigateway.model.ContentHandlingStrategy.wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.apigateway.model.UpdateIntegrationResponseResponse
  ): zio.aws.apigateway.model.UpdateIntegrationResponseResponse.ReadOnly =
    new Wrapper(impl)
}
