package zio.aws.apigateway
import zio.aws.apigateway.model.ApiKey.ReadOnly
import zio.aws.core.config.AwsConfig
import software.amazon.awssdk.services.apigateway.{
  ApiGatewayAsyncClientBuilder,
  ApiGatewayAsyncClient
}
import zio.aws.core.{AwsServiceBase, AwsError}
import zio.aws.core.aspects.{AwsCallAspect, AspectSupport}
import zio.{ZEnvironment, IO, ZIO, ZLayer, Scope}
import software.amazon.awssdk.services.apigateway.model.{
  DeleteResourceResponse,
  FlushStageAuthorizersCacheRequest,
  GetDocumentationVersionRequest,
  UpdateIntegrationRequest,
  UpdateIntegrationResponseResponse,
  UpdateResourceResponse,
  DeleteDeploymentRequest,
  GetUsagePlanKeysRequest,
  GetGatewayResponsesResponse,
  BasePathMapping,
  GetSdkRequest,
  GetAccountResponse,
  GetBasePathMappingsRequest,
  GetDomainNamesRequest,
  DeleteApiKeyRequest,
  GetModelsResponse,
  UpdateDocumentationVersionRequest,
  GetMethodResponseRequest,
  UpdateBasePathMappingResponse,
  GetBasePathMappingRequest,
  ApiKey,
  UpdateUsagePlanRequest,
  DeleteAuthorizerResponse,
  GetResourceResponse,
  CreateUsagePlanKeyResponse,
  CreateStageRequest,
  GetModelResponse,
  CreateStageResponse,
  PutGatewayResponseResponse,
  CreateApiKeyRequest,
  CreateVpcLinkRequest,
  UpdateIntegrationResponseRequest,
  DeleteUsagePlanKeyRequest,
  GetTagsResponse,
  GenerateClientCertificateRequest,
  ImportRestApiRequest,
  GetGatewayResponseRequest,
  UpdateDeploymentRequest,
  GetIntegrationRequest,
  GetDeploymentsResponse,
  DeleteVpcLinkRequest,
  UpdateMethodRequest,
  GetRestApiRequest,
  UpdateVpcLinkRequest,
  DeleteStageRequest,
  DeleteIntegrationResponse,
  PutIntegrationResponseResponse,
  GetAuthorizerRequest,
  UpdateAccountResponse,
  CreateAuthorizerRequest,
  UpdateUsagePlanResponse,
  PutIntegrationResponseRequest,
  GetModelTemplateResponse,
  GetStagesRequest,
  PutGatewayResponseRequest,
  UpdateClientCertificateRequest,
  GetUsagePlansRequest,
  GetDocumentationPartsResponse,
  DeleteClientCertificateRequest,
  DeleteUsagePlanRequest,
  PutMethodResponseRequest,
  GetDeploymentsRequest,
  PutMethodRequest,
  UpdateStageResponse,
  UsagePlan,
  CreateUsagePlanKeyRequest,
  GetApiKeysResponse,
  GetUsagePlansResponse,
  TestInvokeMethodRequest,
  GetRestApiResponse,
  DeleteGatewayResponseResponse,
  GetClientCertificateRequest,
  GetUsagePlanKeysResponse,
  UpdateMethodResponse,
  UpdateAccountRequest,
  CreateModelRequest,
  GetMethodResponseResponse,
  UpdateApiKeyResponse,
  GetDocumentationPartResponse,
  DeleteIntegrationRequest,
  CreateRequestValidatorResponse,
  DomainName,
  FlushStageAuthorizersCacheResponse,
  ImportDocumentationPartsResponse,
  DeleteGatewayResponseRequest,
  PutRestApiRequest,
  UpdateIntegrationResponse,
  CreateDomainNameResponse,
  GetRestApisRequest,
  GetIntegrationResponseRequest,
  GetUsageResponse,
  CreateVpcLinkResponse,
  CreateRestApiRequest,
  CreateDeploymentResponse,
  GetSdkTypeRequest,
  GetUsagePlanKeyRequest,
  DeleteAuthorizerRequest,
  DeleteRequestValidatorRequest,
  GetSdkTypeResponse,
  UntagResourceResponse,
  GetClientCertificatesResponse,
  GetSdkTypesRequest,
  CreateRequestValidatorRequest,
  CreateDocumentationVersionResponse,
  GetClientCertificatesRequest,
  DeleteModelResponse,
  DeleteResourceRequest,
  GetVpcLinksRequest,
  CreateDocumentationVersionRequest,
  GetApiKeyRequest,
  GetUsagePlanRequest,
  CreateResourceResponse,
  DeleteUsagePlanResponse,
  Model,
  GetAccountRequest,
  GetDocumentationVersionResponse,
  Resource,
  GetAuthorizersResponse,
  ClientCertificate,
  CreateRestApiResponse,
  TestInvokeAuthorizerResponse,
  UpdateDomainNameResponse,
  GetResourceRequest,
  Deployment,
  DeleteDocumentationVersionResponse,
  GetUsagePlanKeyResponse,
  DeleteDocumentationVersionRequest,
  GetModelTemplateRequest,
  DeleteDomainNameRequest,
  CreateDocumentationPartResponse,
  DeleteDomainNameResponse,
  GetDocumentationPartRequest,
  ImportDocumentationPartsRequest,
  UpdateAuthorizerResponse,
  DeleteBasePathMappingResponse,
  GetStagesResponse,
  UpdateRestApiResponse,
  RestApi,
  UpdateDomainNameRequest,
  PutMethodResponse,
  GetBasePathMappingResponse,
  CreateDomainNameRequest,
  GetVpcLinkRequest,
  DeleteDocumentationPartResponse,
  UpdateBasePathMappingRequest,
  DeleteDocumentationPartRequest,
  FlushStageCacheResponse,
  UpdateUsageResponse,
  TestInvokeMethodResponse,
  GetDomainNamesResponse,
  UpdateModelResponse,
  GetDocumentationVersionsResponse,
  ImportApiKeysRequest,
  UpdateMethodResponseResponse,
  GetApiKeyResponse,
  UpdateDeploymentResponse,
  PutRestApiResponse,
  CreateResourceRequest,
  CreateAuthorizerResponse,
  DeleteRestApiRequest,
  GetApiKeysRequest,
  UpdateDocumentationPartResponse,
  CreateModelResponse,
  DeleteMethodRequest,
  UntagResourceRequest,
  GetStageRequest,
  DeleteMethodResponse,
  FlushStageCacheRequest,
  CreateUsagePlanRequest,
  DeleteVpcLinkResponse,
  UpdateStageRequest,
  GetIntegrationResponse,
  GetVpcLinkResponse,
  UpdateRequestValidatorResponse,
  GetSdkResponse,
  DeleteClientCertificateResponse,
  GetAuthorizerResponse,
  GetTagsRequest,
  GetRestApisResponse,
  UsagePlanKey,
  GetDocumentationVersionsRequest,
  ImportApiKeysResponse,
  GetStageResponse,
  PutIntegrationResponse,
  DeleteApiKeyResponse,
  GetClientCertificateResponse,
  DeleteMethodResponseRequest,
  DeleteIntegrationResponseRequest,
  CreateBasePathMappingResponse,
  GetDomainNameResponse,
  VpcLink,
  DeleteRequestValidatorResponse,
  DeleteRestApiResponse,
  UpdateRestApiRequest,
  GetExportRequest,
  CreateDeploymentRequest,
  UpdateModelRequest,
  GetResourcesResponse,
  UpdateMethodResponseRequest,
  GetRequestValidatorsResponse,
  GetModelRequest,
  CreateBasePathMappingRequest,
  GetDeploymentRequest,
  CreateDocumentationPartRequest,
  GetUsageRequest,
  UpdateGatewayResponseResponse,
  TestInvokeAuthorizerRequest,
  ImportRestApiResponse,
  GetIntegrationResponseResponse,
  GetResourcesRequest,
  GetModelsRequest,
  DeleteModelRequest,
  GetMethodResponse,
  UpdateRequestValidatorRequest,
  DeleteIntegrationResponseResponse,
  GetGatewayResponsesRequest,
  GetExportResponse,
  CreateUsagePlanResponse,
  GetAuthorizersRequest,
  GetRequestValidatorsRequest,
  GetDomainNameRequest,
  PutMethodResponseResponse,
  TagResourceResponse,
  UpdateDocumentationVersionResponse,
  GetVpcLinksResponse,
  UpdateResourceRequest,
  DeleteDeploymentResponse,
  GetUsagePlanResponse,
  GenerateClientCertificateResponse,
  PutIntegrationRequest,
  UpdateUsageRequest,
  CreateApiKeyResponse,
  GetGatewayResponseResponse,
  UpdateClientCertificateResponse,
  GetDeploymentResponse,
  DeleteUsagePlanKeyResponse,
  UpdateGatewayResponseRequest,
  GetRequestValidatorRequest,
  UpdateVpcLinkResponse,
  GetMethodRequest,
  GetSdkTypesResponse,
  TagResourceRequest,
  UpdateAuthorizerRequest,
  DeleteBasePathMappingRequest,
  GetBasePathMappingsResponse,
  DeleteMethodResponseResponse,
  GetDocumentationPartsRequest,
  GetRequestValidatorResponse,
  DeleteStageResponse,
  UpdateApiKeyRequest,
  UpdateDocumentationPartRequest
}
import software.amazon.awssdk.services.apigateway.paginators.{
  GetDomainNamesPublisher,
  GetDeploymentsPublisher,
  GetResourcesPublisher,
  GetUsagePlansPublisher,
  GetRestApisPublisher,
  GetModelsPublisher,
  GetClientCertificatesPublisher,
  GetBasePathMappingsPublisher,
  GetUsagePlanKeysPublisher,
  GetApiKeysPublisher,
  GetVpcLinksPublisher
}
import zio.stream.ZStream
import scala.jdk.CollectionConverters.*
trait ApiGateway extends AspectSupport[ApiGateway] {
  val api: ApiGatewayAsyncClient
  def getResource(
      request: zio.aws.apigateway.model.GetResourceRequest
  ): IO[AwsError, zio.aws.apigateway.model.GetResourceResponse.ReadOnly]
  def updateAccount(
      request: zio.aws.apigateway.model.UpdateAccountRequest
  ): IO[AwsError, zio.aws.apigateway.model.UpdateAccountResponse.ReadOnly]
  def updateStage(
      request: zio.aws.apigateway.model.UpdateStageRequest
  ): IO[AwsError, zio.aws.apigateway.model.UpdateStageResponse.ReadOnly]
  def getVpcLinks(
      request: zio.aws.apigateway.model.GetVpcLinksRequest
  ): ZStream[Any, AwsError, zio.aws.apigateway.model.VpcLink.ReadOnly]
  def getVpcLinksPaginated(
      request: zio.aws.apigateway.model.GetVpcLinksRequest
  ): IO[AwsError, zio.aws.apigateway.model.GetVpcLinksResponse.ReadOnly]
  def createResource(
      request: zio.aws.apigateway.model.CreateResourceRequest
  ): IO[AwsError, zio.aws.apigateway.model.CreateResourceResponse.ReadOnly]
  def deleteDocumentationVersion(
      request: zio.aws.apigateway.model.DeleteDocumentationVersionRequest
  ): IO[AwsError, Unit]
  def testInvokeAuthorizer(
      request: zio.aws.apigateway.model.TestInvokeAuthorizerRequest
  ): IO[
    AwsError,
    zio.aws.apigateway.model.TestInvokeAuthorizerResponse.ReadOnly
  ]
  def getRequestValidators(
      request: zio.aws.apigateway.model.GetRequestValidatorsRequest
  ): IO[
    AwsError,
    zio.aws.apigateway.model.GetRequestValidatorsResponse.ReadOnly
  ]
  def getDocumentationPart(
      request: zio.aws.apigateway.model.GetDocumentationPartRequest
  ): IO[
    AwsError,
    zio.aws.apigateway.model.GetDocumentationPartResponse.ReadOnly
  ]
  def updateResource(
      request: zio.aws.apigateway.model.UpdateResourceRequest
  ): IO[AwsError, zio.aws.apigateway.model.UpdateResourceResponse.ReadOnly]
  def deleteRestApi(
      request: zio.aws.apigateway.model.DeleteRestApiRequest
  ): IO[AwsError, Unit]
  def getMethod(
      request: zio.aws.apigateway.model.GetMethodRequest
  ): IO[AwsError, zio.aws.apigateway.model.GetMethodResponse.ReadOnly]
  def deleteUsagePlan(
      request: zio.aws.apigateway.model.DeleteUsagePlanRequest
  ): IO[AwsError, Unit]
  def getDomainNames(
      request: zio.aws.apigateway.model.GetDomainNamesRequest
  ): ZStream[Any, AwsError, zio.aws.apigateway.model.DomainName.ReadOnly]
  def getDomainNamesPaginated(
      request: zio.aws.apigateway.model.GetDomainNamesRequest
  ): IO[AwsError, zio.aws.apigateway.model.GetDomainNamesResponse.ReadOnly]
  def createBasePathMapping(
      request: zio.aws.apigateway.model.CreateBasePathMappingRequest
  ): IO[
    AwsError,
    zio.aws.apigateway.model.CreateBasePathMappingResponse.ReadOnly
  ]
  def updateBasePathMapping(
      request: zio.aws.apigateway.model.UpdateBasePathMappingRequest
  ): IO[
    AwsError,
    zio.aws.apigateway.model.UpdateBasePathMappingResponse.ReadOnly
  ]
  def createModel(
      request: zio.aws.apigateway.model.CreateModelRequest
  ): IO[AwsError, zio.aws.apigateway.model.CreateModelResponse.ReadOnly]
  def getMethodResponse(
      request: zio.aws.apigateway.model.GetMethodResponseRequest
  ): IO[AwsError, zio.aws.apigateway.model.GetMethodResponseResponse.ReadOnly]
  def getClientCertificates(
      request: zio.aws.apigateway.model.GetClientCertificatesRequest
  ): ZStream[Any, AwsError, zio.aws.apigateway.model.ClientCertificate.ReadOnly]
  def getClientCertificatesPaginated(
      request: zio.aws.apigateway.model.GetClientCertificatesRequest
  ): IO[
    AwsError,
    zio.aws.apigateway.model.GetClientCertificatesResponse.ReadOnly
  ]
  def createUsagePlan(
      request: zio.aws.apigateway.model.CreateUsagePlanRequest
  ): IO[AwsError, zio.aws.apigateway.model.CreateUsagePlanResponse.ReadOnly]
  def updateApiKey(
      request: zio.aws.apigateway.model.UpdateApiKeyRequest
  ): IO[AwsError, zio.aws.apigateway.model.UpdateApiKeyResponse.ReadOnly]
  def updateModel(
      request: zio.aws.apigateway.model.UpdateModelRequest
  ): IO[AwsError, zio.aws.apigateway.model.UpdateModelResponse.ReadOnly]
  def createDocumentationPart(
      request: zio.aws.apigateway.model.CreateDocumentationPartRequest
  ): IO[
    AwsError,
    zio.aws.apigateway.model.CreateDocumentationPartResponse.ReadOnly
  ]
  def getDocumentationParts(
      request: zio.aws.apigateway.model.GetDocumentationPartsRequest
  ): IO[
    AwsError,
    zio.aws.apigateway.model.GetDocumentationPartsResponse.ReadOnly
  ]
  def deleteVpcLink(
      request: zio.aws.apigateway.model.DeleteVpcLinkRequest
  ): IO[AwsError, Unit]
  def getVpcLink(
      request: zio.aws.apigateway.model.GetVpcLinkRequest
  ): IO[AwsError, zio.aws.apigateway.model.GetVpcLinkResponse.ReadOnly]
  def createRequestValidator(
      request: zio.aws.apigateway.model.CreateRequestValidatorRequest
  ): IO[
    AwsError,
    zio.aws.apigateway.model.CreateRequestValidatorResponse.ReadOnly
  ]
  def testInvokeMethod(
      request: zio.aws.apigateway.model.TestInvokeMethodRequest
  ): IO[AwsError, zio.aws.apigateway.model.TestInvokeMethodResponse.ReadOnly]
  def deleteUsagePlanKey(
      request: zio.aws.apigateway.model.DeleteUsagePlanKeyRequest
  ): IO[AwsError, Unit]
  def putIntegrationResponse(
      request: zio.aws.apigateway.model.PutIntegrationResponseRequest
  ): IO[
    AwsError,
    zio.aws.apigateway.model.PutIntegrationResponseResponse.ReadOnly
  ]
  def getDeployment(
      request: zio.aws.apigateway.model.GetDeploymentRequest
  ): IO[AwsError, zio.aws.apigateway.model.GetDeploymentResponse.ReadOnly]
  def deleteDeployment(
      request: zio.aws.apigateway.model.DeleteDeploymentRequest
  ): IO[AwsError, Unit]
  def flushStageCache(
      request: zio.aws.apigateway.model.FlushStageCacheRequest
  ): IO[AwsError, Unit]
  def getStage(
      request: zio.aws.apigateway.model.GetStageRequest
  ): IO[AwsError, zio.aws.apigateway.model.GetStageResponse.ReadOnly]
  def deleteIntegration(
      request: zio.aws.apigateway.model.DeleteIntegrationRequest
  ): IO[AwsError, Unit]
  def updateDeployment(
      request: zio.aws.apigateway.model.UpdateDeploymentRequest
  ): IO[AwsError, zio.aws.apigateway.model.UpdateDeploymentResponse.ReadOnly]
  def getIntegrationResponse(
      request: zio.aws.apigateway.model.GetIntegrationResponseRequest
  ): IO[
    AwsError,
    zio.aws.apigateway.model.GetIntegrationResponseResponse.ReadOnly
  ]
  def deleteMethodResponse(
      request: zio.aws.apigateway.model.DeleteMethodResponseRequest
  ): IO[AwsError, Unit]
  def getGatewayResponses(
      request: zio.aws.apigateway.model.GetGatewayResponsesRequest
  ): IO[AwsError, zio.aws.apigateway.model.GetGatewayResponsesResponse.ReadOnly]
  def getAccount(
      request: zio.aws.apigateway.model.GetAccountRequest
  ): IO[AwsError, zio.aws.apigateway.model.GetAccountResponse.ReadOnly]
  def updateVpcLink(
      request: zio.aws.apigateway.model.UpdateVpcLinkRequest
  ): IO[AwsError, zio.aws.apigateway.model.UpdateVpcLinkResponse.ReadOnly]
  def getUsage(
      request: zio.aws.apigateway.model.GetUsageRequest
  ): IO[AwsError, zio.aws.apigateway.model.GetUsageResponse.ReadOnly]
  def getSdkType(
      request: zio.aws.apigateway.model.GetSdkTypeRequest
  ): IO[AwsError, zio.aws.apigateway.model.GetSdkTypeResponse.ReadOnly]
  def getExport(
      request: zio.aws.apigateway.model.GetExportRequest
  ): IO[AwsError, zio.aws.apigateway.model.GetExportResponse.ReadOnly]
  def getModel(
      request: zio.aws.apigateway.model.GetModelRequest
  ): IO[AwsError, zio.aws.apigateway.model.GetModelResponse.ReadOnly]
  def createRestApi(
      request: zio.aws.apigateway.model.CreateRestApiRequest
  ): IO[AwsError, zio.aws.apigateway.model.CreateRestApiResponse.ReadOnly]
  def deleteDocumentationPart(
      request: zio.aws.apigateway.model.DeleteDocumentationPartRequest
  ): IO[AwsError, Unit]
  def updateAuthorizer(
      request: zio.aws.apigateway.model.UpdateAuthorizerRequest
  ): IO[AwsError, zio.aws.apigateway.model.UpdateAuthorizerResponse.ReadOnly]
  def putMethodResponse(
      request: zio.aws.apigateway.model.PutMethodResponseRequest
  ): IO[AwsError, zio.aws.apigateway.model.PutMethodResponseResponse.ReadOnly]
  def createDocumentationVersion(
      request: zio.aws.apigateway.model.CreateDocumentationVersionRequest
  ): IO[
    AwsError,
    zio.aws.apigateway.model.CreateDocumentationVersionResponse.ReadOnly
  ]
  def deleteStage(
      request: zio.aws.apigateway.model.DeleteStageRequest
  ): IO[AwsError, Unit]
  def flushStageAuthorizersCache(
      request: zio.aws.apigateway.model.FlushStageAuthorizersCacheRequest
  ): IO[AwsError, Unit]
  def getApiKeys(
      request: zio.aws.apigateway.model.GetApiKeysRequest
  ): ZStream[Any, AwsError, ReadOnly]
  def getApiKeysPaginated(
      request: zio.aws.apigateway.model.GetApiKeysRequest
  ): IO[AwsError, zio.aws.apigateway.model.GetApiKeysResponse.ReadOnly]
  def updateUsage(
      request: zio.aws.apigateway.model.UpdateUsageRequest
  ): IO[AwsError, zio.aws.apigateway.model.UpdateUsageResponse.ReadOnly]
  def deleteModel(
      request: zio.aws.apigateway.model.DeleteModelRequest
  ): IO[AwsError, Unit]
  def deleteMethod(
      request: zio.aws.apigateway.model.DeleteMethodRequest
  ): IO[AwsError, Unit]
  def getClientCertificate(
      request: zio.aws.apigateway.model.GetClientCertificateRequest
  ): IO[
    AwsError,
    zio.aws.apigateway.model.GetClientCertificateResponse.ReadOnly
  ]
  def getRestApis(
      request: zio.aws.apigateway.model.GetRestApisRequest
  ): ZStream[Any, AwsError, zio.aws.apigateway.model.RestApi.ReadOnly]
  def getRestApisPaginated(
      request: zio.aws.apigateway.model.GetRestApisRequest
  ): IO[AwsError, zio.aws.apigateway.model.GetRestApisResponse.ReadOnly]
  def createDomainName(
      request: zio.aws.apigateway.model.CreateDomainNameRequest
  ): IO[AwsError, zio.aws.apigateway.model.CreateDomainNameResponse.ReadOnly]
  def getResources(
      request: zio.aws.apigateway.model.GetResourcesRequest
  ): ZStream[Any, AwsError, zio.aws.apigateway.model.Resource.ReadOnly]
  def getResourcesPaginated(
      request: zio.aws.apigateway.model.GetResourcesRequest
  ): IO[AwsError, zio.aws.apigateway.model.GetResourcesResponse.ReadOnly]
  def getDocumentationVersion(
      request: zio.aws.apigateway.model.GetDocumentationVersionRequest
  ): IO[
    AwsError,
    zio.aws.apigateway.model.GetDocumentationVersionResponse.ReadOnly
  ]
  def updateClientCertificate(
      request: zio.aws.apigateway.model.UpdateClientCertificateRequest
  ): IO[
    AwsError,
    zio.aws.apigateway.model.UpdateClientCertificateResponse.ReadOnly
  ]
  def importApiKeys(
      request: zio.aws.apigateway.model.ImportApiKeysRequest
  ): IO[AwsError, zio.aws.apigateway.model.ImportApiKeysResponse.ReadOnly]
  def createVpcLink(
      request: zio.aws.apigateway.model.CreateVpcLinkRequest
  ): IO[AwsError, zio.aws.apigateway.model.CreateVpcLinkResponse.ReadOnly]
  def getApiKey(
      request: zio.aws.apigateway.model.GetApiKeyRequest
  ): IO[AwsError, zio.aws.apigateway.model.GetApiKeyResponse.ReadOnly]
  def deleteClientCertificate(
      request: zio.aws.apigateway.model.DeleteClientCertificateRequest
  ): IO[AwsError, Unit]
  def updateRestApi(
      request: zio.aws.apigateway.model.UpdateRestApiRequest
  ): IO[AwsError, zio.aws.apigateway.model.UpdateRestApiResponse.ReadOnly]
  def untagResource(
      request: zio.aws.apigateway.model.UntagResourceRequest
  ): IO[AwsError, Unit]
  def getAuthorizers(
      request: zio.aws.apigateway.model.GetAuthorizersRequest
  ): IO[AwsError, zio.aws.apigateway.model.GetAuthorizersResponse.ReadOnly]
  def updateIntegrationResponse(
      request: zio.aws.apigateway.model.UpdateIntegrationResponseRequest
  ): IO[
    AwsError,
    zio.aws.apigateway.model.UpdateIntegrationResponseResponse.ReadOnly
  ]
  def deleteApiKey(
      request: zio.aws.apigateway.model.DeleteApiKeyRequest
  ): IO[AwsError, Unit]
  def createDeployment(
      request: zio.aws.apigateway.model.CreateDeploymentRequest
  ): IO[AwsError, zio.aws.apigateway.model.CreateDeploymentResponse.ReadOnly]
  def updateDocumentationPart(
      request: zio.aws.apigateway.model.UpdateDocumentationPartRequest
  ): IO[
    AwsError,
    zio.aws.apigateway.model.UpdateDocumentationPartResponse.ReadOnly
  ]
  def createApiKey(
      request: zio.aws.apigateway.model.CreateApiKeyRequest
  ): IO[AwsError, zio.aws.apigateway.model.CreateApiKeyResponse.ReadOnly]
  def putIntegration(
      request: zio.aws.apigateway.model.PutIntegrationRequest
  ): IO[AwsError, zio.aws.apigateway.model.PutIntegrationResponse.ReadOnly]
  def importDocumentationParts(
      request: zio.aws.apigateway.model.ImportDocumentationPartsRequest
  ): IO[
    AwsError,
    zio.aws.apigateway.model.ImportDocumentationPartsResponse.ReadOnly
  ]
  def getModelTemplate(
      request: zio.aws.apigateway.model.GetModelTemplateRequest
  ): IO[AwsError, zio.aws.apigateway.model.GetModelTemplateResponse.ReadOnly]
  def createStage(
      request: zio.aws.apigateway.model.CreateStageRequest
  ): IO[AwsError, zio.aws.apigateway.model.CreateStageResponse.ReadOnly]
  def getUsagePlanKey(
      request: zio.aws.apigateway.model.GetUsagePlanKeyRequest
  ): IO[AwsError, zio.aws.apigateway.model.GetUsagePlanKeyResponse.ReadOnly]
  def updateMethodResponse(
      request: zio.aws.apigateway.model.UpdateMethodResponseRequest
  ): IO[
    AwsError,
    zio.aws.apigateway.model.UpdateMethodResponseResponse.ReadOnly
  ]
  def getRestApi(
      request: zio.aws.apigateway.model.GetRestApiRequest
  ): IO[AwsError, zio.aws.apigateway.model.GetRestApiResponse.ReadOnly]
  def createAuthorizer(
      request: zio.aws.apigateway.model.CreateAuthorizerRequest
  ): IO[AwsError, zio.aws.apigateway.model.CreateAuthorizerResponse.ReadOnly]
  def putMethod(
      request: zio.aws.apigateway.model.PutMethodRequest
  ): IO[AwsError, zio.aws.apigateway.model.PutMethodResponse.ReadOnly]
  def getGatewayResponse(
      request: zio.aws.apigateway.model.GetGatewayResponseRequest
  ): IO[AwsError, zio.aws.apigateway.model.GetGatewayResponseResponse.ReadOnly]
  def generateClientCertificate(
      request: zio.aws.apigateway.model.GenerateClientCertificateRequest
  ): IO[
    AwsError,
    zio.aws.apigateway.model.GenerateClientCertificateResponse.ReadOnly
  ]
  def tagResource(
      request: zio.aws.apigateway.model.TagResourceRequest
  ): IO[AwsError, Unit]
  def getUsagePlan(
      request: zio.aws.apigateway.model.GetUsagePlanRequest
  ): IO[AwsError, zio.aws.apigateway.model.GetUsagePlanResponse.ReadOnly]
  def createUsagePlanKey(
      request: zio.aws.apigateway.model.CreateUsagePlanKeyRequest
  ): IO[AwsError, zio.aws.apigateway.model.CreateUsagePlanKeyResponse.ReadOnly]
  def updateUsagePlan(
      request: zio.aws.apigateway.model.UpdateUsagePlanRequest
  ): IO[AwsError, zio.aws.apigateway.model.UpdateUsagePlanResponse.ReadOnly]
  def getIntegration(
      request: zio.aws.apigateway.model.GetIntegrationRequest
  ): IO[AwsError, zio.aws.apigateway.model.GetIntegrationResponse.ReadOnly]
  def getDeployments(
      request: zio.aws.apigateway.model.GetDeploymentsRequest
  ): ZStream[Any, AwsError, zio.aws.apigateway.model.Deployment.ReadOnly]
  def getDeploymentsPaginated(
      request: zio.aws.apigateway.model.GetDeploymentsRequest
  ): IO[AwsError, zio.aws.apigateway.model.GetDeploymentsResponse.ReadOnly]
  def putRestApi(
      request: zio.aws.apigateway.model.PutRestApiRequest
  ): IO[AwsError, zio.aws.apigateway.model.PutRestApiResponse.ReadOnly]
  def getUsagePlans(
      request: zio.aws.apigateway.model.GetUsagePlansRequest
  ): ZStream[Any, AwsError, zio.aws.apigateway.model.UsagePlan.ReadOnly]
  def getUsagePlansPaginated(
      request: zio.aws.apigateway.model.GetUsagePlansRequest
  ): IO[AwsError, zio.aws.apigateway.model.GetUsagePlansResponse.ReadOnly]
  def getSdk(
      request: zio.aws.apigateway.model.GetSdkRequest
  ): IO[AwsError, zio.aws.apigateway.model.GetSdkResponse.ReadOnly]
  def deleteAuthorizer(
      request: zio.aws.apigateway.model.DeleteAuthorizerRequest
  ): IO[AwsError, Unit]
  def getBasePathMapping(
      request: zio.aws.apigateway.model.GetBasePathMappingRequest
  ): IO[AwsError, zio.aws.apigateway.model.GetBasePathMappingResponse.ReadOnly]
  def deleteRequestValidator(
      request: zio.aws.apigateway.model.DeleteRequestValidatorRequest
  ): IO[AwsError, Unit]
  def getSdkTypes(
      request: zio.aws.apigateway.model.GetSdkTypesRequest
  ): IO[AwsError, zio.aws.apigateway.model.GetSdkTypesResponse.ReadOnly]
  def getUsagePlanKeys(
      request: zio.aws.apigateway.model.GetUsagePlanKeysRequest
  ): ZStream[Any, AwsError, zio.aws.apigateway.model.UsagePlanKey.ReadOnly]
  def getUsagePlanKeysPaginated(
      request: zio.aws.apigateway.model.GetUsagePlanKeysRequest
  ): IO[AwsError, zio.aws.apigateway.model.GetUsagePlanKeysResponse.ReadOnly]
  def deleteIntegrationResponse(
      request: zio.aws.apigateway.model.DeleteIntegrationResponseRequest
  ): IO[AwsError, Unit]
  def updateMethod(
      request: zio.aws.apigateway.model.UpdateMethodRequest
  ): IO[AwsError, zio.aws.apigateway.model.UpdateMethodResponse.ReadOnly]
  def updateIntegration(
      request: zio.aws.apigateway.model.UpdateIntegrationRequest
  ): IO[AwsError, zio.aws.apigateway.model.UpdateIntegrationResponse.ReadOnly]
  def importRestApi(
      request: zio.aws.apigateway.model.ImportRestApiRequest
  ): IO[AwsError, zio.aws.apigateway.model.ImportRestApiResponse.ReadOnly]
  def deleteGatewayResponse(
      request: zio.aws.apigateway.model.DeleteGatewayResponseRequest
  ): IO[AwsError, Unit]
  def updateGatewayResponse(
      request: zio.aws.apigateway.model.UpdateGatewayResponseRequest
  ): IO[
    AwsError,
    zio.aws.apigateway.model.UpdateGatewayResponseResponse.ReadOnly
  ]
  def updateDocumentationVersion(
      request: zio.aws.apigateway.model.UpdateDocumentationVersionRequest
  ): IO[
    AwsError,
    zio.aws.apigateway.model.UpdateDocumentationVersionResponse.ReadOnly
  ]
  def putGatewayResponse(
      request: zio.aws.apigateway.model.PutGatewayResponseRequest
  ): IO[AwsError, zio.aws.apigateway.model.PutGatewayResponseResponse.ReadOnly]
  def getRequestValidator(
      request: zio.aws.apigateway.model.GetRequestValidatorRequest
  ): IO[AwsError, zio.aws.apigateway.model.GetRequestValidatorResponse.ReadOnly]
  def getModels(
      request: zio.aws.apigateway.model.GetModelsRequest
  ): ZStream[Any, AwsError, zio.aws.apigateway.model.Model.ReadOnly]
  def getModelsPaginated(
      request: zio.aws.apigateway.model.GetModelsRequest
  ): IO[AwsError, zio.aws.apigateway.model.GetModelsResponse.ReadOnly]
  def getStages(
      request: zio.aws.apigateway.model.GetStagesRequest
  ): IO[AwsError, zio.aws.apigateway.model.GetStagesResponse.ReadOnly]
  def getDomainName(
      request: zio.aws.apigateway.model.GetDomainNameRequest
  ): IO[AwsError, zio.aws.apigateway.model.GetDomainNameResponse.ReadOnly]
  def getDocumentationVersions(
      request: zio.aws.apigateway.model.GetDocumentationVersionsRequest
  ): IO[
    AwsError,
    zio.aws.apigateway.model.GetDocumentationVersionsResponse.ReadOnly
  ]
  def getAuthorizer(
      request: zio.aws.apigateway.model.GetAuthorizerRequest
  ): IO[AwsError, zio.aws.apigateway.model.GetAuthorizerResponse.ReadOnly]
  def deleteDomainName(
      request: zio.aws.apigateway.model.DeleteDomainNameRequest
  ): IO[AwsError, Unit]
  def updateRequestValidator(
      request: zio.aws.apigateway.model.UpdateRequestValidatorRequest
  ): IO[
    AwsError,
    zio.aws.apigateway.model.UpdateRequestValidatorResponse.ReadOnly
  ]
  def getBasePathMappings(
      request: zio.aws.apigateway.model.GetBasePathMappingsRequest
  ): ZStream[Any, AwsError, zio.aws.apigateway.model.BasePathMapping.ReadOnly]
  def getBasePathMappingsPaginated(
      request: zio.aws.apigateway.model.GetBasePathMappingsRequest
  ): IO[AwsError, zio.aws.apigateway.model.GetBasePathMappingsResponse.ReadOnly]
  def deleteBasePathMapping(
      request: zio.aws.apigateway.model.DeleteBasePathMappingRequest
  ): IO[AwsError, Unit]
  def updateDomainName(
      request: zio.aws.apigateway.model.UpdateDomainNameRequest
  ): IO[AwsError, zio.aws.apigateway.model.UpdateDomainNameResponse.ReadOnly]
  def deleteResource(
      request: zio.aws.apigateway.model.DeleteResourceRequest
  ): IO[AwsError, Unit]
  def getTags(
      request: zio.aws.apigateway.model.GetTagsRequest
  ): IO[AwsError, zio.aws.apigateway.model.GetTagsResponse.ReadOnly]
}
object ApiGateway {
  val live: ZLayer[AwsConfig, java.lang.Throwable, ApiGateway] = customized(
    identity
  )
  def customized(
      customization: ApiGatewayAsyncClientBuilder => ApiGatewayAsyncClientBuilder
  ): ZLayer[AwsConfig, java.lang.Throwable, ApiGateway] =
    ZLayer.scoped(scoped(customization))
  def scoped(
      customization: ApiGatewayAsyncClientBuilder => ApiGatewayAsyncClientBuilder
  ): ZIO[AwsConfig with Scope, java.lang.Throwable, ApiGateway] = for (
    awsConfig <- ZIO.service[AwsConfig]; executor <- ZIO.executor;
    builder = ApiGatewayAsyncClient
      .builder()
      .asyncConfiguration(
        software.amazon.awssdk.core.client.config.ClientAsyncConfiguration
          .builder()
          .advancedOption(
            software.amazon.awssdk.core.client.config.SdkAdvancedAsyncClientOption.FUTURE_COMPLETION_EXECUTOR,
            executor.asJava
          )
          .build()
      );
    b0 <- awsConfig
      .configure[ApiGatewayAsyncClient, ApiGatewayAsyncClientBuilder](builder);
    b1 <- awsConfig
      .configureHttpClient[ApiGatewayAsyncClient, ApiGatewayAsyncClientBuilder](
        b0,
        zio.aws.core.httpclient.ServiceHttpCapabilities(supportsHttp2 = false)
      ); client <- ZIO.attempt(customization(b1).build())
  ) yield new ApiGatewayImpl(client, AwsCallAspect.identity, ZEnvironment.empty)
  private class ApiGatewayImpl[R](
      override val api: ApiGatewayAsyncClient,
      override val aspect: AwsCallAspect[R],
      r: ZEnvironment[R]
  ) extends ApiGateway
      with AwsServiceBase[R] {
    override val serviceName: String = "ApiGateway"
    override def withAspect[R1](
        newAspect: AwsCallAspect[R1],
        r: ZEnvironment[R1]
    ): ApiGatewayImpl[R1] = new ApiGatewayImpl(api, newAspect, r)
    def getResource(
        request: zio.aws.apigateway.model.GetResourceRequest
    ): IO[AwsError, zio.aws.apigateway.model.GetResourceResponse.ReadOnly] =
      asyncRequestResponse[GetResourceRequest, GetResourceResponse](
        "getResource",
        api.getResource
      )(request.buildAwsValue())
        .map(zio.aws.apigateway.model.GetResourceResponse.wrap)
        .provideEnvironment(r)
    def updateAccount(
        request: zio.aws.apigateway.model.UpdateAccountRequest
    ): IO[AwsError, zio.aws.apigateway.model.UpdateAccountResponse.ReadOnly] =
      asyncRequestResponse[UpdateAccountRequest, UpdateAccountResponse](
        "updateAccount",
        api.updateAccount
      )(request.buildAwsValue())
        .map(zio.aws.apigateway.model.UpdateAccountResponse.wrap)
        .provideEnvironment(r)
    def updateStage(
        request: zio.aws.apigateway.model.UpdateStageRequest
    ): IO[AwsError, zio.aws.apigateway.model.UpdateStageResponse.ReadOnly] =
      asyncRequestResponse[UpdateStageRequest, UpdateStageResponse](
        "updateStage",
        api.updateStage
      )(request.buildAwsValue())
        .map(zio.aws.apigateway.model.UpdateStageResponse.wrap)
        .provideEnvironment(r)
    def getVpcLinks(
        request: zio.aws.apigateway.model.GetVpcLinksRequest
    ): ZStream[Any, AwsError, zio.aws.apigateway.model.VpcLink.ReadOnly] =
      asyncJavaPaginatedRequest[
        GetVpcLinksRequest,
        VpcLink,
        GetVpcLinksPublisher
      ]("getVpcLinks", api.getVpcLinksPaginator, _.items())(
        request.buildAwsValue()
      ).map(item => zio.aws.apigateway.model.VpcLink.wrap(item))
        .provideEnvironment(r)
    def getVpcLinksPaginated(
        request: zio.aws.apigateway.model.GetVpcLinksRequest
    ): IO[AwsError, zio.aws.apigateway.model.GetVpcLinksResponse.ReadOnly] =
      asyncRequestResponse[GetVpcLinksRequest, GetVpcLinksResponse](
        "getVpcLinks",
        api.getVpcLinks
      )(request.buildAwsValue())
        .map(zio.aws.apigateway.model.GetVpcLinksResponse.wrap)
        .provideEnvironment(r)
    def createResource(
        request: zio.aws.apigateway.model.CreateResourceRequest
    ): IO[AwsError, zio.aws.apigateway.model.CreateResourceResponse.ReadOnly] =
      asyncRequestResponse[CreateResourceRequest, CreateResourceResponse](
        "createResource",
        api.createResource
      )(request.buildAwsValue())
        .map(zio.aws.apigateway.model.CreateResourceResponse.wrap)
        .provideEnvironment(r)
    def deleteDocumentationVersion(
        request: zio.aws.apigateway.model.DeleteDocumentationVersionRequest
    ): IO[AwsError, Unit] = asyncRequestResponse[
      DeleteDocumentationVersionRequest,
      DeleteDocumentationVersionResponse
    ]("deleteDocumentationVersion", api.deleteDocumentationVersion)(
      request.buildAwsValue()
    ).unit.provideEnvironment(r)
    def testInvokeAuthorizer(
        request: zio.aws.apigateway.model.TestInvokeAuthorizerRequest
    ): IO[
      AwsError,
      zio.aws.apigateway.model.TestInvokeAuthorizerResponse.ReadOnly
    ] = asyncRequestResponse[
      TestInvokeAuthorizerRequest,
      TestInvokeAuthorizerResponse
    ]("testInvokeAuthorizer", api.testInvokeAuthorizer)(request.buildAwsValue())
      .map(zio.aws.apigateway.model.TestInvokeAuthorizerResponse.wrap)
      .provideEnvironment(r)
    def getRequestValidators(
        request: zio.aws.apigateway.model.GetRequestValidatorsRequest
    ): IO[
      AwsError,
      zio.aws.apigateway.model.GetRequestValidatorsResponse.ReadOnly
    ] = asyncRequestResponse[
      GetRequestValidatorsRequest,
      GetRequestValidatorsResponse
    ]("getRequestValidators", api.getRequestValidators)(request.buildAwsValue())
      .map(zio.aws.apigateway.model.GetRequestValidatorsResponse.wrap)
      .provideEnvironment(r)
    def getDocumentationPart(
        request: zio.aws.apigateway.model.GetDocumentationPartRequest
    ): IO[
      AwsError,
      zio.aws.apigateway.model.GetDocumentationPartResponse.ReadOnly
    ] = asyncRequestResponse[
      GetDocumentationPartRequest,
      GetDocumentationPartResponse
    ]("getDocumentationPart", api.getDocumentationPart)(request.buildAwsValue())
      .map(zio.aws.apigateway.model.GetDocumentationPartResponse.wrap)
      .provideEnvironment(r)
    def updateResource(
        request: zio.aws.apigateway.model.UpdateResourceRequest
    ): IO[AwsError, zio.aws.apigateway.model.UpdateResourceResponse.ReadOnly] =
      asyncRequestResponse[UpdateResourceRequest, UpdateResourceResponse](
        "updateResource",
        api.updateResource
      )(request.buildAwsValue())
        .map(zio.aws.apigateway.model.UpdateResourceResponse.wrap)
        .provideEnvironment(r)
    def deleteRestApi(
        request: zio.aws.apigateway.model.DeleteRestApiRequest
    ): IO[AwsError, Unit] =
      asyncRequestResponse[DeleteRestApiRequest, DeleteRestApiResponse](
        "deleteRestApi",
        api.deleteRestApi
      )(request.buildAwsValue()).unit.provideEnvironment(r)
    def getMethod(
        request: zio.aws.apigateway.model.GetMethodRequest
    ): IO[AwsError, zio.aws.apigateway.model.GetMethodResponse.ReadOnly] =
      asyncRequestResponse[GetMethodRequest, GetMethodResponse](
        "getMethod",
        api.getMethod
      )(request.buildAwsValue())
        .map(zio.aws.apigateway.model.GetMethodResponse.wrap)
        .provideEnvironment(r)
    def deleteUsagePlan(
        request: zio.aws.apigateway.model.DeleteUsagePlanRequest
    ): IO[AwsError, Unit] =
      asyncRequestResponse[DeleteUsagePlanRequest, DeleteUsagePlanResponse](
        "deleteUsagePlan",
        api.deleteUsagePlan
      )(request.buildAwsValue()).unit.provideEnvironment(r)
    def getDomainNames(
        request: zio.aws.apigateway.model.GetDomainNamesRequest
    ): ZStream[Any, AwsError, zio.aws.apigateway.model.DomainName.ReadOnly] =
      asyncJavaPaginatedRequest[
        GetDomainNamesRequest,
        DomainName,
        GetDomainNamesPublisher
      ]("getDomainNames", api.getDomainNamesPaginator, _.items())(
        request.buildAwsValue()
      ).map(item => zio.aws.apigateway.model.DomainName.wrap(item))
        .provideEnvironment(r)
    def getDomainNamesPaginated(
        request: zio.aws.apigateway.model.GetDomainNamesRequest
    ): IO[AwsError, zio.aws.apigateway.model.GetDomainNamesResponse.ReadOnly] =
      asyncRequestResponse[GetDomainNamesRequest, GetDomainNamesResponse](
        "getDomainNames",
        api.getDomainNames
      )(request.buildAwsValue())
        .map(zio.aws.apigateway.model.GetDomainNamesResponse.wrap)
        .provideEnvironment(r)
    def createBasePathMapping(
        request: zio.aws.apigateway.model.CreateBasePathMappingRequest
    ): IO[
      AwsError,
      zio.aws.apigateway.model.CreateBasePathMappingResponse.ReadOnly
    ] = asyncRequestResponse[
      CreateBasePathMappingRequest,
      CreateBasePathMappingResponse
    ]("createBasePathMapping", api.createBasePathMapping)(
      request.buildAwsValue()
    ).map(zio.aws.apigateway.model.CreateBasePathMappingResponse.wrap)
      .provideEnvironment(r)
    def updateBasePathMapping(
        request: zio.aws.apigateway.model.UpdateBasePathMappingRequest
    ): IO[
      AwsError,
      zio.aws.apigateway.model.UpdateBasePathMappingResponse.ReadOnly
    ] = asyncRequestResponse[
      UpdateBasePathMappingRequest,
      UpdateBasePathMappingResponse
    ]("updateBasePathMapping", api.updateBasePathMapping)(
      request.buildAwsValue()
    ).map(zio.aws.apigateway.model.UpdateBasePathMappingResponse.wrap)
      .provideEnvironment(r)
    def createModel(
        request: zio.aws.apigateway.model.CreateModelRequest
    ): IO[AwsError, zio.aws.apigateway.model.CreateModelResponse.ReadOnly] =
      asyncRequestResponse[CreateModelRequest, CreateModelResponse](
        "createModel",
        api.createModel
      )(request.buildAwsValue())
        .map(zio.aws.apigateway.model.CreateModelResponse.wrap)
        .provideEnvironment(r)
    def getMethodResponse(
        request: zio.aws.apigateway.model.GetMethodResponseRequest
    ): IO[
      AwsError,
      zio.aws.apigateway.model.GetMethodResponseResponse.ReadOnly
    ] =
      asyncRequestResponse[GetMethodResponseRequest, GetMethodResponseResponse](
        "getMethodResponse",
        api.getMethodResponse
      )(request.buildAwsValue())
        .map(zio.aws.apigateway.model.GetMethodResponseResponse.wrap)
        .provideEnvironment(r)
    def getClientCertificates(
        request: zio.aws.apigateway.model.GetClientCertificatesRequest
    ): ZStream[
      Any,
      AwsError,
      zio.aws.apigateway.model.ClientCertificate.ReadOnly
    ] = asyncJavaPaginatedRequest[
      GetClientCertificatesRequest,
      ClientCertificate,
      GetClientCertificatesPublisher
    ]("getClientCertificates", api.getClientCertificatesPaginator, _.items())(
      request.buildAwsValue()
    ).map(item => zio.aws.apigateway.model.ClientCertificate.wrap(item))
      .provideEnvironment(r)
    def getClientCertificatesPaginated(
        request: zio.aws.apigateway.model.GetClientCertificatesRequest
    ): IO[
      AwsError,
      zio.aws.apigateway.model.GetClientCertificatesResponse.ReadOnly
    ] = asyncRequestResponse[
      GetClientCertificatesRequest,
      GetClientCertificatesResponse
    ]("getClientCertificates", api.getClientCertificates)(
      request.buildAwsValue()
    ).map(zio.aws.apigateway.model.GetClientCertificatesResponse.wrap)
      .provideEnvironment(r)
    def createUsagePlan(
        request: zio.aws.apigateway.model.CreateUsagePlanRequest
    ): IO[AwsError, zio.aws.apigateway.model.CreateUsagePlanResponse.ReadOnly] =
      asyncRequestResponse[CreateUsagePlanRequest, CreateUsagePlanResponse](
        "createUsagePlan",
        api.createUsagePlan
      )(request.buildAwsValue())
        .map(zio.aws.apigateway.model.CreateUsagePlanResponse.wrap)
        .provideEnvironment(r)
    def updateApiKey(
        request: zio.aws.apigateway.model.UpdateApiKeyRequest
    ): IO[AwsError, zio.aws.apigateway.model.UpdateApiKeyResponse.ReadOnly] =
      asyncRequestResponse[UpdateApiKeyRequest, UpdateApiKeyResponse](
        "updateApiKey",
        api.updateApiKey
      )(request.buildAwsValue())
        .map(zio.aws.apigateway.model.UpdateApiKeyResponse.wrap)
        .provideEnvironment(r)
    def updateModel(
        request: zio.aws.apigateway.model.UpdateModelRequest
    ): IO[AwsError, zio.aws.apigateway.model.UpdateModelResponse.ReadOnly] =
      asyncRequestResponse[UpdateModelRequest, UpdateModelResponse](
        "updateModel",
        api.updateModel
      )(request.buildAwsValue())
        .map(zio.aws.apigateway.model.UpdateModelResponse.wrap)
        .provideEnvironment(r)
    def createDocumentationPart(
        request: zio.aws.apigateway.model.CreateDocumentationPartRequest
    ): IO[
      AwsError,
      zio.aws.apigateway.model.CreateDocumentationPartResponse.ReadOnly
    ] = asyncRequestResponse[
      CreateDocumentationPartRequest,
      CreateDocumentationPartResponse
    ]("createDocumentationPart", api.createDocumentationPart)(
      request.buildAwsValue()
    ).map(zio.aws.apigateway.model.CreateDocumentationPartResponse.wrap)
      .provideEnvironment(r)
    def getDocumentationParts(
        request: zio.aws.apigateway.model.GetDocumentationPartsRequest
    ): IO[
      AwsError,
      zio.aws.apigateway.model.GetDocumentationPartsResponse.ReadOnly
    ] = asyncRequestResponse[
      GetDocumentationPartsRequest,
      GetDocumentationPartsResponse
    ]("getDocumentationParts", api.getDocumentationParts)(
      request.buildAwsValue()
    ).map(zio.aws.apigateway.model.GetDocumentationPartsResponse.wrap)
      .provideEnvironment(r)
    def deleteVpcLink(
        request: zio.aws.apigateway.model.DeleteVpcLinkRequest
    ): IO[AwsError, Unit] =
      asyncRequestResponse[DeleteVpcLinkRequest, DeleteVpcLinkResponse](
        "deleteVpcLink",
        api.deleteVpcLink
      )(request.buildAwsValue()).unit.provideEnvironment(r)
    def getVpcLink(
        request: zio.aws.apigateway.model.GetVpcLinkRequest
    ): IO[AwsError, zio.aws.apigateway.model.GetVpcLinkResponse.ReadOnly] =
      asyncRequestResponse[GetVpcLinkRequest, GetVpcLinkResponse](
        "getVpcLink",
        api.getVpcLink
      )(request.buildAwsValue())
        .map(zio.aws.apigateway.model.GetVpcLinkResponse.wrap)
        .provideEnvironment(r)
    def createRequestValidator(
        request: zio.aws.apigateway.model.CreateRequestValidatorRequest
    ): IO[
      AwsError,
      zio.aws.apigateway.model.CreateRequestValidatorResponse.ReadOnly
    ] = asyncRequestResponse[
      CreateRequestValidatorRequest,
      CreateRequestValidatorResponse
    ]("createRequestValidator", api.createRequestValidator)(
      request.buildAwsValue()
    ).map(zio.aws.apigateway.model.CreateRequestValidatorResponse.wrap)
      .provideEnvironment(r)
    def testInvokeMethod(
        request: zio.aws.apigateway.model.TestInvokeMethodRequest
    ): IO[
      AwsError,
      zio.aws.apigateway.model.TestInvokeMethodResponse.ReadOnly
    ] = asyncRequestResponse[TestInvokeMethodRequest, TestInvokeMethodResponse](
      "testInvokeMethod",
      api.testInvokeMethod
    )(request.buildAwsValue())
      .map(zio.aws.apigateway.model.TestInvokeMethodResponse.wrap)
      .provideEnvironment(r)
    def deleteUsagePlanKey(
        request: zio.aws.apigateway.model.DeleteUsagePlanKeyRequest
    ): IO[AwsError, Unit] = asyncRequestResponse[
      DeleteUsagePlanKeyRequest,
      DeleteUsagePlanKeyResponse
    ]("deleteUsagePlanKey", api.deleteUsagePlanKey)(
      request.buildAwsValue()
    ).unit.provideEnvironment(r)
    def putIntegrationResponse(
        request: zio.aws.apigateway.model.PutIntegrationResponseRequest
    ): IO[
      AwsError,
      zio.aws.apigateway.model.PutIntegrationResponseResponse.ReadOnly
    ] = asyncRequestResponse[
      PutIntegrationResponseRequest,
      PutIntegrationResponseResponse
    ]("putIntegrationResponse", api.putIntegrationResponse)(
      request.buildAwsValue()
    ).map(zio.aws.apigateway.model.PutIntegrationResponseResponse.wrap)
      .provideEnvironment(r)
    def getDeployment(
        request: zio.aws.apigateway.model.GetDeploymentRequest
    ): IO[AwsError, zio.aws.apigateway.model.GetDeploymentResponse.ReadOnly] =
      asyncRequestResponse[GetDeploymentRequest, GetDeploymentResponse](
        "getDeployment",
        api.getDeployment
      )(request.buildAwsValue())
        .map(zio.aws.apigateway.model.GetDeploymentResponse.wrap)
        .provideEnvironment(r)
    def deleteDeployment(
        request: zio.aws.apigateway.model.DeleteDeploymentRequest
    ): IO[AwsError, Unit] =
      asyncRequestResponse[DeleteDeploymentRequest, DeleteDeploymentResponse](
        "deleteDeployment",
        api.deleteDeployment
      )(request.buildAwsValue()).unit.provideEnvironment(r)
    def flushStageCache(
        request: zio.aws.apigateway.model.FlushStageCacheRequest
    ): IO[AwsError, Unit] =
      asyncRequestResponse[FlushStageCacheRequest, FlushStageCacheResponse](
        "flushStageCache",
        api.flushStageCache
      )(request.buildAwsValue()).unit.provideEnvironment(r)
    def getStage(
        request: zio.aws.apigateway.model.GetStageRequest
    ): IO[AwsError, zio.aws.apigateway.model.GetStageResponse.ReadOnly] =
      asyncRequestResponse[GetStageRequest, GetStageResponse](
        "getStage",
        api.getStage
      )(request.buildAwsValue())
        .map(zio.aws.apigateway.model.GetStageResponse.wrap)
        .provideEnvironment(r)
    def deleteIntegration(
        request: zio.aws.apigateway.model.DeleteIntegrationRequest
    ): IO[AwsError, Unit] =
      asyncRequestResponse[DeleteIntegrationRequest, DeleteIntegrationResponse](
        "deleteIntegration",
        api.deleteIntegration
      )(request.buildAwsValue()).unit.provideEnvironment(r)
    def updateDeployment(
        request: zio.aws.apigateway.model.UpdateDeploymentRequest
    ): IO[
      AwsError,
      zio.aws.apigateway.model.UpdateDeploymentResponse.ReadOnly
    ] = asyncRequestResponse[UpdateDeploymentRequest, UpdateDeploymentResponse](
      "updateDeployment",
      api.updateDeployment
    )(request.buildAwsValue())
      .map(zio.aws.apigateway.model.UpdateDeploymentResponse.wrap)
      .provideEnvironment(r)
    def getIntegrationResponse(
        request: zio.aws.apigateway.model.GetIntegrationResponseRequest
    ): IO[
      AwsError,
      zio.aws.apigateway.model.GetIntegrationResponseResponse.ReadOnly
    ] = asyncRequestResponse[
      GetIntegrationResponseRequest,
      GetIntegrationResponseResponse
    ]("getIntegrationResponse", api.getIntegrationResponse)(
      request.buildAwsValue()
    ).map(zio.aws.apigateway.model.GetIntegrationResponseResponse.wrap)
      .provideEnvironment(r)
    def deleteMethodResponse(
        request: zio.aws.apigateway.model.DeleteMethodResponseRequest
    ): IO[AwsError, Unit] = asyncRequestResponse[
      DeleteMethodResponseRequest,
      DeleteMethodResponseResponse
    ]("deleteMethodResponse", api.deleteMethodResponse)(
      request.buildAwsValue()
    ).unit.provideEnvironment(r)
    def getGatewayResponses(
        request: zio.aws.apigateway.model.GetGatewayResponsesRequest
    ): IO[
      AwsError,
      zio.aws.apigateway.model.GetGatewayResponsesResponse.ReadOnly
    ] = asyncRequestResponse[
      GetGatewayResponsesRequest,
      GetGatewayResponsesResponse
    ]("getGatewayResponses", api.getGatewayResponses)(request.buildAwsValue())
      .map(zio.aws.apigateway.model.GetGatewayResponsesResponse.wrap)
      .provideEnvironment(r)
    def getAccount(
        request: zio.aws.apigateway.model.GetAccountRequest
    ): IO[AwsError, zio.aws.apigateway.model.GetAccountResponse.ReadOnly] =
      asyncRequestResponse[GetAccountRequest, GetAccountResponse](
        "getAccount",
        api.getAccount
      )(request.buildAwsValue())
        .map(zio.aws.apigateway.model.GetAccountResponse.wrap)
        .provideEnvironment(r)
    def updateVpcLink(
        request: zio.aws.apigateway.model.UpdateVpcLinkRequest
    ): IO[AwsError, zio.aws.apigateway.model.UpdateVpcLinkResponse.ReadOnly] =
      asyncRequestResponse[UpdateVpcLinkRequest, UpdateVpcLinkResponse](
        "updateVpcLink",
        api.updateVpcLink
      )(request.buildAwsValue())
        .map(zio.aws.apigateway.model.UpdateVpcLinkResponse.wrap)
        .provideEnvironment(r)
    def getUsage(
        request: zio.aws.apigateway.model.GetUsageRequest
    ): IO[AwsError, zio.aws.apigateway.model.GetUsageResponse.ReadOnly] =
      asyncRequestResponse[GetUsageRequest, GetUsageResponse](
        "getUsage",
        api.getUsage
      )(request.buildAwsValue())
        .map(zio.aws.apigateway.model.GetUsageResponse.wrap)
        .provideEnvironment(r)
    def getSdkType(
        request: zio.aws.apigateway.model.GetSdkTypeRequest
    ): IO[AwsError, zio.aws.apigateway.model.GetSdkTypeResponse.ReadOnly] =
      asyncRequestResponse[GetSdkTypeRequest, GetSdkTypeResponse](
        "getSdkType",
        api.getSdkType
      )(request.buildAwsValue())
        .map(zio.aws.apigateway.model.GetSdkTypeResponse.wrap)
        .provideEnvironment(r)
    def getExport(
        request: zio.aws.apigateway.model.GetExportRequest
    ): IO[AwsError, zio.aws.apigateway.model.GetExportResponse.ReadOnly] =
      asyncRequestResponse[GetExportRequest, GetExportResponse](
        "getExport",
        api.getExport
      )(request.buildAwsValue())
        .map(zio.aws.apigateway.model.GetExportResponse.wrap)
        .provideEnvironment(r)
    def getModel(
        request: zio.aws.apigateway.model.GetModelRequest
    ): IO[AwsError, zio.aws.apigateway.model.GetModelResponse.ReadOnly] =
      asyncRequestResponse[GetModelRequest, GetModelResponse](
        "getModel",
        api.getModel
      )(request.buildAwsValue())
        .map(zio.aws.apigateway.model.GetModelResponse.wrap)
        .provideEnvironment(r)
    def createRestApi(
        request: zio.aws.apigateway.model.CreateRestApiRequest
    ): IO[AwsError, zio.aws.apigateway.model.CreateRestApiResponse.ReadOnly] =
      asyncRequestResponse[CreateRestApiRequest, CreateRestApiResponse](
        "createRestApi",
        api.createRestApi
      )(request.buildAwsValue())
        .map(zio.aws.apigateway.model.CreateRestApiResponse.wrap)
        .provideEnvironment(r)
    def deleteDocumentationPart(
        request: zio.aws.apigateway.model.DeleteDocumentationPartRequest
    ): IO[AwsError, Unit] = asyncRequestResponse[
      DeleteDocumentationPartRequest,
      DeleteDocumentationPartResponse
    ]("deleteDocumentationPart", api.deleteDocumentationPart)(
      request.buildAwsValue()
    ).unit.provideEnvironment(r)
    def updateAuthorizer(
        request: zio.aws.apigateway.model.UpdateAuthorizerRequest
    ): IO[
      AwsError,
      zio.aws.apigateway.model.UpdateAuthorizerResponse.ReadOnly
    ] = asyncRequestResponse[UpdateAuthorizerRequest, UpdateAuthorizerResponse](
      "updateAuthorizer",
      api.updateAuthorizer
    )(request.buildAwsValue())
      .map(zio.aws.apigateway.model.UpdateAuthorizerResponse.wrap)
      .provideEnvironment(r)
    def putMethodResponse(
        request: zio.aws.apigateway.model.PutMethodResponseRequest
    ): IO[
      AwsError,
      zio.aws.apigateway.model.PutMethodResponseResponse.ReadOnly
    ] =
      asyncRequestResponse[PutMethodResponseRequest, PutMethodResponseResponse](
        "putMethodResponse",
        api.putMethodResponse
      )(request.buildAwsValue())
        .map(zio.aws.apigateway.model.PutMethodResponseResponse.wrap)
        .provideEnvironment(r)
    def createDocumentationVersion(
        request: zio.aws.apigateway.model.CreateDocumentationVersionRequest
    ): IO[
      AwsError,
      zio.aws.apigateway.model.CreateDocumentationVersionResponse.ReadOnly
    ] = asyncRequestResponse[
      CreateDocumentationVersionRequest,
      CreateDocumentationVersionResponse
    ]("createDocumentationVersion", api.createDocumentationVersion)(
      request.buildAwsValue()
    ).map(zio.aws.apigateway.model.CreateDocumentationVersionResponse.wrap)
      .provideEnvironment(r)
    def deleteStage(
        request: zio.aws.apigateway.model.DeleteStageRequest
    ): IO[AwsError, Unit] =
      asyncRequestResponse[DeleteStageRequest, DeleteStageResponse](
        "deleteStage",
        api.deleteStage
      )(request.buildAwsValue()).unit.provideEnvironment(r)
    def flushStageAuthorizersCache(
        request: zio.aws.apigateway.model.FlushStageAuthorizersCacheRequest
    ): IO[AwsError, Unit] = asyncRequestResponse[
      FlushStageAuthorizersCacheRequest,
      FlushStageAuthorizersCacheResponse
    ]("flushStageAuthorizersCache", api.flushStageAuthorizersCache)(
      request.buildAwsValue()
    ).unit.provideEnvironment(r)
    def getApiKeys(
        request: zio.aws.apigateway.model.GetApiKeysRequest
    ): ZStream[Any, AwsError, ReadOnly] =
      asyncJavaPaginatedRequest[GetApiKeysRequest, ApiKey, GetApiKeysPublisher](
        "getApiKeys",
        api.getApiKeysPaginator,
        _.items()
      )(request.buildAwsValue())
        .map(item => zio.aws.apigateway.model.ApiKey.wrap(item))
        .provideEnvironment(r)
    def getApiKeysPaginated(
        request: zio.aws.apigateway.model.GetApiKeysRequest
    ): IO[AwsError, zio.aws.apigateway.model.GetApiKeysResponse.ReadOnly] =
      asyncRequestResponse[GetApiKeysRequest, GetApiKeysResponse](
        "getApiKeys",
        api.getApiKeys
      )(request.buildAwsValue())
        .map(zio.aws.apigateway.model.GetApiKeysResponse.wrap)
        .provideEnvironment(r)
    def updateUsage(
        request: zio.aws.apigateway.model.UpdateUsageRequest
    ): IO[AwsError, zio.aws.apigateway.model.UpdateUsageResponse.ReadOnly] =
      asyncRequestResponse[UpdateUsageRequest, UpdateUsageResponse](
        "updateUsage",
        api.updateUsage
      )(request.buildAwsValue())
        .map(zio.aws.apigateway.model.UpdateUsageResponse.wrap)
        .provideEnvironment(r)
    def deleteModel(
        request: zio.aws.apigateway.model.DeleteModelRequest
    ): IO[AwsError, Unit] =
      asyncRequestResponse[DeleteModelRequest, DeleteModelResponse](
        "deleteModel",
        api.deleteModel
      )(request.buildAwsValue()).unit.provideEnvironment(r)
    def deleteMethod(
        request: zio.aws.apigateway.model.DeleteMethodRequest
    ): IO[AwsError, Unit] =
      asyncRequestResponse[DeleteMethodRequest, DeleteMethodResponse](
        "deleteMethod",
        api.deleteMethod
      )(request.buildAwsValue()).unit.provideEnvironment(r)
    def getClientCertificate(
        request: zio.aws.apigateway.model.GetClientCertificateRequest
    ): IO[
      AwsError,
      zio.aws.apigateway.model.GetClientCertificateResponse.ReadOnly
    ] = asyncRequestResponse[
      GetClientCertificateRequest,
      GetClientCertificateResponse
    ]("getClientCertificate", api.getClientCertificate)(request.buildAwsValue())
      .map(zio.aws.apigateway.model.GetClientCertificateResponse.wrap)
      .provideEnvironment(r)
    def getRestApis(
        request: zio.aws.apigateway.model.GetRestApisRequest
    ): ZStream[Any, AwsError, zio.aws.apigateway.model.RestApi.ReadOnly] =
      asyncJavaPaginatedRequest[
        GetRestApisRequest,
        RestApi,
        GetRestApisPublisher
      ]("getRestApis", api.getRestApisPaginator, _.items())(
        request.buildAwsValue()
      ).map(item => zio.aws.apigateway.model.RestApi.wrap(item))
        .provideEnvironment(r)
    def getRestApisPaginated(
        request: zio.aws.apigateway.model.GetRestApisRequest
    ): IO[AwsError, zio.aws.apigateway.model.GetRestApisResponse.ReadOnly] =
      asyncRequestResponse[GetRestApisRequest, GetRestApisResponse](
        "getRestApis",
        api.getRestApis
      )(request.buildAwsValue())
        .map(zio.aws.apigateway.model.GetRestApisResponse.wrap)
        .provideEnvironment(r)
    def createDomainName(
        request: zio.aws.apigateway.model.CreateDomainNameRequest
    ): IO[
      AwsError,
      zio.aws.apigateway.model.CreateDomainNameResponse.ReadOnly
    ] = asyncRequestResponse[CreateDomainNameRequest, CreateDomainNameResponse](
      "createDomainName",
      api.createDomainName
    )(request.buildAwsValue())
      .map(zio.aws.apigateway.model.CreateDomainNameResponse.wrap)
      .provideEnvironment(r)
    def getResources(
        request: zio.aws.apigateway.model.GetResourcesRequest
    ): ZStream[Any, AwsError, zio.aws.apigateway.model.Resource.ReadOnly] =
      asyncJavaPaginatedRequest[
        GetResourcesRequest,
        Resource,
        GetResourcesPublisher
      ]("getResources", api.getResourcesPaginator, _.items())(
        request.buildAwsValue()
      ).map(item => zio.aws.apigateway.model.Resource.wrap(item))
        .provideEnvironment(r)
    def getResourcesPaginated(
        request: zio.aws.apigateway.model.GetResourcesRequest
    ): IO[AwsError, zio.aws.apigateway.model.GetResourcesResponse.ReadOnly] =
      asyncRequestResponse[GetResourcesRequest, GetResourcesResponse](
        "getResources",
        api.getResources
      )(request.buildAwsValue())
        .map(zio.aws.apigateway.model.GetResourcesResponse.wrap)
        .provideEnvironment(r)
    def getDocumentationVersion(
        request: zio.aws.apigateway.model.GetDocumentationVersionRequest
    ): IO[
      AwsError,
      zio.aws.apigateway.model.GetDocumentationVersionResponse.ReadOnly
    ] = asyncRequestResponse[
      GetDocumentationVersionRequest,
      GetDocumentationVersionResponse
    ]("getDocumentationVersion", api.getDocumentationVersion)(
      request.buildAwsValue()
    ).map(zio.aws.apigateway.model.GetDocumentationVersionResponse.wrap)
      .provideEnvironment(r)
    def updateClientCertificate(
        request: zio.aws.apigateway.model.UpdateClientCertificateRequest
    ): IO[
      AwsError,
      zio.aws.apigateway.model.UpdateClientCertificateResponse.ReadOnly
    ] = asyncRequestResponse[
      UpdateClientCertificateRequest,
      UpdateClientCertificateResponse
    ]("updateClientCertificate", api.updateClientCertificate)(
      request.buildAwsValue()
    ).map(zio.aws.apigateway.model.UpdateClientCertificateResponse.wrap)
      .provideEnvironment(r)
    def importApiKeys(
        request: zio.aws.apigateway.model.ImportApiKeysRequest
    ): IO[AwsError, zio.aws.apigateway.model.ImportApiKeysResponse.ReadOnly] =
      asyncRequestResponse[ImportApiKeysRequest, ImportApiKeysResponse](
        "importApiKeys",
        api.importApiKeys
      )(request.buildAwsValue())
        .map(zio.aws.apigateway.model.ImportApiKeysResponse.wrap)
        .provideEnvironment(r)
    def createVpcLink(
        request: zio.aws.apigateway.model.CreateVpcLinkRequest
    ): IO[AwsError, zio.aws.apigateway.model.CreateVpcLinkResponse.ReadOnly] =
      asyncRequestResponse[CreateVpcLinkRequest, CreateVpcLinkResponse](
        "createVpcLink",
        api.createVpcLink
      )(request.buildAwsValue())
        .map(zio.aws.apigateway.model.CreateVpcLinkResponse.wrap)
        .provideEnvironment(r)
    def getApiKey(
        request: zio.aws.apigateway.model.GetApiKeyRequest
    ): IO[AwsError, zio.aws.apigateway.model.GetApiKeyResponse.ReadOnly] =
      asyncRequestResponse[GetApiKeyRequest, GetApiKeyResponse](
        "getApiKey",
        api.getApiKey
      )(request.buildAwsValue())
        .map(zio.aws.apigateway.model.GetApiKeyResponse.wrap)
        .provideEnvironment(r)
    def deleteClientCertificate(
        request: zio.aws.apigateway.model.DeleteClientCertificateRequest
    ): IO[AwsError, Unit] = asyncRequestResponse[
      DeleteClientCertificateRequest,
      DeleteClientCertificateResponse
    ]("deleteClientCertificate", api.deleteClientCertificate)(
      request.buildAwsValue()
    ).unit.provideEnvironment(r)
    def updateRestApi(
        request: zio.aws.apigateway.model.UpdateRestApiRequest
    ): IO[AwsError, zio.aws.apigateway.model.UpdateRestApiResponse.ReadOnly] =
      asyncRequestResponse[UpdateRestApiRequest, UpdateRestApiResponse](
        "updateRestApi",
        api.updateRestApi
      )(request.buildAwsValue())
        .map(zio.aws.apigateway.model.UpdateRestApiResponse.wrap)
        .provideEnvironment(r)
    def untagResource(
        request: zio.aws.apigateway.model.UntagResourceRequest
    ): IO[AwsError, Unit] =
      asyncRequestResponse[UntagResourceRequest, UntagResourceResponse](
        "untagResource",
        api.untagResource
      )(request.buildAwsValue()).unit.provideEnvironment(r)
    def getAuthorizers(
        request: zio.aws.apigateway.model.GetAuthorizersRequest
    ): IO[AwsError, zio.aws.apigateway.model.GetAuthorizersResponse.ReadOnly] =
      asyncRequestResponse[GetAuthorizersRequest, GetAuthorizersResponse](
        "getAuthorizers",
        api.getAuthorizers
      )(request.buildAwsValue())
        .map(zio.aws.apigateway.model.GetAuthorizersResponse.wrap)
        .provideEnvironment(r)
    def updateIntegrationResponse(
        request: zio.aws.apigateway.model.UpdateIntegrationResponseRequest
    ): IO[
      AwsError,
      zio.aws.apigateway.model.UpdateIntegrationResponseResponse.ReadOnly
    ] = asyncRequestResponse[
      UpdateIntegrationResponseRequest,
      UpdateIntegrationResponseResponse
    ]("updateIntegrationResponse", api.updateIntegrationResponse)(
      request.buildAwsValue()
    ).map(zio.aws.apigateway.model.UpdateIntegrationResponseResponse.wrap)
      .provideEnvironment(r)
    def deleteApiKey(
        request: zio.aws.apigateway.model.DeleteApiKeyRequest
    ): IO[AwsError, Unit] =
      asyncRequestResponse[DeleteApiKeyRequest, DeleteApiKeyResponse](
        "deleteApiKey",
        api.deleteApiKey
      )(request.buildAwsValue()).unit.provideEnvironment(r)
    def createDeployment(
        request: zio.aws.apigateway.model.CreateDeploymentRequest
    ): IO[
      AwsError,
      zio.aws.apigateway.model.CreateDeploymentResponse.ReadOnly
    ] = asyncRequestResponse[CreateDeploymentRequest, CreateDeploymentResponse](
      "createDeployment",
      api.createDeployment
    )(request.buildAwsValue())
      .map(zio.aws.apigateway.model.CreateDeploymentResponse.wrap)
      .provideEnvironment(r)
    def updateDocumentationPart(
        request: zio.aws.apigateway.model.UpdateDocumentationPartRequest
    ): IO[
      AwsError,
      zio.aws.apigateway.model.UpdateDocumentationPartResponse.ReadOnly
    ] = asyncRequestResponse[
      UpdateDocumentationPartRequest,
      UpdateDocumentationPartResponse
    ]("updateDocumentationPart", api.updateDocumentationPart)(
      request.buildAwsValue()
    ).map(zio.aws.apigateway.model.UpdateDocumentationPartResponse.wrap)
      .provideEnvironment(r)
    def createApiKey(
        request: zio.aws.apigateway.model.CreateApiKeyRequest
    ): IO[AwsError, zio.aws.apigateway.model.CreateApiKeyResponse.ReadOnly] =
      asyncRequestResponse[CreateApiKeyRequest, CreateApiKeyResponse](
        "createApiKey",
        api.createApiKey
      )(request.buildAwsValue())
        .map(zio.aws.apigateway.model.CreateApiKeyResponse.wrap)
        .provideEnvironment(r)
    def putIntegration(
        request: zio.aws.apigateway.model.PutIntegrationRequest
    ): IO[AwsError, zio.aws.apigateway.model.PutIntegrationResponse.ReadOnly] =
      asyncRequestResponse[PutIntegrationRequest, PutIntegrationResponse](
        "putIntegration",
        api.putIntegration
      )(request.buildAwsValue())
        .map(zio.aws.apigateway.model.PutIntegrationResponse.wrap)
        .provideEnvironment(r)
    def importDocumentationParts(
        request: zio.aws.apigateway.model.ImportDocumentationPartsRequest
    ): IO[
      AwsError,
      zio.aws.apigateway.model.ImportDocumentationPartsResponse.ReadOnly
    ] = asyncRequestResponse[
      ImportDocumentationPartsRequest,
      ImportDocumentationPartsResponse
    ]("importDocumentationParts", api.importDocumentationParts)(
      request.buildAwsValue()
    ).map(zio.aws.apigateway.model.ImportDocumentationPartsResponse.wrap)
      .provideEnvironment(r)
    def getModelTemplate(
        request: zio.aws.apigateway.model.GetModelTemplateRequest
    ): IO[
      AwsError,
      zio.aws.apigateway.model.GetModelTemplateResponse.ReadOnly
    ] = asyncRequestResponse[GetModelTemplateRequest, GetModelTemplateResponse](
      "getModelTemplate",
      api.getModelTemplate
    )(request.buildAwsValue())
      .map(zio.aws.apigateway.model.GetModelTemplateResponse.wrap)
      .provideEnvironment(r)
    def createStage(
        request: zio.aws.apigateway.model.CreateStageRequest
    ): IO[AwsError, zio.aws.apigateway.model.CreateStageResponse.ReadOnly] =
      asyncRequestResponse[CreateStageRequest, CreateStageResponse](
        "createStage",
        api.createStage
      )(request.buildAwsValue())
        .map(zio.aws.apigateway.model.CreateStageResponse.wrap)
        .provideEnvironment(r)
    def getUsagePlanKey(
        request: zio.aws.apigateway.model.GetUsagePlanKeyRequest
    ): IO[AwsError, zio.aws.apigateway.model.GetUsagePlanKeyResponse.ReadOnly] =
      asyncRequestResponse[GetUsagePlanKeyRequest, GetUsagePlanKeyResponse](
        "getUsagePlanKey",
        api.getUsagePlanKey
      )(request.buildAwsValue())
        .map(zio.aws.apigateway.model.GetUsagePlanKeyResponse.wrap)
        .provideEnvironment(r)
    def updateMethodResponse(
        request: zio.aws.apigateway.model.UpdateMethodResponseRequest
    ): IO[
      AwsError,
      zio.aws.apigateway.model.UpdateMethodResponseResponse.ReadOnly
    ] = asyncRequestResponse[
      UpdateMethodResponseRequest,
      UpdateMethodResponseResponse
    ]("updateMethodResponse", api.updateMethodResponse)(request.buildAwsValue())
      .map(zio.aws.apigateway.model.UpdateMethodResponseResponse.wrap)
      .provideEnvironment(r)
    def getRestApi(
        request: zio.aws.apigateway.model.GetRestApiRequest
    ): IO[AwsError, zio.aws.apigateway.model.GetRestApiResponse.ReadOnly] =
      asyncRequestResponse[GetRestApiRequest, GetRestApiResponse](
        "getRestApi",
        api.getRestApi
      )(request.buildAwsValue())
        .map(zio.aws.apigateway.model.GetRestApiResponse.wrap)
        .provideEnvironment(r)
    def createAuthorizer(
        request: zio.aws.apigateway.model.CreateAuthorizerRequest
    ): IO[
      AwsError,
      zio.aws.apigateway.model.CreateAuthorizerResponse.ReadOnly
    ] = asyncRequestResponse[CreateAuthorizerRequest, CreateAuthorizerResponse](
      "createAuthorizer",
      api.createAuthorizer
    )(request.buildAwsValue())
      .map(zio.aws.apigateway.model.CreateAuthorizerResponse.wrap)
      .provideEnvironment(r)
    def putMethod(
        request: zio.aws.apigateway.model.PutMethodRequest
    ): IO[AwsError, zio.aws.apigateway.model.PutMethodResponse.ReadOnly] =
      asyncRequestResponse[PutMethodRequest, PutMethodResponse](
        "putMethod",
        api.putMethod
      )(request.buildAwsValue())
        .map(zio.aws.apigateway.model.PutMethodResponse.wrap)
        .provideEnvironment(r)
    def getGatewayResponse(
        request: zio.aws.apigateway.model.GetGatewayResponseRequest
    ): IO[
      AwsError,
      zio.aws.apigateway.model.GetGatewayResponseResponse.ReadOnly
    ] = asyncRequestResponse[
      GetGatewayResponseRequest,
      GetGatewayResponseResponse
    ]("getGatewayResponse", api.getGatewayResponse)(request.buildAwsValue())
      .map(zio.aws.apigateway.model.GetGatewayResponseResponse.wrap)
      .provideEnvironment(r)
    def generateClientCertificate(
        request: zio.aws.apigateway.model.GenerateClientCertificateRequest
    ): IO[
      AwsError,
      zio.aws.apigateway.model.GenerateClientCertificateResponse.ReadOnly
    ] = asyncRequestResponse[
      GenerateClientCertificateRequest,
      GenerateClientCertificateResponse
    ]("generateClientCertificate", api.generateClientCertificate)(
      request.buildAwsValue()
    ).map(zio.aws.apigateway.model.GenerateClientCertificateResponse.wrap)
      .provideEnvironment(r)
    def tagResource(
        request: zio.aws.apigateway.model.TagResourceRequest
    ): IO[AwsError, Unit] =
      asyncRequestResponse[TagResourceRequest, TagResourceResponse](
        "tagResource",
        api.tagResource
      )(request.buildAwsValue()).unit.provideEnvironment(r)
    def getUsagePlan(
        request: zio.aws.apigateway.model.GetUsagePlanRequest
    ): IO[AwsError, zio.aws.apigateway.model.GetUsagePlanResponse.ReadOnly] =
      asyncRequestResponse[GetUsagePlanRequest, GetUsagePlanResponse](
        "getUsagePlan",
        api.getUsagePlan
      )(request.buildAwsValue())
        .map(zio.aws.apigateway.model.GetUsagePlanResponse.wrap)
        .provideEnvironment(r)
    def createUsagePlanKey(
        request: zio.aws.apigateway.model.CreateUsagePlanKeyRequest
    ): IO[
      AwsError,
      zio.aws.apigateway.model.CreateUsagePlanKeyResponse.ReadOnly
    ] = asyncRequestResponse[
      CreateUsagePlanKeyRequest,
      CreateUsagePlanKeyResponse
    ]("createUsagePlanKey", api.createUsagePlanKey)(request.buildAwsValue())
      .map(zio.aws.apigateway.model.CreateUsagePlanKeyResponse.wrap)
      .provideEnvironment(r)
    def updateUsagePlan(
        request: zio.aws.apigateway.model.UpdateUsagePlanRequest
    ): IO[AwsError, zio.aws.apigateway.model.UpdateUsagePlanResponse.ReadOnly] =
      asyncRequestResponse[UpdateUsagePlanRequest, UpdateUsagePlanResponse](
        "updateUsagePlan",
        api.updateUsagePlan
      )(request.buildAwsValue())
        .map(zio.aws.apigateway.model.UpdateUsagePlanResponse.wrap)
        .provideEnvironment(r)
    def getIntegration(
        request: zio.aws.apigateway.model.GetIntegrationRequest
    ): IO[AwsError, zio.aws.apigateway.model.GetIntegrationResponse.ReadOnly] =
      asyncRequestResponse[GetIntegrationRequest, GetIntegrationResponse](
        "getIntegration",
        api.getIntegration
      )(request.buildAwsValue())
        .map(zio.aws.apigateway.model.GetIntegrationResponse.wrap)
        .provideEnvironment(r)
    def getDeployments(
        request: zio.aws.apigateway.model.GetDeploymentsRequest
    ): ZStream[Any, AwsError, zio.aws.apigateway.model.Deployment.ReadOnly] =
      asyncJavaPaginatedRequest[
        GetDeploymentsRequest,
        Deployment,
        GetDeploymentsPublisher
      ]("getDeployments", api.getDeploymentsPaginator, _.items())(
        request.buildAwsValue()
      ).map(item => zio.aws.apigateway.model.Deployment.wrap(item))
        .provideEnvironment(r)
    def getDeploymentsPaginated(
        request: zio.aws.apigateway.model.GetDeploymentsRequest
    ): IO[AwsError, zio.aws.apigateway.model.GetDeploymentsResponse.ReadOnly] =
      asyncRequestResponse[GetDeploymentsRequest, GetDeploymentsResponse](
        "getDeployments",
        api.getDeployments
      )(request.buildAwsValue())
        .map(zio.aws.apigateway.model.GetDeploymentsResponse.wrap)
        .provideEnvironment(r)
    def putRestApi(
        request: zio.aws.apigateway.model.PutRestApiRequest
    ): IO[AwsError, zio.aws.apigateway.model.PutRestApiResponse.ReadOnly] =
      asyncRequestResponse[PutRestApiRequest, PutRestApiResponse](
        "putRestApi",
        api.putRestApi
      )(request.buildAwsValue())
        .map(zio.aws.apigateway.model.PutRestApiResponse.wrap)
        .provideEnvironment(r)
    def getUsagePlans(
        request: zio.aws.apigateway.model.GetUsagePlansRequest
    ): ZStream[Any, AwsError, zio.aws.apigateway.model.UsagePlan.ReadOnly] =
      asyncJavaPaginatedRequest[
        GetUsagePlansRequest,
        UsagePlan,
        GetUsagePlansPublisher
      ]("getUsagePlans", api.getUsagePlansPaginator, _.items())(
        request.buildAwsValue()
      ).map(item => zio.aws.apigateway.model.UsagePlan.wrap(item))
        .provideEnvironment(r)
    def getUsagePlansPaginated(
        request: zio.aws.apigateway.model.GetUsagePlansRequest
    ): IO[AwsError, zio.aws.apigateway.model.GetUsagePlansResponse.ReadOnly] =
      asyncRequestResponse[GetUsagePlansRequest, GetUsagePlansResponse](
        "getUsagePlans",
        api.getUsagePlans
      )(request.buildAwsValue())
        .map(zio.aws.apigateway.model.GetUsagePlansResponse.wrap)
        .provideEnvironment(r)
    def getSdk(
        request: zio.aws.apigateway.model.GetSdkRequest
    ): IO[AwsError, zio.aws.apigateway.model.GetSdkResponse.ReadOnly] =
      asyncRequestResponse[GetSdkRequest, GetSdkResponse]("getSdk", api.getSdk)(
        request.buildAwsValue()
      ).map(zio.aws.apigateway.model.GetSdkResponse.wrap).provideEnvironment(r)
    def deleteAuthorizer(
        request: zio.aws.apigateway.model.DeleteAuthorizerRequest
    ): IO[AwsError, Unit] =
      asyncRequestResponse[DeleteAuthorizerRequest, DeleteAuthorizerResponse](
        "deleteAuthorizer",
        api.deleteAuthorizer
      )(request.buildAwsValue()).unit.provideEnvironment(r)
    def getBasePathMapping(
        request: zio.aws.apigateway.model.GetBasePathMappingRequest
    ): IO[
      AwsError,
      zio.aws.apigateway.model.GetBasePathMappingResponse.ReadOnly
    ] = asyncRequestResponse[
      GetBasePathMappingRequest,
      GetBasePathMappingResponse
    ]("getBasePathMapping", api.getBasePathMapping)(request.buildAwsValue())
      .map(zio.aws.apigateway.model.GetBasePathMappingResponse.wrap)
      .provideEnvironment(r)
    def deleteRequestValidator(
        request: zio.aws.apigateway.model.DeleteRequestValidatorRequest
    ): IO[AwsError, Unit] = asyncRequestResponse[
      DeleteRequestValidatorRequest,
      DeleteRequestValidatorResponse
    ]("deleteRequestValidator", api.deleteRequestValidator)(
      request.buildAwsValue()
    ).unit.provideEnvironment(r)
    def getSdkTypes(
        request: zio.aws.apigateway.model.GetSdkTypesRequest
    ): IO[AwsError, zio.aws.apigateway.model.GetSdkTypesResponse.ReadOnly] =
      asyncRequestResponse[GetSdkTypesRequest, GetSdkTypesResponse](
        "getSdkTypes",
        api.getSdkTypes
      )(request.buildAwsValue())
        .map(zio.aws.apigateway.model.GetSdkTypesResponse.wrap)
        .provideEnvironment(r)
    def getUsagePlanKeys(
        request: zio.aws.apigateway.model.GetUsagePlanKeysRequest
    ): ZStream[Any, AwsError, zio.aws.apigateway.model.UsagePlanKey.ReadOnly] =
      asyncJavaPaginatedRequest[
        GetUsagePlanKeysRequest,
        UsagePlanKey,
        GetUsagePlanKeysPublisher
      ]("getUsagePlanKeys", api.getUsagePlanKeysPaginator, _.items())(
        request.buildAwsValue()
      ).map(item => zio.aws.apigateway.model.UsagePlanKey.wrap(item))
        .provideEnvironment(r)
    def getUsagePlanKeysPaginated(
        request: zio.aws.apigateway.model.GetUsagePlanKeysRequest
    ): IO[
      AwsError,
      zio.aws.apigateway.model.GetUsagePlanKeysResponse.ReadOnly
    ] = asyncRequestResponse[GetUsagePlanKeysRequest, GetUsagePlanKeysResponse](
      "getUsagePlanKeys",
      api.getUsagePlanKeys
    )(request.buildAwsValue())
      .map(zio.aws.apigateway.model.GetUsagePlanKeysResponse.wrap)
      .provideEnvironment(r)
    def deleteIntegrationResponse(
        request: zio.aws.apigateway.model.DeleteIntegrationResponseRequest
    ): IO[AwsError, Unit] = asyncRequestResponse[
      DeleteIntegrationResponseRequest,
      DeleteIntegrationResponseResponse
    ]("deleteIntegrationResponse", api.deleteIntegrationResponse)(
      request.buildAwsValue()
    ).unit.provideEnvironment(r)
    def updateMethod(
        request: zio.aws.apigateway.model.UpdateMethodRequest
    ): IO[AwsError, zio.aws.apigateway.model.UpdateMethodResponse.ReadOnly] =
      asyncRequestResponse[UpdateMethodRequest, UpdateMethodResponse](
        "updateMethod",
        api.updateMethod
      )(request.buildAwsValue())
        .map(zio.aws.apigateway.model.UpdateMethodResponse.wrap)
        .provideEnvironment(r)
    def updateIntegration(
        request: zio.aws.apigateway.model.UpdateIntegrationRequest
    ): IO[
      AwsError,
      zio.aws.apigateway.model.UpdateIntegrationResponse.ReadOnly
    ] =
      asyncRequestResponse[UpdateIntegrationRequest, UpdateIntegrationResponse](
        "updateIntegration",
        api.updateIntegration
      )(request.buildAwsValue())
        .map(zio.aws.apigateway.model.UpdateIntegrationResponse.wrap)
        .provideEnvironment(r)
    def importRestApi(
        request: zio.aws.apigateway.model.ImportRestApiRequest
    ): IO[AwsError, zio.aws.apigateway.model.ImportRestApiResponse.ReadOnly] =
      asyncRequestResponse[ImportRestApiRequest, ImportRestApiResponse](
        "importRestApi",
        api.importRestApi
      )(request.buildAwsValue())
        .map(zio.aws.apigateway.model.ImportRestApiResponse.wrap)
        .provideEnvironment(r)
    def deleteGatewayResponse(
        request: zio.aws.apigateway.model.DeleteGatewayResponseRequest
    ): IO[AwsError, Unit] = asyncRequestResponse[
      DeleteGatewayResponseRequest,
      DeleteGatewayResponseResponse
    ]("deleteGatewayResponse", api.deleteGatewayResponse)(
      request.buildAwsValue()
    ).unit.provideEnvironment(r)
    def updateGatewayResponse(
        request: zio.aws.apigateway.model.UpdateGatewayResponseRequest
    ): IO[
      AwsError,
      zio.aws.apigateway.model.UpdateGatewayResponseResponse.ReadOnly
    ] = asyncRequestResponse[
      UpdateGatewayResponseRequest,
      UpdateGatewayResponseResponse
    ]("updateGatewayResponse", api.updateGatewayResponse)(
      request.buildAwsValue()
    ).map(zio.aws.apigateway.model.UpdateGatewayResponseResponse.wrap)
      .provideEnvironment(r)
    def updateDocumentationVersion(
        request: zio.aws.apigateway.model.UpdateDocumentationVersionRequest
    ): IO[
      AwsError,
      zio.aws.apigateway.model.UpdateDocumentationVersionResponse.ReadOnly
    ] = asyncRequestResponse[
      UpdateDocumentationVersionRequest,
      UpdateDocumentationVersionResponse
    ]("updateDocumentationVersion", api.updateDocumentationVersion)(
      request.buildAwsValue()
    ).map(zio.aws.apigateway.model.UpdateDocumentationVersionResponse.wrap)
      .provideEnvironment(r)
    def putGatewayResponse(
        request: zio.aws.apigateway.model.PutGatewayResponseRequest
    ): IO[
      AwsError,
      zio.aws.apigateway.model.PutGatewayResponseResponse.ReadOnly
    ] = asyncRequestResponse[
      PutGatewayResponseRequest,
      PutGatewayResponseResponse
    ]("putGatewayResponse", api.putGatewayResponse)(request.buildAwsValue())
      .map(zio.aws.apigateway.model.PutGatewayResponseResponse.wrap)
      .provideEnvironment(r)
    def getRequestValidator(
        request: zio.aws.apigateway.model.GetRequestValidatorRequest
    ): IO[
      AwsError,
      zio.aws.apigateway.model.GetRequestValidatorResponse.ReadOnly
    ] = asyncRequestResponse[
      GetRequestValidatorRequest,
      GetRequestValidatorResponse
    ]("getRequestValidator", api.getRequestValidator)(request.buildAwsValue())
      .map(zio.aws.apigateway.model.GetRequestValidatorResponse.wrap)
      .provideEnvironment(r)
    def getModels(
        request: zio.aws.apigateway.model.GetModelsRequest
    ): ZStream[Any, AwsError, zio.aws.apigateway.model.Model.ReadOnly] =
      asyncJavaPaginatedRequest[GetModelsRequest, Model, GetModelsPublisher](
        "getModels",
        api.getModelsPaginator,
        _.items()
      )(request.buildAwsValue())
        .map(item => zio.aws.apigateway.model.Model.wrap(item))
        .provideEnvironment(r)
    def getModelsPaginated(
        request: zio.aws.apigateway.model.GetModelsRequest
    ): IO[AwsError, zio.aws.apigateway.model.GetModelsResponse.ReadOnly] =
      asyncRequestResponse[GetModelsRequest, GetModelsResponse](
        "getModels",
        api.getModels
      )(request.buildAwsValue())
        .map(zio.aws.apigateway.model.GetModelsResponse.wrap)
        .provideEnvironment(r)
    def getStages(
        request: zio.aws.apigateway.model.GetStagesRequest
    ): IO[AwsError, zio.aws.apigateway.model.GetStagesResponse.ReadOnly] =
      asyncRequestResponse[GetStagesRequest, GetStagesResponse](
        "getStages",
        api.getStages
      )(request.buildAwsValue())
        .map(zio.aws.apigateway.model.GetStagesResponse.wrap)
        .provideEnvironment(r)
    def getDomainName(
        request: zio.aws.apigateway.model.GetDomainNameRequest
    ): IO[AwsError, zio.aws.apigateway.model.GetDomainNameResponse.ReadOnly] =
      asyncRequestResponse[GetDomainNameRequest, GetDomainNameResponse](
        "getDomainName",
        api.getDomainName
      )(request.buildAwsValue())
        .map(zio.aws.apigateway.model.GetDomainNameResponse.wrap)
        .provideEnvironment(r)
    def getDocumentationVersions(
        request: zio.aws.apigateway.model.GetDocumentationVersionsRequest
    ): IO[
      AwsError,
      zio.aws.apigateway.model.GetDocumentationVersionsResponse.ReadOnly
    ] = asyncRequestResponse[
      GetDocumentationVersionsRequest,
      GetDocumentationVersionsResponse
    ]("getDocumentationVersions", api.getDocumentationVersions)(
      request.buildAwsValue()
    ).map(zio.aws.apigateway.model.GetDocumentationVersionsResponse.wrap)
      .provideEnvironment(r)
    def getAuthorizer(
        request: zio.aws.apigateway.model.GetAuthorizerRequest
    ): IO[AwsError, zio.aws.apigateway.model.GetAuthorizerResponse.ReadOnly] =
      asyncRequestResponse[GetAuthorizerRequest, GetAuthorizerResponse](
        "getAuthorizer",
        api.getAuthorizer
      )(request.buildAwsValue())
        .map(zio.aws.apigateway.model.GetAuthorizerResponse.wrap)
        .provideEnvironment(r)
    def deleteDomainName(
        request: zio.aws.apigateway.model.DeleteDomainNameRequest
    ): IO[AwsError, Unit] =
      asyncRequestResponse[DeleteDomainNameRequest, DeleteDomainNameResponse](
        "deleteDomainName",
        api.deleteDomainName
      )(request.buildAwsValue()).unit.provideEnvironment(r)
    def updateRequestValidator(
        request: zio.aws.apigateway.model.UpdateRequestValidatorRequest
    ): IO[
      AwsError,
      zio.aws.apigateway.model.UpdateRequestValidatorResponse.ReadOnly
    ] = asyncRequestResponse[
      UpdateRequestValidatorRequest,
      UpdateRequestValidatorResponse
    ]("updateRequestValidator", api.updateRequestValidator)(
      request.buildAwsValue()
    ).map(zio.aws.apigateway.model.UpdateRequestValidatorResponse.wrap)
      .provideEnvironment(r)
    def getBasePathMappings(
        request: zio.aws.apigateway.model.GetBasePathMappingsRequest
    ): ZStream[
      Any,
      AwsError,
      zio.aws.apigateway.model.BasePathMapping.ReadOnly
    ] = asyncJavaPaginatedRequest[
      GetBasePathMappingsRequest,
      BasePathMapping,
      GetBasePathMappingsPublisher
    ]("getBasePathMappings", api.getBasePathMappingsPaginator, _.items())(
      request.buildAwsValue()
    ).map(item => zio.aws.apigateway.model.BasePathMapping.wrap(item))
      .provideEnvironment(r)
    def getBasePathMappingsPaginated(
        request: zio.aws.apigateway.model.GetBasePathMappingsRequest
    ): IO[
      AwsError,
      zio.aws.apigateway.model.GetBasePathMappingsResponse.ReadOnly
    ] = asyncRequestResponse[
      GetBasePathMappingsRequest,
      GetBasePathMappingsResponse
    ]("getBasePathMappings", api.getBasePathMappings)(request.buildAwsValue())
      .map(zio.aws.apigateway.model.GetBasePathMappingsResponse.wrap)
      .provideEnvironment(r)
    def deleteBasePathMapping(
        request: zio.aws.apigateway.model.DeleteBasePathMappingRequest
    ): IO[AwsError, Unit] = asyncRequestResponse[
      DeleteBasePathMappingRequest,
      DeleteBasePathMappingResponse
    ]("deleteBasePathMapping", api.deleteBasePathMapping)(
      request.buildAwsValue()
    ).unit.provideEnvironment(r)
    def updateDomainName(
        request: zio.aws.apigateway.model.UpdateDomainNameRequest
    ): IO[
      AwsError,
      zio.aws.apigateway.model.UpdateDomainNameResponse.ReadOnly
    ] = asyncRequestResponse[UpdateDomainNameRequest, UpdateDomainNameResponse](
      "updateDomainName",
      api.updateDomainName
    )(request.buildAwsValue())
      .map(zio.aws.apigateway.model.UpdateDomainNameResponse.wrap)
      .provideEnvironment(r)
    def deleteResource(
        request: zio.aws.apigateway.model.DeleteResourceRequest
    ): IO[AwsError, Unit] =
      asyncRequestResponse[DeleteResourceRequest, DeleteResourceResponse](
        "deleteResource",
        api.deleteResource
      )(request.buildAwsValue()).unit.provideEnvironment(r)
    def getTags(
        request: zio.aws.apigateway.model.GetTagsRequest
    ): IO[AwsError, zio.aws.apigateway.model.GetTagsResponse.ReadOnly] =
      asyncRequestResponse[GetTagsRequest, GetTagsResponse](
        "getTags",
        api.getTags
      )(request.buildAwsValue())
        .map(zio.aws.apigateway.model.GetTagsResponse.wrap)
        .provideEnvironment(r)
  }
  def getResource(request: zio.aws.apigateway.model.GetResourceRequest): ZIO[
    zio.aws.apigateway.ApiGateway,
    AwsError,
    zio.aws.apigateway.model.GetResourceResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getResource(request))
  def updateAccount(
      request: zio.aws.apigateway.model.UpdateAccountRequest
  ): ZIO[
    zio.aws.apigateway.ApiGateway,
    AwsError,
    zio.aws.apigateway.model.UpdateAccountResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.updateAccount(request))
  def updateStage(request: zio.aws.apigateway.model.UpdateStageRequest): ZIO[
    zio.aws.apigateway.ApiGateway,
    AwsError,
    zio.aws.apigateway.model.UpdateStageResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.updateStage(request))
  def getVpcLinks(
      request: zio.aws.apigateway.model.GetVpcLinksRequest
  ): ZStream[
    zio.aws.apigateway.ApiGateway,
    AwsError,
    zio.aws.apigateway.model.VpcLink.ReadOnly
  ] = ZStream.serviceWithStream(_.getVpcLinks(request))
  def getVpcLinksPaginated(
      request: zio.aws.apigateway.model.GetVpcLinksRequest
  ): ZIO[
    zio.aws.apigateway.ApiGateway,
    AwsError,
    zio.aws.apigateway.model.GetVpcLinksResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getVpcLinksPaginated(request))
  def createResource(
      request: zio.aws.apigateway.model.CreateResourceRequest
  ): ZIO[
    zio.aws.apigateway.ApiGateway,
    AwsError,
    zio.aws.apigateway.model.CreateResourceResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createResource(request))
  def deleteDocumentationVersion(
      request: zio.aws.apigateway.model.DeleteDocumentationVersionRequest
  ): ZIO[zio.aws.apigateway.ApiGateway, AwsError, Unit] =
    ZIO.serviceWithZIO(_.deleteDocumentationVersion(request))
  def testInvokeAuthorizer(
      request: zio.aws.apigateway.model.TestInvokeAuthorizerRequest
  ): ZIO[
    zio.aws.apigateway.ApiGateway,
    AwsError,
    zio.aws.apigateway.model.TestInvokeAuthorizerResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.testInvokeAuthorizer(request))
  def getRequestValidators(
      request: zio.aws.apigateway.model.GetRequestValidatorsRequest
  ): ZIO[
    zio.aws.apigateway.ApiGateway,
    AwsError,
    zio.aws.apigateway.model.GetRequestValidatorsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getRequestValidators(request))
  def getDocumentationPart(
      request: zio.aws.apigateway.model.GetDocumentationPartRequest
  ): ZIO[
    zio.aws.apigateway.ApiGateway,
    AwsError,
    zio.aws.apigateway.model.GetDocumentationPartResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getDocumentationPart(request))
  def updateResource(
      request: zio.aws.apigateway.model.UpdateResourceRequest
  ): ZIO[
    zio.aws.apigateway.ApiGateway,
    AwsError,
    zio.aws.apigateway.model.UpdateResourceResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.updateResource(request))
  def deleteRestApi(
      request: zio.aws.apigateway.model.DeleteRestApiRequest
  ): ZIO[zio.aws.apigateway.ApiGateway, AwsError, Unit] =
    ZIO.serviceWithZIO(_.deleteRestApi(request))
  def getMethod(request: zio.aws.apigateway.model.GetMethodRequest): ZIO[
    zio.aws.apigateway.ApiGateway,
    AwsError,
    zio.aws.apigateway.model.GetMethodResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getMethod(request))
  def deleteUsagePlan(
      request: zio.aws.apigateway.model.DeleteUsagePlanRequest
  ): ZIO[zio.aws.apigateway.ApiGateway, AwsError, Unit] =
    ZIO.serviceWithZIO(_.deleteUsagePlan(request))
  def getDomainNames(
      request: zio.aws.apigateway.model.GetDomainNamesRequest
  ): ZStream[
    zio.aws.apigateway.ApiGateway,
    AwsError,
    zio.aws.apigateway.model.DomainName.ReadOnly
  ] = ZStream.serviceWithStream(_.getDomainNames(request))
  def getDomainNamesPaginated(
      request: zio.aws.apigateway.model.GetDomainNamesRequest
  ): ZIO[
    zio.aws.apigateway.ApiGateway,
    AwsError,
    zio.aws.apigateway.model.GetDomainNamesResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getDomainNamesPaginated(request))
  def createBasePathMapping(
      request: zio.aws.apigateway.model.CreateBasePathMappingRequest
  ): ZIO[
    zio.aws.apigateway.ApiGateway,
    AwsError,
    zio.aws.apigateway.model.CreateBasePathMappingResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createBasePathMapping(request))
  def updateBasePathMapping(
      request: zio.aws.apigateway.model.UpdateBasePathMappingRequest
  ): ZIO[
    zio.aws.apigateway.ApiGateway,
    AwsError,
    zio.aws.apigateway.model.UpdateBasePathMappingResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.updateBasePathMapping(request))
  def createModel(request: zio.aws.apigateway.model.CreateModelRequest): ZIO[
    zio.aws.apigateway.ApiGateway,
    AwsError,
    zio.aws.apigateway.model.CreateModelResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createModel(request))
  def getMethodResponse(
      request: zio.aws.apigateway.model.GetMethodResponseRequest
  ): ZIO[
    zio.aws.apigateway.ApiGateway,
    AwsError,
    zio.aws.apigateway.model.GetMethodResponseResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getMethodResponse(request))
  def getClientCertificates(
      request: zio.aws.apigateway.model.GetClientCertificatesRequest
  ): ZStream[
    zio.aws.apigateway.ApiGateway,
    AwsError,
    zio.aws.apigateway.model.ClientCertificate.ReadOnly
  ] = ZStream.serviceWithStream(_.getClientCertificates(request))
  def getClientCertificatesPaginated(
      request: zio.aws.apigateway.model.GetClientCertificatesRequest
  ): ZIO[
    zio.aws.apigateway.ApiGateway,
    AwsError,
    zio.aws.apigateway.model.GetClientCertificatesResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getClientCertificatesPaginated(request))
  def createUsagePlan(
      request: zio.aws.apigateway.model.CreateUsagePlanRequest
  ): ZIO[
    zio.aws.apigateway.ApiGateway,
    AwsError,
    zio.aws.apigateway.model.CreateUsagePlanResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createUsagePlan(request))
  def updateApiKey(request: zio.aws.apigateway.model.UpdateApiKeyRequest): ZIO[
    zio.aws.apigateway.ApiGateway,
    AwsError,
    zio.aws.apigateway.model.UpdateApiKeyResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.updateApiKey(request))
  def updateModel(request: zio.aws.apigateway.model.UpdateModelRequest): ZIO[
    zio.aws.apigateway.ApiGateway,
    AwsError,
    zio.aws.apigateway.model.UpdateModelResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.updateModel(request))
  def createDocumentationPart(
      request: zio.aws.apigateway.model.CreateDocumentationPartRequest
  ): ZIO[
    zio.aws.apigateway.ApiGateway,
    AwsError,
    zio.aws.apigateway.model.CreateDocumentationPartResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createDocumentationPart(request))
  def getDocumentationParts(
      request: zio.aws.apigateway.model.GetDocumentationPartsRequest
  ): ZIO[
    zio.aws.apigateway.ApiGateway,
    AwsError,
    zio.aws.apigateway.model.GetDocumentationPartsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getDocumentationParts(request))
  def deleteVpcLink(
      request: zio.aws.apigateway.model.DeleteVpcLinkRequest
  ): ZIO[zio.aws.apigateway.ApiGateway, AwsError, Unit] =
    ZIO.serviceWithZIO(_.deleteVpcLink(request))
  def getVpcLink(request: zio.aws.apigateway.model.GetVpcLinkRequest): ZIO[
    zio.aws.apigateway.ApiGateway,
    AwsError,
    zio.aws.apigateway.model.GetVpcLinkResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getVpcLink(request))
  def createRequestValidator(
      request: zio.aws.apigateway.model.CreateRequestValidatorRequest
  ): ZIO[
    zio.aws.apigateway.ApiGateway,
    AwsError,
    zio.aws.apigateway.model.CreateRequestValidatorResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createRequestValidator(request))
  def testInvokeMethod(
      request: zio.aws.apigateway.model.TestInvokeMethodRequest
  ): ZIO[
    zio.aws.apigateway.ApiGateway,
    AwsError,
    zio.aws.apigateway.model.TestInvokeMethodResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.testInvokeMethod(request))
  def deleteUsagePlanKey(
      request: zio.aws.apigateway.model.DeleteUsagePlanKeyRequest
  ): ZIO[zio.aws.apigateway.ApiGateway, AwsError, Unit] =
    ZIO.serviceWithZIO(_.deleteUsagePlanKey(request))
  def putIntegrationResponse(
      request: zio.aws.apigateway.model.PutIntegrationResponseRequest
  ): ZIO[
    zio.aws.apigateway.ApiGateway,
    AwsError,
    zio.aws.apigateway.model.PutIntegrationResponseResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.putIntegrationResponse(request))
  def getDeployment(
      request: zio.aws.apigateway.model.GetDeploymentRequest
  ): ZIO[
    zio.aws.apigateway.ApiGateway,
    AwsError,
    zio.aws.apigateway.model.GetDeploymentResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getDeployment(request))
  def deleteDeployment(
      request: zio.aws.apigateway.model.DeleteDeploymentRequest
  ): ZIO[zio.aws.apigateway.ApiGateway, AwsError, Unit] =
    ZIO.serviceWithZIO(_.deleteDeployment(request))
  def flushStageCache(
      request: zio.aws.apigateway.model.FlushStageCacheRequest
  ): ZIO[zio.aws.apigateway.ApiGateway, AwsError, Unit] =
    ZIO.serviceWithZIO(_.flushStageCache(request))
  def getStage(request: zio.aws.apigateway.model.GetStageRequest): ZIO[
    zio.aws.apigateway.ApiGateway,
    AwsError,
    zio.aws.apigateway.model.GetStageResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getStage(request))
  def deleteIntegration(
      request: zio.aws.apigateway.model.DeleteIntegrationRequest
  ): ZIO[zio.aws.apigateway.ApiGateway, AwsError, Unit] =
    ZIO.serviceWithZIO(_.deleteIntegration(request))
  def updateDeployment(
      request: zio.aws.apigateway.model.UpdateDeploymentRequest
  ): ZIO[
    zio.aws.apigateway.ApiGateway,
    AwsError,
    zio.aws.apigateway.model.UpdateDeploymentResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.updateDeployment(request))
  def getIntegrationResponse(
      request: zio.aws.apigateway.model.GetIntegrationResponseRequest
  ): ZIO[
    zio.aws.apigateway.ApiGateway,
    AwsError,
    zio.aws.apigateway.model.GetIntegrationResponseResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getIntegrationResponse(request))
  def deleteMethodResponse(
      request: zio.aws.apigateway.model.DeleteMethodResponseRequest
  ): ZIO[zio.aws.apigateway.ApiGateway, AwsError, Unit] =
    ZIO.serviceWithZIO(_.deleteMethodResponse(request))
  def getGatewayResponses(
      request: zio.aws.apigateway.model.GetGatewayResponsesRequest
  ): ZIO[
    zio.aws.apigateway.ApiGateway,
    AwsError,
    zio.aws.apigateway.model.GetGatewayResponsesResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getGatewayResponses(request))
  def getAccount(request: zio.aws.apigateway.model.GetAccountRequest): ZIO[
    zio.aws.apigateway.ApiGateway,
    AwsError,
    zio.aws.apigateway.model.GetAccountResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getAccount(request))
  def updateVpcLink(
      request: zio.aws.apigateway.model.UpdateVpcLinkRequest
  ): ZIO[
    zio.aws.apigateway.ApiGateway,
    AwsError,
    zio.aws.apigateway.model.UpdateVpcLinkResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.updateVpcLink(request))
  def getUsage(request: zio.aws.apigateway.model.GetUsageRequest): ZIO[
    zio.aws.apigateway.ApiGateway,
    AwsError,
    zio.aws.apigateway.model.GetUsageResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getUsage(request))
  def getSdkType(request: zio.aws.apigateway.model.GetSdkTypeRequest): ZIO[
    zio.aws.apigateway.ApiGateway,
    AwsError,
    zio.aws.apigateway.model.GetSdkTypeResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getSdkType(request))
  def getExport(request: zio.aws.apigateway.model.GetExportRequest): ZIO[
    zio.aws.apigateway.ApiGateway,
    AwsError,
    zio.aws.apigateway.model.GetExportResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getExport(request))
  def getModel(request: zio.aws.apigateway.model.GetModelRequest): ZIO[
    zio.aws.apigateway.ApiGateway,
    AwsError,
    zio.aws.apigateway.model.GetModelResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getModel(request))
  def createRestApi(
      request: zio.aws.apigateway.model.CreateRestApiRequest
  ): ZIO[
    zio.aws.apigateway.ApiGateway,
    AwsError,
    zio.aws.apigateway.model.CreateRestApiResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createRestApi(request))
  def deleteDocumentationPart(
      request: zio.aws.apigateway.model.DeleteDocumentationPartRequest
  ): ZIO[zio.aws.apigateway.ApiGateway, AwsError, Unit] =
    ZIO.serviceWithZIO(_.deleteDocumentationPart(request))
  def updateAuthorizer(
      request: zio.aws.apigateway.model.UpdateAuthorizerRequest
  ): ZIO[
    zio.aws.apigateway.ApiGateway,
    AwsError,
    zio.aws.apigateway.model.UpdateAuthorizerResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.updateAuthorizer(request))
  def putMethodResponse(
      request: zio.aws.apigateway.model.PutMethodResponseRequest
  ): ZIO[
    zio.aws.apigateway.ApiGateway,
    AwsError,
    zio.aws.apigateway.model.PutMethodResponseResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.putMethodResponse(request))
  def createDocumentationVersion(
      request: zio.aws.apigateway.model.CreateDocumentationVersionRequest
  ): ZIO[
    zio.aws.apigateway.ApiGateway,
    AwsError,
    zio.aws.apigateway.model.CreateDocumentationVersionResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createDocumentationVersion(request))
  def deleteStage(
      request: zio.aws.apigateway.model.DeleteStageRequest
  ): ZIO[zio.aws.apigateway.ApiGateway, AwsError, Unit] =
    ZIO.serviceWithZIO(_.deleteStage(request))
  def flushStageAuthorizersCache(
      request: zio.aws.apigateway.model.FlushStageAuthorizersCacheRequest
  ): ZIO[zio.aws.apigateway.ApiGateway, AwsError, Unit] =
    ZIO.serviceWithZIO(_.flushStageAuthorizersCache(request))
  def getApiKeys(
      request: zio.aws.apigateway.model.GetApiKeysRequest
  ): ZStream[zio.aws.apigateway.ApiGateway, AwsError, ReadOnly] =
    ZStream.serviceWithStream(_.getApiKeys(request))
  def getApiKeysPaginated(
      request: zio.aws.apigateway.model.GetApiKeysRequest
  ): ZIO[
    zio.aws.apigateway.ApiGateway,
    AwsError,
    zio.aws.apigateway.model.GetApiKeysResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getApiKeysPaginated(request))
  def updateUsage(request: zio.aws.apigateway.model.UpdateUsageRequest): ZIO[
    zio.aws.apigateway.ApiGateway,
    AwsError,
    zio.aws.apigateway.model.UpdateUsageResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.updateUsage(request))
  def deleteModel(
      request: zio.aws.apigateway.model.DeleteModelRequest
  ): ZIO[zio.aws.apigateway.ApiGateway, AwsError, Unit] =
    ZIO.serviceWithZIO(_.deleteModel(request))
  def deleteMethod(
      request: zio.aws.apigateway.model.DeleteMethodRequest
  ): ZIO[zio.aws.apigateway.ApiGateway, AwsError, Unit] =
    ZIO.serviceWithZIO(_.deleteMethod(request))
  def getClientCertificate(
      request: zio.aws.apigateway.model.GetClientCertificateRequest
  ): ZIO[
    zio.aws.apigateway.ApiGateway,
    AwsError,
    zio.aws.apigateway.model.GetClientCertificateResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getClientCertificate(request))
  def getRestApis(
      request: zio.aws.apigateway.model.GetRestApisRequest
  ): ZStream[
    zio.aws.apigateway.ApiGateway,
    AwsError,
    zio.aws.apigateway.model.RestApi.ReadOnly
  ] = ZStream.serviceWithStream(_.getRestApis(request))
  def getRestApisPaginated(
      request: zio.aws.apigateway.model.GetRestApisRequest
  ): ZIO[
    zio.aws.apigateway.ApiGateway,
    AwsError,
    zio.aws.apigateway.model.GetRestApisResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getRestApisPaginated(request))
  def createDomainName(
      request: zio.aws.apigateway.model.CreateDomainNameRequest
  ): ZIO[
    zio.aws.apigateway.ApiGateway,
    AwsError,
    zio.aws.apigateway.model.CreateDomainNameResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createDomainName(request))
  def getResources(
      request: zio.aws.apigateway.model.GetResourcesRequest
  ): ZStream[
    zio.aws.apigateway.ApiGateway,
    AwsError,
    zio.aws.apigateway.model.Resource.ReadOnly
  ] = ZStream.serviceWithStream(_.getResources(request))
  def getResourcesPaginated(
      request: zio.aws.apigateway.model.GetResourcesRequest
  ): ZIO[
    zio.aws.apigateway.ApiGateway,
    AwsError,
    zio.aws.apigateway.model.GetResourcesResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getResourcesPaginated(request))
  def getDocumentationVersion(
      request: zio.aws.apigateway.model.GetDocumentationVersionRequest
  ): ZIO[
    zio.aws.apigateway.ApiGateway,
    AwsError,
    zio.aws.apigateway.model.GetDocumentationVersionResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getDocumentationVersion(request))
  def updateClientCertificate(
      request: zio.aws.apigateway.model.UpdateClientCertificateRequest
  ): ZIO[
    zio.aws.apigateway.ApiGateway,
    AwsError,
    zio.aws.apigateway.model.UpdateClientCertificateResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.updateClientCertificate(request))
  def importApiKeys(
      request: zio.aws.apigateway.model.ImportApiKeysRequest
  ): ZIO[
    zio.aws.apigateway.ApiGateway,
    AwsError,
    zio.aws.apigateway.model.ImportApiKeysResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.importApiKeys(request))
  def createVpcLink(
      request: zio.aws.apigateway.model.CreateVpcLinkRequest
  ): ZIO[
    zio.aws.apigateway.ApiGateway,
    AwsError,
    zio.aws.apigateway.model.CreateVpcLinkResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createVpcLink(request))
  def getApiKey(request: zio.aws.apigateway.model.GetApiKeyRequest): ZIO[
    zio.aws.apigateway.ApiGateway,
    AwsError,
    zio.aws.apigateway.model.GetApiKeyResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getApiKey(request))
  def deleteClientCertificate(
      request: zio.aws.apigateway.model.DeleteClientCertificateRequest
  ): ZIO[zio.aws.apigateway.ApiGateway, AwsError, Unit] =
    ZIO.serviceWithZIO(_.deleteClientCertificate(request))
  def updateRestApi(
      request: zio.aws.apigateway.model.UpdateRestApiRequest
  ): ZIO[
    zio.aws.apigateway.ApiGateway,
    AwsError,
    zio.aws.apigateway.model.UpdateRestApiResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.updateRestApi(request))
  def untagResource(
      request: zio.aws.apigateway.model.UntagResourceRequest
  ): ZIO[zio.aws.apigateway.ApiGateway, AwsError, Unit] =
    ZIO.serviceWithZIO(_.untagResource(request))
  def getAuthorizers(
      request: zio.aws.apigateway.model.GetAuthorizersRequest
  ): ZIO[
    zio.aws.apigateway.ApiGateway,
    AwsError,
    zio.aws.apigateway.model.GetAuthorizersResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getAuthorizers(request))
  def updateIntegrationResponse(
      request: zio.aws.apigateway.model.UpdateIntegrationResponseRequest
  ): ZIO[
    zio.aws.apigateway.ApiGateway,
    AwsError,
    zio.aws.apigateway.model.UpdateIntegrationResponseResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.updateIntegrationResponse(request))
  def deleteApiKey(
      request: zio.aws.apigateway.model.DeleteApiKeyRequest
  ): ZIO[zio.aws.apigateway.ApiGateway, AwsError, Unit] =
    ZIO.serviceWithZIO(_.deleteApiKey(request))
  def createDeployment(
      request: zio.aws.apigateway.model.CreateDeploymentRequest
  ): ZIO[
    zio.aws.apigateway.ApiGateway,
    AwsError,
    zio.aws.apigateway.model.CreateDeploymentResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createDeployment(request))
  def updateDocumentationPart(
      request: zio.aws.apigateway.model.UpdateDocumentationPartRequest
  ): ZIO[
    zio.aws.apigateway.ApiGateway,
    AwsError,
    zio.aws.apigateway.model.UpdateDocumentationPartResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.updateDocumentationPart(request))
  def createApiKey(request: zio.aws.apigateway.model.CreateApiKeyRequest): ZIO[
    zio.aws.apigateway.ApiGateway,
    AwsError,
    zio.aws.apigateway.model.CreateApiKeyResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createApiKey(request))
  def putIntegration(
      request: zio.aws.apigateway.model.PutIntegrationRequest
  ): ZIO[
    zio.aws.apigateway.ApiGateway,
    AwsError,
    zio.aws.apigateway.model.PutIntegrationResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.putIntegration(request))
  def importDocumentationParts(
      request: zio.aws.apigateway.model.ImportDocumentationPartsRequest
  ): ZIO[
    zio.aws.apigateway.ApiGateway,
    AwsError,
    zio.aws.apigateway.model.ImportDocumentationPartsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.importDocumentationParts(request))
  def getModelTemplate(
      request: zio.aws.apigateway.model.GetModelTemplateRequest
  ): ZIO[
    zio.aws.apigateway.ApiGateway,
    AwsError,
    zio.aws.apigateway.model.GetModelTemplateResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getModelTemplate(request))
  def createStage(request: zio.aws.apigateway.model.CreateStageRequest): ZIO[
    zio.aws.apigateway.ApiGateway,
    AwsError,
    zio.aws.apigateway.model.CreateStageResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createStage(request))
  def getUsagePlanKey(
      request: zio.aws.apigateway.model.GetUsagePlanKeyRequest
  ): ZIO[
    zio.aws.apigateway.ApiGateway,
    AwsError,
    zio.aws.apigateway.model.GetUsagePlanKeyResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getUsagePlanKey(request))
  def updateMethodResponse(
      request: zio.aws.apigateway.model.UpdateMethodResponseRequest
  ): ZIO[
    zio.aws.apigateway.ApiGateway,
    AwsError,
    zio.aws.apigateway.model.UpdateMethodResponseResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.updateMethodResponse(request))
  def getRestApi(request: zio.aws.apigateway.model.GetRestApiRequest): ZIO[
    zio.aws.apigateway.ApiGateway,
    AwsError,
    zio.aws.apigateway.model.GetRestApiResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getRestApi(request))
  def createAuthorizer(
      request: zio.aws.apigateway.model.CreateAuthorizerRequest
  ): ZIO[
    zio.aws.apigateway.ApiGateway,
    AwsError,
    zio.aws.apigateway.model.CreateAuthorizerResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createAuthorizer(request))
  def putMethod(request: zio.aws.apigateway.model.PutMethodRequest): ZIO[
    zio.aws.apigateway.ApiGateway,
    AwsError,
    zio.aws.apigateway.model.PutMethodResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.putMethod(request))
  def getGatewayResponse(
      request: zio.aws.apigateway.model.GetGatewayResponseRequest
  ): ZIO[
    zio.aws.apigateway.ApiGateway,
    AwsError,
    zio.aws.apigateway.model.GetGatewayResponseResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getGatewayResponse(request))
  def generateClientCertificate(
      request: zio.aws.apigateway.model.GenerateClientCertificateRequest
  ): ZIO[
    zio.aws.apigateway.ApiGateway,
    AwsError,
    zio.aws.apigateway.model.GenerateClientCertificateResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.generateClientCertificate(request))
  def tagResource(
      request: zio.aws.apigateway.model.TagResourceRequest
  ): ZIO[zio.aws.apigateway.ApiGateway, AwsError, Unit] =
    ZIO.serviceWithZIO(_.tagResource(request))
  def getUsagePlan(request: zio.aws.apigateway.model.GetUsagePlanRequest): ZIO[
    zio.aws.apigateway.ApiGateway,
    AwsError,
    zio.aws.apigateway.model.GetUsagePlanResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getUsagePlan(request))
  def createUsagePlanKey(
      request: zio.aws.apigateway.model.CreateUsagePlanKeyRequest
  ): ZIO[
    zio.aws.apigateway.ApiGateway,
    AwsError,
    zio.aws.apigateway.model.CreateUsagePlanKeyResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createUsagePlanKey(request))
  def updateUsagePlan(
      request: zio.aws.apigateway.model.UpdateUsagePlanRequest
  ): ZIO[
    zio.aws.apigateway.ApiGateway,
    AwsError,
    zio.aws.apigateway.model.UpdateUsagePlanResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.updateUsagePlan(request))
  def getIntegration(
      request: zio.aws.apigateway.model.GetIntegrationRequest
  ): ZIO[
    zio.aws.apigateway.ApiGateway,
    AwsError,
    zio.aws.apigateway.model.GetIntegrationResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getIntegration(request))
  def getDeployments(
      request: zio.aws.apigateway.model.GetDeploymentsRequest
  ): ZStream[
    zio.aws.apigateway.ApiGateway,
    AwsError,
    zio.aws.apigateway.model.Deployment.ReadOnly
  ] = ZStream.serviceWithStream(_.getDeployments(request))
  def getDeploymentsPaginated(
      request: zio.aws.apigateway.model.GetDeploymentsRequest
  ): ZIO[
    zio.aws.apigateway.ApiGateway,
    AwsError,
    zio.aws.apigateway.model.GetDeploymentsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getDeploymentsPaginated(request))
  def putRestApi(request: zio.aws.apigateway.model.PutRestApiRequest): ZIO[
    zio.aws.apigateway.ApiGateway,
    AwsError,
    zio.aws.apigateway.model.PutRestApiResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.putRestApi(request))
  def getUsagePlans(
      request: zio.aws.apigateway.model.GetUsagePlansRequest
  ): ZStream[
    zio.aws.apigateway.ApiGateway,
    AwsError,
    zio.aws.apigateway.model.UsagePlan.ReadOnly
  ] = ZStream.serviceWithStream(_.getUsagePlans(request))
  def getUsagePlansPaginated(
      request: zio.aws.apigateway.model.GetUsagePlansRequest
  ): ZIO[
    zio.aws.apigateway.ApiGateway,
    AwsError,
    zio.aws.apigateway.model.GetUsagePlansResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getUsagePlansPaginated(request))
  def getSdk(request: zio.aws.apigateway.model.GetSdkRequest): ZIO[
    zio.aws.apigateway.ApiGateway,
    AwsError,
    zio.aws.apigateway.model.GetSdkResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getSdk(request))
  def deleteAuthorizer(
      request: zio.aws.apigateway.model.DeleteAuthorizerRequest
  ): ZIO[zio.aws.apigateway.ApiGateway, AwsError, Unit] =
    ZIO.serviceWithZIO(_.deleteAuthorizer(request))
  def getBasePathMapping(
      request: zio.aws.apigateway.model.GetBasePathMappingRequest
  ): ZIO[
    zio.aws.apigateway.ApiGateway,
    AwsError,
    zio.aws.apigateway.model.GetBasePathMappingResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getBasePathMapping(request))
  def deleteRequestValidator(
      request: zio.aws.apigateway.model.DeleteRequestValidatorRequest
  ): ZIO[zio.aws.apigateway.ApiGateway, AwsError, Unit] =
    ZIO.serviceWithZIO(_.deleteRequestValidator(request))
  def getSdkTypes(request: zio.aws.apigateway.model.GetSdkTypesRequest): ZIO[
    zio.aws.apigateway.ApiGateway,
    AwsError,
    zio.aws.apigateway.model.GetSdkTypesResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getSdkTypes(request))
  def getUsagePlanKeys(
      request: zio.aws.apigateway.model.GetUsagePlanKeysRequest
  ): ZStream[
    zio.aws.apigateway.ApiGateway,
    AwsError,
    zio.aws.apigateway.model.UsagePlanKey.ReadOnly
  ] = ZStream.serviceWithStream(_.getUsagePlanKeys(request))
  def getUsagePlanKeysPaginated(
      request: zio.aws.apigateway.model.GetUsagePlanKeysRequest
  ): ZIO[
    zio.aws.apigateway.ApiGateway,
    AwsError,
    zio.aws.apigateway.model.GetUsagePlanKeysResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getUsagePlanKeysPaginated(request))
  def deleteIntegrationResponse(
      request: zio.aws.apigateway.model.DeleteIntegrationResponseRequest
  ): ZIO[zio.aws.apigateway.ApiGateway, AwsError, Unit] =
    ZIO.serviceWithZIO(_.deleteIntegrationResponse(request))
  def updateMethod(request: zio.aws.apigateway.model.UpdateMethodRequest): ZIO[
    zio.aws.apigateway.ApiGateway,
    AwsError,
    zio.aws.apigateway.model.UpdateMethodResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.updateMethod(request))
  def updateIntegration(
      request: zio.aws.apigateway.model.UpdateIntegrationRequest
  ): ZIO[
    zio.aws.apigateway.ApiGateway,
    AwsError,
    zio.aws.apigateway.model.UpdateIntegrationResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.updateIntegration(request))
  def importRestApi(
      request: zio.aws.apigateway.model.ImportRestApiRequest
  ): ZIO[
    zio.aws.apigateway.ApiGateway,
    AwsError,
    zio.aws.apigateway.model.ImportRestApiResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.importRestApi(request))
  def deleteGatewayResponse(
      request: zio.aws.apigateway.model.DeleteGatewayResponseRequest
  ): ZIO[zio.aws.apigateway.ApiGateway, AwsError, Unit] =
    ZIO.serviceWithZIO(_.deleteGatewayResponse(request))
  def updateGatewayResponse(
      request: zio.aws.apigateway.model.UpdateGatewayResponseRequest
  ): ZIO[
    zio.aws.apigateway.ApiGateway,
    AwsError,
    zio.aws.apigateway.model.UpdateGatewayResponseResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.updateGatewayResponse(request))
  def updateDocumentationVersion(
      request: zio.aws.apigateway.model.UpdateDocumentationVersionRequest
  ): ZIO[
    zio.aws.apigateway.ApiGateway,
    AwsError,
    zio.aws.apigateway.model.UpdateDocumentationVersionResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.updateDocumentationVersion(request))
  def putGatewayResponse(
      request: zio.aws.apigateway.model.PutGatewayResponseRequest
  ): ZIO[
    zio.aws.apigateway.ApiGateway,
    AwsError,
    zio.aws.apigateway.model.PutGatewayResponseResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.putGatewayResponse(request))
  def getRequestValidator(
      request: zio.aws.apigateway.model.GetRequestValidatorRequest
  ): ZIO[
    zio.aws.apigateway.ApiGateway,
    AwsError,
    zio.aws.apigateway.model.GetRequestValidatorResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getRequestValidator(request))
  def getModels(request: zio.aws.apigateway.model.GetModelsRequest): ZStream[
    zio.aws.apigateway.ApiGateway,
    AwsError,
    zio.aws.apigateway.model.Model.ReadOnly
  ] = ZStream.serviceWithStream(_.getModels(request))
  def getModelsPaginated(
      request: zio.aws.apigateway.model.GetModelsRequest
  ): ZIO[
    zio.aws.apigateway.ApiGateway,
    AwsError,
    zio.aws.apigateway.model.GetModelsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getModelsPaginated(request))
  def getStages(request: zio.aws.apigateway.model.GetStagesRequest): ZIO[
    zio.aws.apigateway.ApiGateway,
    AwsError,
    zio.aws.apigateway.model.GetStagesResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getStages(request))
  def getDomainName(
      request: zio.aws.apigateway.model.GetDomainNameRequest
  ): ZIO[
    zio.aws.apigateway.ApiGateway,
    AwsError,
    zio.aws.apigateway.model.GetDomainNameResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getDomainName(request))
  def getDocumentationVersions(
      request: zio.aws.apigateway.model.GetDocumentationVersionsRequest
  ): ZIO[
    zio.aws.apigateway.ApiGateway,
    AwsError,
    zio.aws.apigateway.model.GetDocumentationVersionsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getDocumentationVersions(request))
  def getAuthorizer(
      request: zio.aws.apigateway.model.GetAuthorizerRequest
  ): ZIO[
    zio.aws.apigateway.ApiGateway,
    AwsError,
    zio.aws.apigateway.model.GetAuthorizerResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getAuthorizer(request))
  def deleteDomainName(
      request: zio.aws.apigateway.model.DeleteDomainNameRequest
  ): ZIO[zio.aws.apigateway.ApiGateway, AwsError, Unit] =
    ZIO.serviceWithZIO(_.deleteDomainName(request))
  def updateRequestValidator(
      request: zio.aws.apigateway.model.UpdateRequestValidatorRequest
  ): ZIO[
    zio.aws.apigateway.ApiGateway,
    AwsError,
    zio.aws.apigateway.model.UpdateRequestValidatorResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.updateRequestValidator(request))
  def getBasePathMappings(
      request: zio.aws.apigateway.model.GetBasePathMappingsRequest
  ): ZStream[
    zio.aws.apigateway.ApiGateway,
    AwsError,
    zio.aws.apigateway.model.BasePathMapping.ReadOnly
  ] = ZStream.serviceWithStream(_.getBasePathMappings(request))
  def getBasePathMappingsPaginated(
      request: zio.aws.apigateway.model.GetBasePathMappingsRequest
  ): ZIO[
    zio.aws.apigateway.ApiGateway,
    AwsError,
    zio.aws.apigateway.model.GetBasePathMappingsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getBasePathMappingsPaginated(request))
  def deleteBasePathMapping(
      request: zio.aws.apigateway.model.DeleteBasePathMappingRequest
  ): ZIO[zio.aws.apigateway.ApiGateway, AwsError, Unit] =
    ZIO.serviceWithZIO(_.deleteBasePathMapping(request))
  def updateDomainName(
      request: zio.aws.apigateway.model.UpdateDomainNameRequest
  ): ZIO[
    zio.aws.apigateway.ApiGateway,
    AwsError,
    zio.aws.apigateway.model.UpdateDomainNameResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.updateDomainName(request))
  def deleteResource(
      request: zio.aws.apigateway.model.DeleteResourceRequest
  ): ZIO[zio.aws.apigateway.ApiGateway, AwsError, Unit] =
    ZIO.serviceWithZIO(_.deleteResource(request))
  def getTags(request: zio.aws.apigateway.model.GetTagsRequest): ZIO[
    zio.aws.apigateway.ApiGateway,
    AwsError,
    zio.aws.apigateway.model.GetTagsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getTags(request))
}
