package zio.aws.apigateway.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class CreateBasePathMappingRequest(
    domainName: String,
    basePath: Optional[String] = Optional.Absent,
    restApiId: String,
    stage: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.apigateway.model.CreateBasePathMappingRequest = {
    import CreateBasePathMappingRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.apigateway.model.CreateBasePathMappingRequest
      .builder()
      .domainName(domainName: java.lang.String)
      .optionallyWith(basePath.map(value => value: java.lang.String))(
        _.basePath
      )
      .restApiId(restApiId: java.lang.String)
      .optionallyWith(stage.map(value => value: java.lang.String))(_.stage)
      .build()
  }
  def asReadOnly
      : zio.aws.apigateway.model.CreateBasePathMappingRequest.ReadOnly =
    zio.aws.apigateway.model.CreateBasePathMappingRequest.wrap(buildAwsValue())
}
object CreateBasePathMappingRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.apigateway.model.CreateBasePathMappingRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.apigateway.model.CreateBasePathMappingRequest =
      zio.aws.apigateway.model.CreateBasePathMappingRequest(
        domainName,
        basePath.map(value => value),
        restApiId,
        stage.map(value => value)
      )
    def domainName: String
    def basePath: Optional[String]
    def restApiId: String
    def stage: Optional[String]
    def getDomainName: ZIO[Any, Nothing, String] = ZIO.succeed(domainName)
    def getBasePath: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("basePath", basePath)
    def getRestApiId: ZIO[Any, Nothing, String] = ZIO.succeed(restApiId)
    def getStage: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("stage", stage)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.apigateway.model.CreateBasePathMappingRequest
  ) extends zio.aws.apigateway.model.CreateBasePathMappingRequest.ReadOnly {
    override val domainName: String = impl.domainName(): String
    override val basePath: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.basePath())
      .map(value => value: String)
    override val restApiId: String = impl.restApiId(): String
    override val stage: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.stage())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.apigateway.model.CreateBasePathMappingRequest
  ): zio.aws.apigateway.model.CreateBasePathMappingRequest.ReadOnly =
    new Wrapper(impl)
}
