package zio.aws.apigateway.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.apigateway.model.primitives.NullableBoolean
import scala.jdk.CollectionConverters.*
final case class CreateDeploymentRequest(
    restApiId: String,
    stageName: Optional[String] = Optional.Absent,
    stageDescription: Optional[String] = Optional.Absent,
    description: Optional[String] = Optional.Absent,
    cacheClusterEnabled: Optional[NullableBoolean] = Optional.Absent,
    cacheClusterSize: Optional[String] = Optional.Absent,
    variables: Optional[Map[String, String]] = Optional.Absent,
    canarySettings: Optional[
      zio.aws.apigateway.model.DeploymentCanarySettings
    ] = Optional.Absent,
    tracingEnabled: Optional[NullableBoolean] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.apigateway.model.CreateDeploymentRequest = {
    import CreateDeploymentRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.apigateway.model.CreateDeploymentRequest
      .builder()
      .restApiId(restApiId: java.lang.String)
      .optionallyWith(stageName.map(value => value: java.lang.String))(
        _.stageName
      )
      .optionallyWith(stageDescription.map(value => value: java.lang.String))(
        _.stageDescription
      )
      .optionallyWith(description.map(value => value: java.lang.String))(
        _.description
      )
      .optionallyWith(
        cacheClusterEnabled.map(value => value: java.lang.Boolean)
      )(_.cacheClusterEnabled)
      .optionallyWith(cacheClusterSize.map(value => value: java.lang.String))(
        _.cacheClusterSize
      )
      .optionallyWith(
        variables.map(value =>
          value
            .map({ case (key, value) =>
              (key: java.lang.String) -> (value: java.lang.String)
            })
            .asJava
        )
      )(_.variables)
      .optionallyWith(canarySettings.map(value => value.buildAwsValue()))(
        _.canarySettings
      )
      .optionallyWith(tracingEnabled.map(value => value: java.lang.Boolean))(
        _.tracingEnabled
      )
      .build()
  }
  def asReadOnly: zio.aws.apigateway.model.CreateDeploymentRequest.ReadOnly =
    zio.aws.apigateway.model.CreateDeploymentRequest.wrap(buildAwsValue())
}
object CreateDeploymentRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.apigateway.model.CreateDeploymentRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.apigateway.model.CreateDeploymentRequest =
      zio.aws.apigateway.model.CreateDeploymentRequest(
        restApiId,
        stageName.map(value => value),
        stageDescription.map(value => value),
        description.map(value => value),
        cacheClusterEnabled.map(value => value),
        cacheClusterSize.map(value => value),
        variables.map(value => value),
        canarySettings.map(value => value.asEditable),
        tracingEnabled.map(value => value)
      )
    def restApiId: String
    def stageName: Optional[String]
    def stageDescription: Optional[String]
    def description: Optional[String]
    def cacheClusterEnabled: Optional[NullableBoolean]
    def cacheClusterSize: Optional[String]
    def variables: Optional[Map[String, String]]
    def canarySettings
        : Optional[zio.aws.apigateway.model.DeploymentCanarySettings.ReadOnly]
    def tracingEnabled: Optional[NullableBoolean]
    def getRestApiId: ZIO[Any, Nothing, String] = ZIO.succeed(restApiId)
    def getStageName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("stageName", stageName)
    def getStageDescription: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("stageDescription", stageDescription)
    def getDescription: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("description", description)
    def getCacheClusterEnabled: ZIO[Any, AwsError, NullableBoolean] =
      AwsError.unwrapOptionField("cacheClusterEnabled", cacheClusterEnabled)
    def getCacheClusterSize: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("cacheClusterSize", cacheClusterSize)
    def getVariables: ZIO[Any, AwsError, Map[String, String]] =
      AwsError.unwrapOptionField("variables", variables)
    def getCanarySettings: ZIO[
      Any,
      AwsError,
      zio.aws.apigateway.model.DeploymentCanarySettings.ReadOnly
    ] = AwsError.unwrapOptionField("canarySettings", canarySettings)
    def getTracingEnabled: ZIO[Any, AwsError, NullableBoolean] =
      AwsError.unwrapOptionField("tracingEnabled", tracingEnabled)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.apigateway.model.CreateDeploymentRequest
  ) extends zio.aws.apigateway.model.CreateDeploymentRequest.ReadOnly {
    override val restApiId: String = impl.restApiId(): String
    override val stageName: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.stageName())
      .map(value => value: String)
    override val stageDescription: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.stageDescription())
      .map(value => value: String)
    override val description: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.description())
      .map(value => value: String)
    override val cacheClusterEnabled: Optional[NullableBoolean] =
      zio.aws.core.internal
        .optionalFromNullable(impl.cacheClusterEnabled())
        .map(value => value: NullableBoolean)
    override val cacheClusterSize: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.cacheClusterSize())
      .map(value => value: String)
    override val variables: Optional[Map[String, String]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.variables())
        .map(value =>
          value.asScala
            .map({ case (key, value) =>
              (key: String) -> (value: String)
            })
            .toMap
        )
    override val canarySettings
        : Optional[zio.aws.apigateway.model.DeploymentCanarySettings.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.canarySettings())
        .map(value =>
          zio.aws.apigateway.model.DeploymentCanarySettings.wrap(value)
        )
    override val tracingEnabled: Optional[NullableBoolean] =
      zio.aws.core.internal
        .optionalFromNullable(impl.tracingEnabled())
        .map(value => value: NullableBoolean)
  }
  def wrap(
      impl: software.amazon.awssdk.services.apigateway.model.CreateDeploymentRequest
  ): zio.aws.apigateway.model.CreateDeploymentRequest.ReadOnly = new Wrapper(
    impl
  )
}
