package zio.aws.apigateway.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class CreateRequestValidatorResponse(
    id: Optional[String] = Optional.Absent,
    name: Optional[String] = Optional.Absent,
    validateRequestBody: Optional[Boolean] = Optional.Absent,
    validateRequestParameters: Optional[Boolean] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.apigateway.model.CreateRequestValidatorResponse = {
    import CreateRequestValidatorResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.apigateway.model.CreateRequestValidatorResponse
      .builder()
      .optionallyWith(id.map(value => value: java.lang.String))(_.id)
      .optionallyWith(name.map(value => value: java.lang.String))(_.name)
      .optionallyWith(
        validateRequestBody.map(value => value: java.lang.Boolean)
      )(_.validateRequestBody)
      .optionallyWith(
        validateRequestParameters.map(value => value: java.lang.Boolean)
      )(_.validateRequestParameters)
      .build()
  }
  def asReadOnly
      : zio.aws.apigateway.model.CreateRequestValidatorResponse.ReadOnly =
    zio.aws.apigateway.model.CreateRequestValidatorResponse
      .wrap(buildAwsValue())
}
object CreateRequestValidatorResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.apigateway.model.CreateRequestValidatorResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.apigateway.model.CreateRequestValidatorResponse =
      zio.aws.apigateway.model.CreateRequestValidatorResponse(
        id.map(value => value),
        name.map(value => value),
        validateRequestBody.map(value => value),
        validateRequestParameters.map(value => value)
      )
    def id: Optional[String]
    def name: Optional[String]
    def validateRequestBody: Optional[Boolean]
    def validateRequestParameters: Optional[Boolean]
    def getId: ZIO[Any, AwsError, String] = AwsError.unwrapOptionField("id", id)
    def getName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("name", name)
    def getValidateRequestBody: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("validateRequestBody", validateRequestBody)
    def getValidateRequestParameters: ZIO[Any, AwsError, Boolean] = AwsError
      .unwrapOptionField("validateRequestParameters", validateRequestParameters)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.apigateway.model.CreateRequestValidatorResponse
  ) extends zio.aws.apigateway.model.CreateRequestValidatorResponse.ReadOnly {
    override val id: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.id())
      .map(value => value: String)
    override val name: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.name())
      .map(value => value: String)
    override val validateRequestBody: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.validateRequestBody())
      .map(value => value: Boolean)
    override val validateRequestParameters: Optional[Boolean] =
      zio.aws.core.internal
        .optionalFromNullable(impl.validateRequestParameters())
        .map(value => value: Boolean)
  }
  def wrap(
      impl: software.amazon.awssdk.services.apigateway.model.CreateRequestValidatorResponse
  ): zio.aws.apigateway.model.CreateRequestValidatorResponse.ReadOnly =
    new Wrapper(impl)
}
