package zio.aws.apigateway.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class DeleteGatewayResponseRequest(
    restApiId: String,
    responseType: zio.aws.apigateway.model.GatewayResponseType
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.apigateway.model.DeleteGatewayResponseRequest = {
    import DeleteGatewayResponseRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.apigateway.model.DeleteGatewayResponseRequest
      .builder()
      .restApiId(restApiId: java.lang.String)
      .responseType(responseType.unwrap)
      .build()
  }
  def asReadOnly
      : zio.aws.apigateway.model.DeleteGatewayResponseRequest.ReadOnly =
    zio.aws.apigateway.model.DeleteGatewayResponseRequest.wrap(buildAwsValue())
}
object DeleteGatewayResponseRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.apigateway.model.DeleteGatewayResponseRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.apigateway.model.DeleteGatewayResponseRequest =
      zio.aws.apigateway.model
        .DeleteGatewayResponseRequest(restApiId, responseType)
    def restApiId: String
    def responseType: zio.aws.apigateway.model.GatewayResponseType
    def getRestApiId: ZIO[Any, Nothing, String] = ZIO.succeed(restApiId)
    def getResponseType
        : ZIO[Any, Nothing, zio.aws.apigateway.model.GatewayResponseType] =
      ZIO.succeed(responseType)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.apigateway.model.DeleteGatewayResponseRequest
  ) extends zio.aws.apigateway.model.DeleteGatewayResponseRequest.ReadOnly {
    override val restApiId: String = impl.restApiId(): String
    override val responseType: zio.aws.apigateway.model.GatewayResponseType =
      zio.aws.apigateway.model.GatewayResponseType.wrap(impl.responseType())
  }
  def wrap(
      impl: software.amazon.awssdk.services.apigateway.model.DeleteGatewayResponseRequest
  ): zio.aws.apigateway.model.DeleteGatewayResponseRequest.ReadOnly =
    new Wrapper(impl)
}
