package zio.aws.apigateway.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class FlushStageCacheRequest(restApiId: String, stageName: String) {
  def buildAwsValue()
      : software.amazon.awssdk.services.apigateway.model.FlushStageCacheRequest = {
    import FlushStageCacheRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.apigateway.model.FlushStageCacheRequest
      .builder()
      .restApiId(restApiId: java.lang.String)
      .stageName(stageName: java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.apigateway.model.FlushStageCacheRequest.ReadOnly =
    zio.aws.apigateway.model.FlushStageCacheRequest.wrap(buildAwsValue())
}
object FlushStageCacheRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.apigateway.model.FlushStageCacheRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.apigateway.model.FlushStageCacheRequest =
      zio.aws.apigateway.model.FlushStageCacheRequest(restApiId, stageName)
    def restApiId: String
    def stageName: String
    def getRestApiId: ZIO[Any, Nothing, String] = ZIO.succeed(restApiId)
    def getStageName: ZIO[Any, Nothing, String] = ZIO.succeed(stageName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.apigateway.model.FlushStageCacheRequest
  ) extends zio.aws.apigateway.model.FlushStageCacheRequest.ReadOnly {
    override val restApiId: String = impl.restApiId(): String
    override val stageName: String = impl.stageName(): String
  }
  def wrap(
      impl: software.amazon.awssdk.services.apigateway.model.FlushStageCacheRequest
  ): zio.aws.apigateway.model.FlushStageCacheRequest.ReadOnly = new Wrapper(
    impl
  )
}
