package zio.aws.apigateway.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class GetDeploymentRequest(
    restApiId: String,
    deploymentId: String,
    embed: Optional[Iterable[String]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.apigateway.model.GetDeploymentRequest = {
    import GetDeploymentRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.apigateway.model.GetDeploymentRequest
      .builder()
      .restApiId(restApiId: java.lang.String)
      .deploymentId(deploymentId: java.lang.String)
      .optionallyWith(
        embed.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.embed)
      .build()
  }
  def asReadOnly: zio.aws.apigateway.model.GetDeploymentRequest.ReadOnly =
    zio.aws.apigateway.model.GetDeploymentRequest.wrap(buildAwsValue())
}
object GetDeploymentRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.apigateway.model.GetDeploymentRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.apigateway.model.GetDeploymentRequest =
      zio.aws.apigateway.model.GetDeploymentRequest(
        restApiId,
        deploymentId,
        embed.map(value => value)
      )
    def restApiId: String
    def deploymentId: String
    def embed: Optional[List[String]]
    def getRestApiId: ZIO[Any, Nothing, String] = ZIO.succeed(restApiId)
    def getDeploymentId: ZIO[Any, Nothing, String] = ZIO.succeed(deploymentId)
    def getEmbed: ZIO[Any, AwsError, List[String]] =
      AwsError.unwrapOptionField("embed", embed)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.apigateway.model.GetDeploymentRequest
  ) extends zio.aws.apigateway.model.GetDeploymentRequest.ReadOnly {
    override val restApiId: String = impl.restApiId(): String
    override val deploymentId: String = impl.deploymentId(): String
    override val embed: Optional[List[String]] = zio.aws.core.internal
      .optionalFromNullable(impl.embed())
      .map(value =>
        value.asScala.map { item =>
          item: String
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.apigateway.model.GetDeploymentRequest
  ): zio.aws.apigateway.model.GetDeploymentRequest.ReadOnly = new Wrapper(impl)
}
