package zio.aws.apigateway.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.apigateway.model.primitives.Blob
import scala.jdk.CollectionConverters.*
final case class GetExportResponse(
    contentType: Optional[String] = Optional.Absent,
    contentDisposition: Optional[String] = Optional.Absent,
    body: Optional[Blob] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.apigateway.model.GetExportResponse = {
    import GetExportResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.apigateway.model.GetExportResponse
      .builder()
      .optionallyWith(contentType.map(value => value: java.lang.String))(
        _.contentType
      )
      .optionallyWith(contentDisposition.map(value => value: java.lang.String))(
        _.contentDisposition
      )
      .optionallyWith(
        body.map(value =>
          software.amazon.awssdk.core.SdkBytes
            .fromByteArrayUnsafe(value.toArray[Byte])
        )
      )(_.body)
      .build()
  }
  def asReadOnly: zio.aws.apigateway.model.GetExportResponse.ReadOnly =
    zio.aws.apigateway.model.GetExportResponse.wrap(buildAwsValue())
}
object GetExportResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.apigateway.model.GetExportResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.apigateway.model.GetExportResponse =
      zio.aws.apigateway.model.GetExportResponse(
        contentType.map(value => value),
        contentDisposition.map(value => value),
        body.map(value => value)
      )
    def contentType: Optional[String]
    def contentDisposition: Optional[String]
    def body: Optional[Blob]
    def getContentType: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("contentType", contentType)
    def getContentDisposition: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("contentDisposition", contentDisposition)
    def getBody: ZIO[Any, AwsError, Blob] =
      AwsError.unwrapOptionField("body", body)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.apigateway.model.GetExportResponse
  ) extends zio.aws.apigateway.model.GetExportResponse.ReadOnly {
    override val contentType: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.contentType())
      .map(value => value: String)
    override val contentDisposition: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.contentDisposition())
      .map(value => value: String)
    override val body: Optional[Blob] = zio.aws.core.internal
      .optionalFromNullable(impl.body())
      .map(value =>
        zio.aws.apigateway.model.primitives
          .Blob(zio.Chunk.fromArray(value.asByteArrayUnsafe()))
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.apigateway.model.GetExportResponse
  ): zio.aws.apigateway.model.GetExportResponse.ReadOnly = new Wrapper(impl)
}
