package zio.aws.apigateway.model
import zio.aws.apigateway.model.primitives.NullableInteger
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters.*
final case class GetRestApisRequest(
    position: Optional[String] = Optional.Absent,
    limit: Optional[NullableInteger] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.apigateway.model.GetRestApisRequest = {
    import GetRestApisRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.apigateway.model.GetRestApisRequest
      .builder()
      .optionallyWith(position.map(value => value: java.lang.String))(
        _.position
      )
      .optionallyWith(limit.map(value => value: Integer))(_.limit)
      .build()
  }
  def asReadOnly: zio.aws.apigateway.model.GetRestApisRequest.ReadOnly =
    zio.aws.apigateway.model.GetRestApisRequest.wrap(buildAwsValue())
}
object GetRestApisRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.apigateway.model.GetRestApisRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.apigateway.model.GetRestApisRequest =
      zio.aws.apigateway.model.GetRestApisRequest(
        position.map(value => value),
        limit.map(value => value)
      )
    def position: Optional[String]
    def limit: Optional[NullableInteger]
    def getPosition: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("position", position)
    def getLimit: ZIO[Any, AwsError, NullableInteger] =
      AwsError.unwrapOptionField("limit", limit)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.apigateway.model.GetRestApisRequest
  ) extends zio.aws.apigateway.model.GetRestApisRequest.ReadOnly {
    override val position: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.position())
      .map(value => value: String)
    override val limit: Optional[NullableInteger] = zio.aws.core.internal
      .optionalFromNullable(impl.limit())
      .map(value => value: NullableInteger)
  }
  def wrap(
      impl: software.amazon.awssdk.services.apigateway.model.GetRestApisRequest
  ): zio.aws.apigateway.model.GetRestApisRequest.ReadOnly = new Wrapper(impl)
}
