package zio.aws.apigateway.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class GetRestApisResponse(
    position: Optional[String] = Optional.Absent,
    items: Optional[Iterable[zio.aws.apigateway.model.RestApi]] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.apigateway.model.GetRestApisResponse = {
    import GetRestApisResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.apigateway.model.GetRestApisResponse
      .builder()
      .optionallyWith(position.map(value => value: java.lang.String))(
        _.position
      )
      .optionallyWith(
        items.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.items)
      .build()
  }
  def asReadOnly: zio.aws.apigateway.model.GetRestApisResponse.ReadOnly =
    zio.aws.apigateway.model.GetRestApisResponse.wrap(buildAwsValue())
}
object GetRestApisResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.apigateway.model.GetRestApisResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.apigateway.model.GetRestApisResponse =
      zio.aws.apigateway.model.GetRestApisResponse(
        position.map(value => value),
        items.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def position: Optional[String]
    def items: Optional[List[zio.aws.apigateway.model.RestApi.ReadOnly]]
    def getPosition: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("position", position)
    def getItems
        : ZIO[Any, AwsError, List[zio.aws.apigateway.model.RestApi.ReadOnly]] =
      AwsError.unwrapOptionField("items", items)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.apigateway.model.GetRestApisResponse
  ) extends zio.aws.apigateway.model.GetRestApisResponse.ReadOnly {
    override val position: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.position())
      .map(value => value: String)
    override val items
        : Optional[List[zio.aws.apigateway.model.RestApi.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.items())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.apigateway.model.RestApi.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.apigateway.model.GetRestApisResponse
  ): zio.aws.apigateway.model.GetRestApisResponse.ReadOnly = new Wrapper(impl)
}
