package zio.aws.apigateway.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class GetSdkTypesResponse(
    position: Optional[String] = Optional.Absent,
    items: Optional[Iterable[zio.aws.apigateway.model.SdkType]] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.apigateway.model.GetSdkTypesResponse = {
    import GetSdkTypesResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.apigateway.model.GetSdkTypesResponse
      .builder()
      .optionallyWith(position.map(value => value: java.lang.String))(
        _.position
      )
      .optionallyWith(
        items.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.items)
      .build()
  }
  def asReadOnly: zio.aws.apigateway.model.GetSdkTypesResponse.ReadOnly =
    zio.aws.apigateway.model.GetSdkTypesResponse.wrap(buildAwsValue())
}
object GetSdkTypesResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.apigateway.model.GetSdkTypesResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.apigateway.model.GetSdkTypesResponse =
      zio.aws.apigateway.model.GetSdkTypesResponse(
        position.map(value => value),
        items.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def position: Optional[String]
    def items: Optional[List[zio.aws.apigateway.model.SdkType.ReadOnly]]
    def getPosition: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("position", position)
    def getItems
        : ZIO[Any, AwsError, List[zio.aws.apigateway.model.SdkType.ReadOnly]] =
      AwsError.unwrapOptionField("items", items)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.apigateway.model.GetSdkTypesResponse
  ) extends zio.aws.apigateway.model.GetSdkTypesResponse.ReadOnly {
    override val position: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.position())
      .map(value => value: String)
    override val items
        : Optional[List[zio.aws.apigateway.model.SdkType.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.items())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.apigateway.model.SdkType.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.apigateway.model.GetSdkTypesResponse
  ): zio.aws.apigateway.model.GetSdkTypesResponse.ReadOnly = new Wrapper(impl)
}
