package zio.aws.apigateway.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class GetUsagePlanKeyRequest(usagePlanId: String, keyId: String) {
  def buildAwsValue()
      : software.amazon.awssdk.services.apigateway.model.GetUsagePlanKeyRequest = {
    import GetUsagePlanKeyRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.apigateway.model.GetUsagePlanKeyRequest
      .builder()
      .usagePlanId(usagePlanId: java.lang.String)
      .keyId(keyId: java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.apigateway.model.GetUsagePlanKeyRequest.ReadOnly =
    zio.aws.apigateway.model.GetUsagePlanKeyRequest.wrap(buildAwsValue())
}
object GetUsagePlanKeyRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.apigateway.model.GetUsagePlanKeyRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.apigateway.model.GetUsagePlanKeyRequest =
      zio.aws.apigateway.model.GetUsagePlanKeyRequest(usagePlanId, keyId)
    def usagePlanId: String
    def keyId: String
    def getUsagePlanId: ZIO[Any, Nothing, String] = ZIO.succeed(usagePlanId)
    def getKeyId: ZIO[Any, Nothing, String] = ZIO.succeed(keyId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.apigateway.model.GetUsagePlanKeyRequest
  ) extends zio.aws.apigateway.model.GetUsagePlanKeyRequest.ReadOnly {
    override val usagePlanId: String = impl.usagePlanId(): String
    override val keyId: String = impl.keyId(): String
  }
  def wrap(
      impl: software.amazon.awssdk.services.apigateway.model.GetUsagePlanKeyRequest
  ): zio.aws.apigateway.model.GetUsagePlanKeyRequest.ReadOnly = new Wrapper(
    impl
  )
}
