package zio.aws.apigateway.model
import zio.aws.apigateway.model.primitives.NullableInteger
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters.*
final case class GetUsagePlansRequest(
    position: Optional[String] = Optional.Absent,
    keyId: Optional[String] = Optional.Absent,
    limit: Optional[NullableInteger] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.apigateway.model.GetUsagePlansRequest = {
    import GetUsagePlansRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.apigateway.model.GetUsagePlansRequest
      .builder()
      .optionallyWith(position.map(value => value: java.lang.String))(
        _.position
      )
      .optionallyWith(keyId.map(value => value: java.lang.String))(_.keyId)
      .optionallyWith(limit.map(value => value: Integer))(_.limit)
      .build()
  }
  def asReadOnly: zio.aws.apigateway.model.GetUsagePlansRequest.ReadOnly =
    zio.aws.apigateway.model.GetUsagePlansRequest.wrap(buildAwsValue())
}
object GetUsagePlansRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.apigateway.model.GetUsagePlansRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.apigateway.model.GetUsagePlansRequest =
      zio.aws.apigateway.model.GetUsagePlansRequest(
        position.map(value => value),
        keyId.map(value => value),
        limit.map(value => value)
      )
    def position: Optional[String]
    def keyId: Optional[String]
    def limit: Optional[NullableInteger]
    def getPosition: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("position", position)
    def getKeyId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("keyId", keyId)
    def getLimit: ZIO[Any, AwsError, NullableInteger] =
      AwsError.unwrapOptionField("limit", limit)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.apigateway.model.GetUsagePlansRequest
  ) extends zio.aws.apigateway.model.GetUsagePlansRequest.ReadOnly {
    override val position: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.position())
      .map(value => value: String)
    override val keyId: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.keyId())
      .map(value => value: String)
    override val limit: Optional[NullableInteger] = zio.aws.core.internal
      .optionalFromNullable(impl.limit())
      .map(value => value: NullableInteger)
  }
  def wrap(
      impl: software.amazon.awssdk.services.apigateway.model.GetUsagePlansRequest
  ): zio.aws.apigateway.model.GetUsagePlansRequest.ReadOnly = new Wrapper(impl)
}
