package zio.aws.apigateway.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class ImportApiKeysResponse(
    ids: Optional[Iterable[String]] = Optional.Absent,
    warnings: Optional[Iterable[String]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.apigateway.model.ImportApiKeysResponse = {
    import ImportApiKeysResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.apigateway.model.ImportApiKeysResponse
      .builder()
      .optionallyWith(
        ids.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.ids)
      .optionallyWith(
        warnings.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.warnings)
      .build()
  }
  def asReadOnly: zio.aws.apigateway.model.ImportApiKeysResponse.ReadOnly =
    zio.aws.apigateway.model.ImportApiKeysResponse.wrap(buildAwsValue())
}
object ImportApiKeysResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.apigateway.model.ImportApiKeysResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.apigateway.model.ImportApiKeysResponse =
      zio.aws.apigateway.model.ImportApiKeysResponse(
        ids.map(value => value),
        warnings.map(value => value)
      )
    def ids: Optional[List[String]]
    def warnings: Optional[List[String]]
    def getIds: ZIO[Any, AwsError, List[String]] =
      AwsError.unwrapOptionField("ids", ids)
    def getWarnings: ZIO[Any, AwsError, List[String]] =
      AwsError.unwrapOptionField("warnings", warnings)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.apigateway.model.ImportApiKeysResponse
  ) extends zio.aws.apigateway.model.ImportApiKeysResponse.ReadOnly {
    override val ids: Optional[List[String]] = zio.aws.core.internal
      .optionalFromNullable(impl.ids())
      .map(value =>
        value.asScala.map { item =>
          item: String
        }.toList
      )
    override val warnings: Optional[List[String]] = zio.aws.core.internal
      .optionalFromNullable(impl.warnings())
      .map(value =>
        value.asScala.map { item =>
          item: String
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.apigateway.model.ImportApiKeysResponse
  ): zio.aws.apigateway.model.ImportApiKeysResponse.ReadOnly = new Wrapper(impl)
}
