package zio.aws.apigateway.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class MethodSnapshot(
    authorizationType: Optional[String] = Optional.Absent,
    apiKeyRequired: Optional[Boolean] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.apigateway.model.MethodSnapshot = {
    import MethodSnapshot.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.apigateway.model.MethodSnapshot
      .builder()
      .optionallyWith(authorizationType.map(value => value: java.lang.String))(
        _.authorizationType
      )
      .optionallyWith(apiKeyRequired.map(value => value: java.lang.Boolean))(
        _.apiKeyRequired
      )
      .build()
  }
  def asReadOnly: zio.aws.apigateway.model.MethodSnapshot.ReadOnly =
    zio.aws.apigateway.model.MethodSnapshot.wrap(buildAwsValue())
}
object MethodSnapshot {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.apigateway.model.MethodSnapshot
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.apigateway.model.MethodSnapshot =
      zio.aws.apigateway.model.MethodSnapshot(
        authorizationType.map(value => value),
        apiKeyRequired.map(value => value)
      )
    def authorizationType: Optional[String]
    def apiKeyRequired: Optional[Boolean]
    def getAuthorizationType: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("authorizationType", authorizationType)
    def getApiKeyRequired: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("apiKeyRequired", apiKeyRequired)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.apigateway.model.MethodSnapshot
  ) extends zio.aws.apigateway.model.MethodSnapshot.ReadOnly {
    override val authorizationType: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.authorizationType())
      .map(value => value: String)
    override val apiKeyRequired: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.apiKeyRequired())
      .map(value => value: Boolean)
  }
  def wrap(
      impl: software.amazon.awssdk.services.apigateway.model.MethodSnapshot
  ): zio.aws.apigateway.model.MethodSnapshot.ReadOnly = new Wrapper(impl)
}
