package zio.aws.apigateway.model
import scala.jdk.CollectionConverters.*
sealed trait Op {
  def unwrap: software.amazon.awssdk.services.apigateway.model.Op
}
object Op {
  def wrap(
      value: software.amazon.awssdk.services.apigateway.model.Op
  ): zio.aws.apigateway.model.Op = value match {
    case software.amazon.awssdk.services.apigateway.model.Op.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.apigateway.model.Op.ADD =>
      val r = add
      r
    case software.amazon.awssdk.services.apigateway.model.Op.REMOVE =>
      val r = remove
      r
    case software.amazon.awssdk.services.apigateway.model.Op.REPLACE =>
      val r = replace
      r
    case software.amazon.awssdk.services.apigateway.model.Op.MOVE =>
      val r = move
      r
    case software.amazon.awssdk.services.apigateway.model.Op.COPY =>
      val r = copy
      r
    case software.amazon.awssdk.services.apigateway.model.Op.TEST =>
      val r = test
      r
  }
  case object unknownToSdkVersion extends zio.aws.apigateway.model.Op {
    override def unwrap: software.amazon.awssdk.services.apigateway.model.Op =
      software.amazon.awssdk.services.apigateway.model.Op.UNKNOWN_TO_SDK_VERSION
  }
  case object add extends zio.aws.apigateway.model.Op {
    override def unwrap: software.amazon.awssdk.services.apigateway.model.Op =
      software.amazon.awssdk.services.apigateway.model.Op.ADD
  }
  case object remove extends zio.aws.apigateway.model.Op {
    override def unwrap: software.amazon.awssdk.services.apigateway.model.Op =
      software.amazon.awssdk.services.apigateway.model.Op.REMOVE
  }
  case object replace extends zio.aws.apigateway.model.Op {
    override def unwrap: software.amazon.awssdk.services.apigateway.model.Op =
      software.amazon.awssdk.services.apigateway.model.Op.REPLACE
  }
  case object move extends zio.aws.apigateway.model.Op {
    override def unwrap: software.amazon.awssdk.services.apigateway.model.Op =
      software.amazon.awssdk.services.apigateway.model.Op.MOVE
  }
  case object copy extends zio.aws.apigateway.model.Op {
    override def unwrap: software.amazon.awssdk.services.apigateway.model.Op =
      software.amazon.awssdk.services.apigateway.model.Op.COPY
  }
  case object test extends zio.aws.apigateway.model.Op {
    override def unwrap: software.amazon.awssdk.services.apigateway.model.Op =
      software.amazon.awssdk.services.apigateway.model.Op.TEST
  }
}
